/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.shift;

import io.quarkus.hibernate.orm.panache.PanacheQuery;
import io.quarkus.hibernate.orm.panache.PanacheRepository;
import io.quarkus.hibernate.orm.panache.runtime.JpaOperations;
import io.quarkus.panache.common.Parameters;
import io.quarkus.panache.common.Sort;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import org.optaweb.employeerostering.domain.employee.Employee;
import org.optaweb.employeerostering.domain.shift.Shift;
import org.optaweb.employeerostering.domain.spot.Spot;

@ApplicationScoped
public class ShiftRepository
implements PanacheRepository<Shift> {
    public List<Shift> findAllByTenantId(Integer tenantId) {
        return this.find("tenantId", Sort.ascending((String[])new String[]{"startDateTime", "spot.name"}), new Object[]{tenantId}).list();
    }

    public List<Shift> findAllByTenantIdBetweenDates(Integer tenantId, OffsetDateTime startDateTime, OffsetDateTime endDateTime) {
        return this.find("tenantId = ?1 and endDateTime >= ?2 and startDateTime < ?3", Sort.ascending((String[])new String[]{"startDateTime", "spot.name"}), new Object[]{tenantId, startDateTime, endDateTime}).list();
    }

    public void deleteForTenant(Integer tenantId) {
        this.delete("tenantId", new Object[]{tenantId});
    }

    public List<Shift> filterWithSpots(Integer tenantId, Set<Spot> spotSet, OffsetDateTime startDateTime, OffsetDateTime endDateTime) {
        if (spotSet.isEmpty()) {
            return Collections.emptyList();
        }
        return this.find("tenantId = ?1 and spot in ?2 and endDateTime >= ?3 and startDateTime < ?4", Sort.ascending((String[])new String[]{"startDateTime", "spot.name"}), new Object[]{tenantId, spotSet, startDateTime, endDateTime}).list();
    }

    public List<Shift> filterWithEmployees(Integer tenantId, Set<Employee> employeeSet, OffsetDateTime startDateTime, OffsetDateTime endDateTime) {
        if (employeeSet.isEmpty()) {
            return Collections.emptyList();
        }
        return this.find("tenantId = ?1 and employee in ?2 and endDateTime >= ?3 and startDateTime < ?4", Sort.ascending((String[])new String[]{"startDateTime", "spot.name"}), new Object[]{tenantId, employeeSet, startDateTime, endDateTime}).list();
    }

    public long count() {
        return JpaOperations.INSTANCE.count(Shift.class);
    }

    public long count(String string, Object[] objectArray) {
        return JpaOperations.INSTANCE.count(Shift.class, string, objectArray);
    }

    public long count(String string, Parameters parameters) {
        return JpaOperations.INSTANCE.count(Shift.class, string, parameters);
    }

    public long count(String string, Map<String, Object> map) {
        return JpaOperations.INSTANCE.count(Shift.class, string, map);
    }

    public long delete(String string, Object[] objectArray) {
        return JpaOperations.INSTANCE.delete(Shift.class, string, objectArray);
    }

    public long delete(String string, Parameters parameters) {
        return JpaOperations.INSTANCE.delete(Shift.class, string, parameters);
    }

    public long delete(String string, Map<String, Object> map) {
        return JpaOperations.INSTANCE.delete(Shift.class, string, map);
    }

    public long deleteAll() {
        return JpaOperations.INSTANCE.deleteAll(Shift.class);
    }

    public boolean deleteById(Long l) {
        return JpaOperations.INSTANCE.deleteById(Shift.class, (Object)l);
    }

    public PanacheQuery<Shift> find(String string, Object[] objectArray) {
        return (PanacheQuery)JpaOperations.INSTANCE.find(Shift.class, string, objectArray);
    }

    public PanacheQuery<Shift> find(String string, Parameters parameters) {
        return (PanacheQuery)JpaOperations.INSTANCE.find(Shift.class, string, parameters);
    }

    public PanacheQuery<Shift> find(String string, Sort sort, Object[] objectArray) {
        return (PanacheQuery)JpaOperations.INSTANCE.find(Shift.class, string, sort, objectArray);
    }

    public PanacheQuery<Shift> find(String string, Sort sort, Parameters parameters) {
        return (PanacheQuery)JpaOperations.INSTANCE.find(Shift.class, string, sort, parameters);
    }

    public PanacheQuery<Shift> find(String string, Sort sort, Map<String, Object> map) {
        return (PanacheQuery)JpaOperations.INSTANCE.find(Shift.class, string, sort, map);
    }

    public PanacheQuery<Shift> find(String string, Map<String, Object> map) {
        return (PanacheQuery)JpaOperations.INSTANCE.find(Shift.class, string, map);
    }

    public PanacheQuery<Shift> findAll() {
        return (PanacheQuery)JpaOperations.INSTANCE.findAll(Shift.class);
    }

    public PanacheQuery<Shift> findAll(Sort sort) {
        return (PanacheQuery)JpaOperations.INSTANCE.findAll(Shift.class, sort);
    }

    public Shift findById(Long l) {
        return (Shift)JpaOperations.INSTANCE.findById(Shift.class, (Object)l);
    }

    public Shift findById(Long l, LockModeType lockModeType) {
        return (Shift)JpaOperations.INSTANCE.findById(Shift.class, (Object)l, lockModeType);
    }

    public Optional<Shift> findByIdOptional(Long l) {
        return JpaOperations.INSTANCE.findByIdOptional(Shift.class, (Object)l);
    }

    public Optional<Shift> findByIdOptional(Long l, LockModeType lockModeType) {
        return JpaOperations.INSTANCE.findByIdOptional(Shift.class, (Object)l, lockModeType);
    }

    public EntityManager getEntityManager() {
        return JpaOperations.INSTANCE.getEntityManager(Shift.class);
    }

    public EntityManager getEntityManager(Class<?> clazz) {
        return JpaOperations.INSTANCE.getEntityManager(Shift.class, clazz);
    }

    public List<Shift> list(String string, Object[] objectArray) {
        return JpaOperations.INSTANCE.list(Shift.class, string, objectArray);
    }

    public List<Shift> list(String string, Parameters parameters) {
        return JpaOperations.INSTANCE.list(Shift.class, string, parameters);
    }

    public List<Shift> list(String string, Sort sort, Object[] objectArray) {
        return JpaOperations.INSTANCE.list(Shift.class, string, sort, objectArray);
    }

    public List<Shift> list(String string, Sort sort, Parameters parameters) {
        return JpaOperations.INSTANCE.list(Shift.class, string, sort, parameters);
    }

    public List<Shift> list(String string, Sort sort, Map<String, Object> map) {
        return JpaOperations.INSTANCE.list(Shift.class, string, sort, map);
    }

    public List<Shift> list(String string, Map<String, Object> map) {
        return JpaOperations.INSTANCE.list(Shift.class, string, map);
    }

    public List<Shift> listAll() {
        return JpaOperations.INSTANCE.listAll(Shift.class);
    }

    public List<Shift> listAll(Sort sort) {
        return JpaOperations.INSTANCE.listAll(Shift.class, sort);
    }

    public Stream<Shift> stream(String string, Object[] objectArray) {
        return JpaOperations.INSTANCE.stream(Shift.class, string, objectArray);
    }

    public Stream<Shift> stream(String string, Parameters parameters) {
        return JpaOperations.INSTANCE.stream(Shift.class, string, parameters);
    }

    public Stream<Shift> stream(String string, Sort sort, Object[] objectArray) {
        return JpaOperations.INSTANCE.stream(Shift.class, string, sort, objectArray);
    }

    public Stream<Shift> stream(String string, Sort sort, Parameters parameters) {
        return JpaOperations.INSTANCE.stream(Shift.class, string, sort, parameters);
    }

    public Stream<Shift> stream(String string, Sort sort, Map<String, Object> map) {
        return JpaOperations.INSTANCE.stream(Shift.class, string, sort, map);
    }

    public Stream<Shift> stream(String string, Map<String, Object> map) {
        return JpaOperations.INSTANCE.stream(Shift.class, string, map);
    }

    public Stream<Shift> streamAll() {
        return JpaOperations.INSTANCE.streamAll(Shift.class);
    }

    public Stream<Shift> streamAll(Sort sort) {
        return JpaOperations.INSTANCE.streamAll(Shift.class, sort);
    }

    public int update(String string, Object[] objectArray) {
        return JpaOperations.INSTANCE.update(Shift.class, string, objectArray);
    }

    public int update(String string, Parameters parameters) {
        return JpaOperations.INSTANCE.update(Shift.class, string, parameters);
    }

    public int update(String string, Map<String, Object> map) {
        return JpaOperations.INSTANCE.update(Shift.class, string, map);
    }
}

