/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner.weight;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Distance;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.plugin.planner.DistanceMapImpl;
import org.optaweb.vehiclerouting.plugin.planner.domain.DistanceMap;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningDepot;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningLocation;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningLocationFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVisit;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVisitFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.SolutionFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.VehicleRoutingSolution;
import org.optaweb.vehiclerouting.plugin.planner.weight.DepotAngleVisitDifficultyWeightFactory;

class DepotAngleVisitDifficultyWeightFactoryTest {
    private final double depotY = 3.0;
    private final double depotX = -50.0;
    private final Map<Long, Distance> depotDistanceMap = new HashMap<Long, Distance>();
    private final PlanningLocation depot;
    private final VehicleRoutingSolution solution = SolutionFactory.emptySolution();
    private final DepotAngleVisitDifficultyWeightFactory weightFactory = new DepotAngleVisitDifficultyWeightFactory();

    DepotAngleVisitDifficultyWeightFactoryTest() {
        Location depotLocation = new Location(0L, Coordinates.valueOf((double)3.0, (double)-50.0));
        this.depot = PlanningLocationFactory.fromDomain((Location)depotLocation, (DistanceMap)new DistanceMapImpl(this.depotDistanceMap::get));
        this.solution.getDepotList().add(new PlanningDepot(this.depot));
    }

    private PlanningLocation location(long id, double latitude, double longitude, long symmetricalDistance) {
        return this.location(id, latitude, longitude, symmetricalDistance, symmetricalDistance);
    }

    private PlanningLocation location(long id, double latitude, double longitude, long depotToLocation, long locationToDepot) {
        this.depotDistanceMap.put(id, Distance.ofMillis((long)depotToLocation));
        HashMap<Long, Distance> locationDistanceMap = new HashMap<Long, Distance>();
        locationDistanceMap.put(this.depot.getId(), Distance.ofMillis((long)locationToDepot));
        Location domainLocation = new Location(id, Coordinates.valueOf((double)latitude, (double)longitude));
        return PlanningLocationFactory.fromDomain((Location)domainLocation, (DistanceMap)new DistanceMapImpl(locationDistanceMap::get));
    }

    private DepotAngleVisitDifficultyWeightFactory.DepotAngleVisitDifficultyWeight weight(PlanningLocation location) {
        return this.weightFactory.createSorterWeight(this.solution, PlanningVisitFactory.fromLocation((PlanningLocation)location));
    }

    @Test
    void visit_weights_should_be_ordered_by_angle_then_by_distance_then_by_id() {
        PlanningLocation center1 = this.location(1L, 3.0, -50.0, 0L);
        PlanningLocation center2 = this.location(2L, 3.0, -50.0, 0L);
        PlanningLocation west = this.location(3L, 3.0, -150.0, 1L);
        PlanningLocation east1 = this.location(10L, 3.0, -13.0, 100L);
        PlanningLocation east2 = this.location(20L, 3.0, 60.010999999999996, 200L);
        PlanningLocation north1 = this.location(30L, 33.0, -50.0, 1L);
        PlanningLocation north2 = this.location(40L, 63.0, -50.0, 2L);
        PlanningLocation sw1 = this.location(50L, -97.0, -150.0, 10000L);
        PlanningLocation south1 = this.location(60L, -97.0, -50.0, 10000L);
        PlanningLocation se1 = this.location(70L, -97.0, 50.0, 10000L);
        Assertions.assertThat(Stream.of(north1, north2, center1, center2, west, sw1, south1, se1, east1, east2).map(this::weight).collect(Collectors.toList())).isSorted();
        Assertions.assertThat((Comparable)this.weight(north1)).isLessThan((Comparable)this.weight(north2));
        Assertions.assertThat((Comparable)this.weight(north2)).isGreaterThan((Comparable)this.weight(north1));
        Assertions.assertThat((Comparable)this.weight(center1)).isLessThan((Comparable)this.weight(center2));
        Assertions.assertThat((Comparable)this.weight(center2)).isGreaterThan((Comparable)this.weight(center1));
        Assertions.assertThat((Comparable)this.weight(center2)).isEqualByComparingTo((Comparable)this.weight(center2));
    }

    @Test
    void locations_with_asymmetrical_distances_should_be_sorted_by_round_trip_time() {
        PlanningLocation a = this.location(101L, 3.0, -50.0, 101L, 90L);
        PlanningLocation b = this.location(102L, 3.0, -50.0, 100L, 100L);
        PlanningLocation c = this.location(103L, 3.0, -50.0, 200L, 50L);
        Assertions.assertThat((Comparable)this.weight(a)).isLessThan((Comparable)this.weight(b));
        Assertions.assertThat((Comparable)this.weight(b)).isLessThan((Comparable)this.weight(c));
    }

    @Test
    void equals() {
        long id = 3L;
        double angle = Math.PI;
        long distance = 1000L;
        PlanningVisit visit = PlanningVisitFactory.testVisit((long)id);
        DepotAngleVisitDifficultyWeightFactory.DepotAngleVisitDifficultyWeight weight = new DepotAngleVisitDifficultyWeightFactory.DepotAngleVisitDifficultyWeight(visit, angle, distance);
        Assertions.assertThat((Comparable)weight).isNotEqualTo(null);
        Assertions.assertThat((Comparable)weight).isNotEqualTo((Object)this);
        Assertions.assertThat((Comparable)weight).isNotEqualTo((Object)new DepotAngleVisitDifficultyWeightFactory.DepotAngleVisitDifficultyWeight(PlanningVisitFactory.testVisit((long)(id + 1L)), angle, distance));
        Assertions.assertThat((Comparable)weight).isNotEqualTo((Object)new DepotAngleVisitDifficultyWeightFactory.DepotAngleVisitDifficultyWeight(PlanningVisitFactory.testVisit((long)id), -angle, distance));
        Assertions.assertThat((Comparable)weight).isNotEqualTo((Object)new DepotAngleVisitDifficultyWeightFactory.DepotAngleVisitDifficultyWeight(PlanningVisitFactory.testVisit((long)id), angle, distance - 1L));
        Assertions.assertThat((Comparable)weight).isEqualTo((Object)weight);
        Assertions.assertThat((Comparable)weight).isEqualTo((Object)new DepotAngleVisitDifficultyWeightFactory.DepotAngleVisitDifficultyWeight(visit, angle, distance));
    }
}

