/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.service.location;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.service.location.DistanceMatrix;
import org.optaweb.vehiclerouting.service.location.DistanceMatrixRow;
import org.optaweb.vehiclerouting.service.location.LocationRepository;
import org.optaweb.vehiclerouting.service.location.LocationService;
import org.optaweb.vehiclerouting.service.location.RouteOptimizer;

@ExtendWith(value={MockitoExtension.class})
class LocationServiceTest {
    @Mock
    private LocationRepository repository;
    @Mock
    private RouteOptimizer optimizer;
    @Mock
    private DistanceMatrix distanceMatrix;
    @Mock
    private DistanceMatrixRow matrixRow;
    @InjectMocks
    private LocationService locationService;
    private final Coordinates coordinates = Coordinates.valueOf((double)0.0, (double)1.0);
    private final Location location = new Location(1L, this.coordinates);

    LocationServiceTest() {
    }

    @Test
    void createLocation_should_validate_arguments() {
        Assertions.assertThatNullPointerException().isThrownBy(() -> this.locationService.createLocation(null, "x"));
        Assertions.assertThatNullPointerException().isThrownBy(() -> this.locationService.createLocation(this.coordinates, null));
    }

    @Test
    void createLocation() {
        String description = "new location";
        Mockito.when((Object)this.repository.createLocation(this.coordinates, description)).thenReturn((Object)this.location);
        Mockito.when((Object)this.distanceMatrix.addLocation((Location)ArgumentMatchers.any())).thenReturn((Object)this.matrixRow);
        Assertions.assertThat((boolean)this.locationService.createLocation(this.coordinates, description)).isTrue();
        ((LocationRepository)Mockito.verify((Object)this.repository)).createLocation(this.coordinates, description);
        ((DistanceMatrix)Mockito.verify((Object)this.distanceMatrix)).addLocation(this.location);
        ((RouteOptimizer)Mockito.verify((Object)this.optimizer)).addLocation(this.location, this.matrixRow);
    }

    @Test
    void addLocation_should_validate_arguments() {
        Assertions.assertThatNullPointerException().isThrownBy(() -> this.locationService.addLocation(null));
    }

    @Test
    void addLocation() {
        Mockito.when((Object)this.distanceMatrix.addLocation((Location)ArgumentMatchers.any())).thenReturn((Object)this.matrixRow);
        Assertions.assertThat((boolean)this.locationService.addLocation(this.location)).isTrue();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.repository});
        ((DistanceMatrix)Mockito.verify((Object)this.distanceMatrix)).addLocation(this.location);
        ((RouteOptimizer)Mockito.verify((Object)this.optimizer)).addLocation(this.location, this.matrixRow);
    }

    @Test
    void removeLocation() {
        Mockito.when((Object)this.repository.removeLocation(this.location.id())).thenReturn((Object)this.location);
        this.locationService.removeLocation(this.location.id());
        ((LocationRepository)Mockito.verify((Object)this.repository)).removeLocation(this.location.id());
        ((RouteOptimizer)Mockito.verify((Object)this.optimizer)).removeLocation(this.location);
    }

    @Test
    void clear() {
        this.locationService.removeAll();
        ((RouteOptimizer)Mockito.verify((Object)this.optimizer)).removeAllLocations();
        ((DistanceMatrix)Mockito.verify((Object)this.distanceMatrix)).clear();
        ((LocationRepository)Mockito.verify((Object)this.repository)).removeAll();
    }

    @Test
    void should_not_optimize_and_roll_back_if_distance_calculation_fails() {
        Mockito.when((Object)this.repository.createLocation(this.coordinates, "")).thenReturn((Object)this.location);
        ((DistanceMatrix)Mockito.doThrow(RuntimeException.class).when((Object)this.distanceMatrix)).addLocation(this.location);
        Assertions.assertThat((boolean)this.locationService.createLocation(this.coordinates, "")).isFalse();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.optimizer});
        ((LocationRepository)Mockito.verify((Object)this.repository)).removeLocation(this.location.id());
    }
}

