/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner.weight;

import java.util.Comparator;
import java.util.Objects;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningDepot;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVisit;
import org.optaweb.vehiclerouting.plugin.planner.domain.VehicleRoutingSolution;

public class DepotAngleVisitDifficultyWeightFactory
implements SelectionSorterWeightFactory<VehicleRoutingSolution, PlanningVisit> {
    public DepotAngleVisitDifficultyWeight createSorterWeight(VehicleRoutingSolution solution, PlanningVisit visit) {
        PlanningDepot depot = solution.getDepotList().get(0);
        return new DepotAngleVisitDifficultyWeight(visit, visit.getLocation().angleTo(depot.getLocation()), visit.getLocation().distanceTo(depot.getLocation()) + depot.getLocation().distanceTo(visit.getLocation()));
    }

    static class DepotAngleVisitDifficultyWeight
    implements Comparable<DepotAngleVisitDifficultyWeight> {
        private static final Comparator<DepotAngleVisitDifficultyWeight> COMPARATOR = Comparator.comparingDouble(weight -> weight.depotAngle).thenComparingLong(weight -> weight.depotRoundTripDistance).thenComparing(weight -> weight.visit, Comparator.comparingLong(PlanningVisit::getId));
        private final PlanningVisit visit;
        private final double depotAngle;
        private final long depotRoundTripDistance;

        DepotAngleVisitDifficultyWeight(PlanningVisit visit, double depotAngle, long depotRoundTripDistance) {
            this.visit = visit;
            this.depotAngle = depotAngle;
            this.depotRoundTripDistance = depotRoundTripDistance;
        }

        @Override
        public int compareTo(DepotAngleVisitDifficultyWeight other) {
            return COMPARATOR.compare(this, other);
        }

        public boolean equals(Object o) {
            if (!(o instanceof DepotAngleVisitDifficultyWeight)) {
                return false;
            }
            return this.compareTo((DepotAngleVisitDifficultyWeight)o) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.visit, this.depotAngle, this.depotRoundTripDistance);
        }

        public String toString() {
            return "DepotAngleVisitDifficultyWeight{visit=" + this.visit + ", depotAngle=" + this.depotAngle + ", depotRoundTripDistance=" + this.depotRoundTripDistance + '}';
        }
    }
}

