/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner.domain;

import java.util.ArrayList;
import java.util.List;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningDepot;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicle;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVisit;
import org.optaweb.vehiclerouting.plugin.planner.domain.VehicleRoutingSolution;

public class SolutionFactory {
    private SolutionFactory() {
        throw new AssertionError((Object)"Utility class");
    }

    public static VehicleRoutingSolution emptySolution() {
        VehicleRoutingSolution solution = new VehicleRoutingSolution();
        solution.setVisitList(new ArrayList<PlanningVisit>());
        solution.setDepotList(new ArrayList<PlanningDepot>());
        solution.setVehicleList(new ArrayList<PlanningVehicle>());
        solution.setScore(HardSoftLongScore.ZERO);
        return solution;
    }

    public static VehicleRoutingSolution solutionFromVisits(List<PlanningVehicle> vehicles, PlanningDepot depot, List<PlanningVisit> visits) {
        VehicleRoutingSolution solution = new VehicleRoutingSolution();
        solution.setVehicleList(new ArrayList<PlanningVehicle>(vehicles));
        solution.setDepotList(new ArrayList<PlanningDepot>(1));
        if (depot != null) {
            solution.getDepotList().add(depot);
            SolutionFactory.moveAllVehiclesToDepot(vehicles, depot);
        }
        solution.setVisitList(new ArrayList<PlanningVisit>(visits));
        solution.setScore(HardSoftLongScore.ZERO);
        return solution;
    }

    private static void moveAllVehiclesToDepot(List<PlanningVehicle> vehicles, PlanningDepot depot) {
        vehicles.forEach(vehicle -> vehicle.setDepot(depot));
    }
}

