/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.websocket;

import org.optaweb.vehiclerouting.plugin.websocket.PortableErrorMessage;
import org.optaweb.vehiclerouting.service.error.ErrorMessage;
import org.optaweb.vehiclerouting.service.error.ErrorMessageConsumer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Component;

@Component
class WebSocketErrorMessageSender
implements ErrorMessageConsumer {
    static final String TOPIC_ERROR = "/topic/error";
    private final SimpMessagingTemplate webSocket;

    @Autowired
    WebSocketErrorMessageSender(SimpMessagingTemplate webSocket) {
        this.webSocket = webSocket;
    }

    @Override
    public void consumeMessage(ErrorMessage message) {
        this.webSocket.convertAndSend((Object)TOPIC_ERROR, (Object)PortableErrorMessage.fromMessage(message));
    }
}

