/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.persistence;

import java.math.BigDecimal;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaweb.vehiclerouting.plugin.persistence.LocationEntity;

class LocationEntityTest {
    LocationEntityTest() {
    }

    @Test
    void constructor_params_must_not_be_null() {
        Assertions.assertThatNullPointerException().isThrownBy(() -> new LocationEntity(0L, null, BigDecimal.ZERO, ""));
        Assertions.assertThatNullPointerException().isThrownBy(() -> new LocationEntity(0L, BigDecimal.ZERO, null, ""));
        Assertions.assertThatNullPointerException().isThrownBy(() -> new LocationEntity(0L, BigDecimal.ZERO, BigDecimal.ONE, null));
    }

    @Test
    void getters() {
        int id = 10;
        BigDecimal latitude = BigDecimal.valueOf(0.101);
        BigDecimal longitude = BigDecimal.valueOf(101.0);
        String description = "Description.";
        LocationEntity locationEntity = new LocationEntity((long)id, latitude, longitude, description);
        Assertions.assertThat((long)locationEntity.getId()).isEqualTo((long)id);
        Assertions.assertThat((BigDecimal)locationEntity.getLongitude()).isEqualTo((Object)longitude);
        Assertions.assertThat((BigDecimal)locationEntity.getLatitude()).isEqualTo((Object)latitude);
        Assertions.assertThat((String)locationEntity.getDescription()).isEqualTo(description);
    }
}

