/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner.change;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.core.api.solver.change.ProblemChange;
import org.optaweb.vehiclerouting.plugin.planner.MockSolver;
import org.optaweb.vehiclerouting.plugin.planner.change.AddVehicle;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicle;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicleFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.SolutionFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.VehicleRoutingSolution;

class AddVehicleTest {
    AddVehicleTest() {
    }

    @Test
    void add_vehicle_should_add_vehicle() {
        VehicleRoutingSolution solution = SolutionFactory.emptySolution();
        MockSolver<VehicleRoutingSolution> mockSolver = MockSolver.build(solution);
        PlanningVehicle vehicle = PlanningVehicleFactory.testVehicle((long)1L);
        mockSolver.addProblemChange((ProblemChange<VehicleRoutingSolution>)new AddVehicle(vehicle));
        Assertions.assertThat((List)solution.getVehicleList()).containsExactly((Object[])new PlanningVehicle[]{vehicle});
        mockSolver.verifyProblemFactAdded(vehicle);
    }
}

