/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner.change;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.core.api.solver.change.ProblemChange;
import org.optaweb.vehiclerouting.plugin.planner.MockSolver;
import org.optaweb.vehiclerouting.plugin.planner.change.ChangeVehicleCapacity;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicle;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicleFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.SolutionFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.VehicleRoutingSolution;

class ChangeVehicleCapacityTest {
    ChangeVehicleCapacityTest() {
    }

    @Test
    void change_vehicle_capacity() {
        int oldCapacity = 100;
        int newCapacity = 50;
        MockSolver<VehicleRoutingSolution> mockSolver = MockSolver.build(SolutionFactory.emptySolution());
        PlanningVehicle workingVehicle = PlanningVehicleFactory.testVehicle((long)1L, (int)oldCapacity);
        PlanningVehicle changeVehicle = PlanningVehicleFactory.testVehicle((long)2L, (int)newCapacity);
        mockSolver.whenLookingUp(changeVehicle).thenReturn((Object)workingVehicle);
        mockSolver.addProblemChange((ProblemChange<VehicleRoutingSolution>)new ChangeVehicleCapacity(changeVehicle));
        Assertions.assertThat((int)workingVehicle.getCapacity()).isEqualTo(newCapacity);
        mockSolver.verifyProblemPropertyChanged(changeVehicle);
    }
}

