/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.rest.model;

import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.optaweb.vehiclerouting.plugin.rest.model.PortableErrorMessage;
import org.optaweb.vehiclerouting.service.error.ErrorMessage;
import org.optaweb.vehiclerouting.util.jackson.JacksonAssertions;
import org.optaweb.vehiclerouting.util.junit.FileContent;

class PortableErrorMessageTest {
    PortableErrorMessageTest() {
    }

    @Test
    void marshal_to_json(@FileContent(value="portable-error-message.json") String expectedJson) {
        String id = "c670dd37-62fb-4e86-95ed-c1f4953aaeaa";
        String text = "Error message.\nDetails.";
        PortableErrorMessage portableErrorMessage = PortableErrorMessage.fromMessage((ErrorMessage)ErrorMessage.of((String)id, (String)text));
        JacksonAssertions.assertThat(portableErrorMessage).serializedIsEqualToJson(expectedJson);
    }

    @Test
    void factory_method() {
        String id = "id";
        String text = "error";
        PortableErrorMessage portableErrorMessage = PortableErrorMessage.fromMessage((ErrorMessage)ErrorMessage.of((String)id, (String)text));
        Assertions.assertThat((String)portableErrorMessage.getId()).isEqualTo(id);
        Assertions.assertThat((String)portableErrorMessage.getText()).isEqualTo(text);
    }

    @Test
    void equals_hashCode_toString() {
        String id = "1";
        String text = "error message";
        ErrorMessage message = ErrorMessage.of((String)id, (String)text);
        PortableErrorMessage portableErrorMessage = PortableErrorMessage.fromMessage((ErrorMessage)message);
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)portableErrorMessage).isNotEqualTo(null)).isNotEqualTo((Object)new PortableErrorMessage("", text))).isNotEqualTo((Object)new PortableErrorMessage(id, ""))).isNotEqualTo((Object)message)).isEqualTo((Object)portableErrorMessage)).isEqualTo((Object)new PortableErrorMessage(id, text))).hasSameHashCodeAs((Object)new PortableErrorMessage(id, text))).asString().contains(new CharSequence[]{id, text});
    }
}

