/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.service.error;

import javax.enterprise.event.Event;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.optaweb.vehiclerouting.service.error.ErrorEvent;
import org.optaweb.vehiclerouting.service.error.ErrorListener;
import org.optaweb.vehiclerouting.service.error.ErrorMessage;

@ExtendWith(value={MockitoExtension.class})
class ErrorListenerTest {
    @Captor
    private ArgumentCaptor<ErrorMessage> argumentCaptor;

    ErrorListenerTest() {
    }

    @Test
    void should_pass_error_message_to_consumer(@Mock Event<ErrorMessage> errorMessageEvent) {
        String text = "error";
        ErrorListener errorListener = new ErrorListener(errorMessageEvent);
        errorListener.onErrorEvent(new ErrorEvent((Object)this, text));
        ((Event)Mockito.verify(errorMessageEvent)).fire((Object)((ErrorMessage)this.argumentCaptor.capture()));
        ErrorMessage capturedMessage = (ErrorMessage)this.argumentCaptor.getValue();
        Assertions.assertThat((String)capturedMessage.text).isEqualTo(text);
        Assertions.assertThat((String)capturedMessage.id).isNotNull();
    }
}

