/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.util.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.StringAssert;

public class JsonAssert
extends StringAssert {
    private final ObjectMapper objectMapper = new ObjectMapper();

    protected JsonAssert(String actual) {
        super(actual);
    }

    public void deserializedIsEqualTo(Object expected) {
        this.isNotNull();
        try {
            Object value = this.objectMapper.readValue((String)this.actual, expected.getClass());
            Assertions.assertThat((Object)value).isEqualTo(expected);
        }
        catch (JsonProcessingException e) {
            throw new AssertionError("ObjectMapper.readValue(actual, expected.getClass()) called with actual: <" + (String)this.actual + "> and expected: <" + e + "> threw an exception.", e);
        }
    }
}

