/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.common.inliner;

import java.util.Arrays;
import org.optaplanner.constraint.streams.common.inliner.AbstractScoreInliner;
import org.optaplanner.constraint.streams.common.inliner.UndoScoreImpacter;
import org.optaplanner.constraint.streams.common.inliner.WeightedScoreImpacter;
import org.optaplanner.core.api.score.buildin.bendable.BendableScore;
import org.optaplanner.core.api.score.stream.Constraint;

final class BendableScoreInliner
extends AbstractScoreInliner<BendableScore> {
    private final int[] hardScores;
    private final int[] softScores;

    BendableScoreInliner(boolean constraintMatchEnabled, int hardLevelsSize, int softLevelsSize) {
        super(constraintMatchEnabled);
        this.hardScores = new int[hardLevelsSize];
        this.softScores = new int[softLevelsSize];
    }

    @Override
    public WeightedScoreImpacter buildWeightedScoreImpacter(Constraint constraint, BendableScore constraintWeight) {
        this.validateConstraintWeight(constraint, constraintWeight);
        Integer singleLevel = null;
        for (int i = 0; i < constraintWeight.getLevelsSize(); ++i) {
            if ((long)constraintWeight.getHardOrSoftScore(i) == 0L) continue;
            if (singleLevel != null) {
                singleLevel = null;
                break;
            }
            singleLevel = i;
        }
        if (singleLevel != null) {
            int levelWeight = constraintWeight.getHardOrSoftScore(singleLevel.intValue());
            if (singleLevel < constraintWeight.getHardLevelsSize()) {
                int level = singleLevel;
                return WeightedScoreImpacter.of((matchWeight, justificationsSupplier) -> {
                    int hardImpact = levelWeight * matchWeight;
                    int n = level;
                    this.hardScores[n] = this.hardScores[n] + hardImpact;
                    UndoScoreImpacter undoScoreImpact = () -> {
                        int n = level;
                        this.hardScores[n] = this.hardScores[n] - hardImpact;
                    };
                    if (!this.constraintMatchEnabled) {
                        return undoScoreImpact;
                    }
                    Runnable undoConstraintMatch = this.addConstraintMatch(constraint, constraintWeight, BendableScore.ofHard((int)this.hardScores.length, (int)this.softScores.length, (int)level, (int)hardImpact), justificationsSupplier);
                    return () -> {
                        undoScoreImpact.run();
                        undoConstraintMatch.run();
                    };
                });
            }
            int level = singleLevel - constraintWeight.getHardLevelsSize();
            return WeightedScoreImpacter.of((matchWeight, justificationsSupplier) -> {
                int softImpact = levelWeight * matchWeight;
                int n = level;
                this.softScores[n] = this.softScores[n] + softImpact;
                UndoScoreImpacter undoScoreImpact = () -> {
                    int n = level;
                    this.softScores[n] = this.softScores[n] - softImpact;
                };
                if (!this.constraintMatchEnabled) {
                    return undoScoreImpact;
                }
                Runnable undoConstraintMatch = this.addConstraintMatch(constraint, constraintWeight, BendableScore.ofSoft((int)this.hardScores.length, (int)this.softScores.length, (int)level, (int)softImpact), justificationsSupplier);
                return () -> {
                    undoScoreImpact.run();
                    undoConstraintMatch.run();
                };
            });
        }
        return WeightedScoreImpacter.of((matchWeight, justificationsSupplier) -> {
            int i;
            int[] hardImpacts = new int[this.hardScores.length];
            int[] softImpacts = new int[this.softScores.length];
            for (i = 0; i < hardImpacts.length; ++i) {
                hardImpacts[i] = constraintWeight.getHardScore(i) * matchWeight;
                int n = i;
                this.hardScores[n] = this.hardScores[n] + hardImpacts[i];
            }
            for (i = 0; i < softImpacts.length; ++i) {
                softImpacts[i] = constraintWeight.getSoftScore(i) * matchWeight;
                int n = i;
                this.softScores[n] = this.softScores[n] + softImpacts[i];
            }
            UndoScoreImpacter undoScoreImpact = () -> {
                int i;
                for (i = 0; i < hardImpacts.length; ++i) {
                    int n = i;
                    this.hardScores[n] = this.hardScores[n] - hardImpacts[i];
                }
                for (i = 0; i < softImpacts.length; ++i) {
                    int n = i;
                    this.softScores[n] = this.softScores[n] - softImpacts[i];
                }
            };
            if (!this.constraintMatchEnabled) {
                return undoScoreImpact;
            }
            Runnable undoConstraintMatch = this.addConstraintMatch(constraint, constraintWeight, BendableScore.of((int[])hardImpacts, (int[])softImpacts), justificationsSupplier);
            return () -> {
                undoScoreImpact.run();
                undoConstraintMatch.run();
            };
        });
    }

    @Override
    public BendableScore extractScore(int initScore) {
        return BendableScore.ofUninitialized((int)initScore, (int[])Arrays.copyOf(this.hardScores, this.hardScores.length), (int[])Arrays.copyOf(this.softScores, this.softScores.length));
    }

    public String toString() {
        return BendableScore.class.getSimpleName() + " inliner";
    }
}

