/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.routing;

import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.reader.osm.GraphHopperOSM;
import com.graphhopper.util.PointList;
import com.graphhopper.util.shapes.BBox;
import io.quarkus.arc.properties.IfBuildProperty;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.service.distance.DistanceCalculationException;
import org.optaweb.vehiclerouting.service.distance.DistanceCalculator;
import org.optaweb.vehiclerouting.service.region.BoundingBox;
import org.optaweb.vehiclerouting.service.region.Region;
import org.optaweb.vehiclerouting.service.route.Router;

@ApplicationScoped
@IfBuildProperty(name="app.routing.engine", stringValue="GRAPHHOPPER", enableIfMissing=true)
class GraphHopperRouter
implements Router,
DistanceCalculator,
Region {
    private final GraphHopperOSM graphHopper;

    public GraphHopperRouter() {
    }

    @Inject
    GraphHopperRouter(GraphHopperOSM graphHopper) {
        this.graphHopper = graphHopper;
    }

    public List<Coordinates> getPath(Coordinates from, Coordinates to) {
        GHRequest ghRequest = new GHRequest(from.latitude().doubleValue(), from.longitude().doubleValue(), to.latitude().doubleValue(), to.longitude().doubleValue());
        PointList points = this.graphHopper.route(ghRequest).getBest().getPoints();
        return StreamSupport.stream(points.spliterator(), false).map(ghPoint3D -> Coordinates.of((double)ghPoint3D.lat, (double)ghPoint3D.lon)).collect(Collectors.toList());
    }

    public long travelTimeMillis(Coordinates from, Coordinates to) {
        GHRequest ghRequest = new GHRequest(from.latitude().doubleValue(), from.longitude().doubleValue(), to.latitude().doubleValue(), to.longitude().doubleValue());
        GHResponse ghResponse = this.graphHopper.route(ghRequest);
        if (ghResponse.hasErrors()) {
            throw new DistanceCalculationException("No route from " + from + " to " + to, (Throwable)ghResponse.getErrors().get(0));
        }
        return ghResponse.getBest().getTime();
    }

    public BoundingBox getBounds() {
        BBox bounds = this.graphHopper.getGraphHopperStorage().getBounds();
        return new BoundingBox(Coordinates.of((double)bounds.minLat, (double)bounds.minLon), Coordinates.of((double)bounds.maxLat, (double)bounds.maxLon));
    }
}

