/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.coll;

import com.graphhopper.coll.LongIntMap;
import com.graphhopper.storage.DataAccess;
import com.graphhopper.storage.Directory;
import com.graphhopper.util.BitUtil;

public class OSMIDMap
implements LongIntMap {
    private static final BitUtil bitUtil = BitUtil.LITTLE;
    private final DataAccess keys;
    private final DataAccess values;
    private final int noEntryValue;
    private final Directory dir;
    private long lastKey = Long.MIN_VALUE;
    private long size;

    public OSMIDMap(Directory dir) {
        this(dir, -1);
    }

    public OSMIDMap(Directory dir, int noNumber) {
        this.dir = dir;
        this.noEntryValue = noNumber;
        this.keys = dir.find("osmid_map_keys");
        this.keys.create(2000L);
        this.values = dir.find("osmid_map_values");
        this.values.create(1000L);
    }

    static long binarySearch(DataAccess da, long start, long len, long key) {
        long tmp;
        long high = start + len;
        long low = start - 1L;
        byte[] longBytes = new byte[8];
        while (high - low > 1L) {
            long guess = high + low >>> 1;
            tmp = guess << 3;
            da.getBytes(tmp, longBytes, 8);
            long guessedKey = bitUtil.toLong(longBytes);
            if (guessedKey < key) {
                low = guess;
                continue;
            }
            high = guess;
        }
        if (high == start + len) {
            return start + len ^ 0xFFFFFFFFFFFFFFFFL;
        }
        tmp = high << 3;
        da.getBytes(tmp, longBytes, 8);
        long highKey = bitUtil.toLong(longBytes);
        if (highKey == key) {
            return high;
        }
        return high ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public void remove() {
        this.dir.remove(this.keys);
    }

    @Override
    public int put(long key, int value) {
        if (key <= this.lastKey) {
            long oldValueIndex = OSMIDMap.binarySearch(this.keys, 0L, this.getSize(), key);
            if (oldValueIndex < 0L) {
                throw new IllegalStateException("Cannot insert keys lower than the last key " + key + " < " + this.lastKey + ". Only updating supported");
            }
            int oldValue = this.values.getInt(oldValueIndex *= 4L);
            this.values.setInt(oldValueIndex, value);
            return oldValue;
        }
        this.values.ensureCapacity(this.size + 4L);
        this.values.setInt(this.size, value);
        long doubleSize = this.size * 2L;
        this.keys.ensureCapacity(doubleSize + 8L);
        byte[] longBytes = bitUtil.fromLong(key);
        this.keys.setBytes(doubleSize, longBytes, 8);
        this.lastKey = key;
        this.size += 4L;
        return -1;
    }

    @Override
    public int get(long key) {
        long retIndex = OSMIDMap.binarySearch(this.keys, 0L, this.getSize(), key);
        if (retIndex < 0L) {
            return this.noEntryValue;
        }
        return this.values.getInt(retIndex * 4L);
    }

    @Override
    public long getSize() {
        return this.size / 4L;
    }

    public long getCapacity() {
        return this.keys.getCapacity();
    }

    @Override
    public int getMemoryUsage() {
        return Math.round(this.getCapacity() / 0x100000L);
    }

    @Override
    public void optimize() {
    }
}

