/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.profiles;

import com.graphhopper.util.Helper;

public enum RoadClass {
    OTHER("other"),
    MOTORWAY("motorway"),
    TRUNK("trunk"),
    PRIMARY("primary"),
    SECONDARY("secondary"),
    TERTIARY("tertiary"),
    RESIDENTIAL("residential"),
    UNCLASSIFIED("unclassified"),
    SERVICE("service"),
    ROAD("road"),
    TRACK("track"),
    BRIDLEWAY("bridleway"),
    STEPS("steps"),
    CYCLEWAY("cycleway"),
    PATH("path"),
    LIVING_STREET("living_street");

    public static final String KEY = "road_class";
    private final String name;

    private RoadClass(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static RoadClass find(String name) {
        if (name == null) {
            return OTHER;
        }
        try {
            return RoadClass.valueOf(Helper.toUpperCase((String)name));
        }
        catch (IllegalArgumentException ex) {
            return OTHER;
        }
    }
}

