/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class FieldBasedScalingSet<E>
implements Set<E> {
    private final Supplier<Set<E>> setSupplier;
    private E singletonValue;
    private Set<E> set;
    private int size = 0;

    public FieldBasedScalingSet(Supplier<Set<E>> setSupplier) {
        this.setSupplier = Objects.requireNonNull(setSupplier);
    }

    @Override
    public boolean add(E value) {
        boolean added;
        if (this.set == null) {
            if (this.size == 0) {
                this.singletonValue = value;
                this.size = 1;
                return true;
            }
            if (this.size == 1) {
                this.set = this.setSupplier.get();
                this.set.add(this.singletonValue);
                this.singletonValue = null;
            } else {
                throw new IllegalStateException("Impossible state: size (" + this.size + ") > 1 yet no set used.");
            }
        }
        if (added = this.set.add(value)) {
            ++this.size;
        }
        return added;
    }

    @Override
    public void clear() {
        if (this.set == null) {
            this.singletonValue = null;
        } else {
            this.set.clear();
        }
        this.size = 0;
    }

    @Override
    public boolean remove(Object value) {
        if (this.set == null) {
            if (!Objects.equals(this.singletonValue, value)) {
                return false;
            }
            this.singletonValue = null;
            this.size = 0;
            return true;
        }
        boolean removed = this.set.remove(value);
        if (removed) {
            --this.size;
        }
        return removed;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        int sizeBefore = this.size;
        for (E o : c) {
            this.add(o);
        }
        return sizeBefore < this.size;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this.size == 0) {
            return false;
        }
        if (this.set == null) {
            if (!c.contains(this.singletonValue)) {
                this.clear();
                return true;
            }
            return false;
        }
        return this.set.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        int sizeBefore = this.size;
        for (Object o : c) {
            this.remove(o);
        }
        return sizeBefore > this.size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object value) {
        if (this.size == 0) {
            return false;
        }
        if (this.set == null) {
            return Objects.equals(value, this.singletonValue);
        }
        return this.set.contains(value);
    }

    @Override
    public Iterator<E> iterator() {
        if (this.size == 0) {
            return Collections.emptyIterator();
        }
        return Objects.requireNonNullElseGet(this.set, () -> Collections.singleton(this.singletonValue)).iterator();
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        if (this.size == 0) {
            return;
        }
        if (this.set == null) {
            action.accept(this.singletonValue);
        } else {
            this.set.forEach(action);
        }
    }

    @Override
    public Object[] toArray() {
        if (this.size == 0) {
            return new Object[0];
        }
        if (this.set == null) {
            return new Object[]{this.singletonValue};
        }
        return this.set.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (this.size == 0) {
            return Arrays.copyOf(a, 0);
        }
        if (this.set == null) {
            T[] copy = Arrays.copyOf(a, 1);
            copy[0] = this.singletonValue;
            return copy;
        }
        return this.set.toArray(a);
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        if (this.set == null) {
            return "[" + this.singletonValue + "]";
        }
        return this.set.toString();
    }
}

