/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ClientProxy;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.InjectableInstance;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.WithCaching;
import io.quarkus.arc.impl.ArcContainerImpl;
import io.quarkus.arc.impl.CreationalContextImpl;
import io.quarkus.arc.impl.CurrentInjectionPointProvider;
import io.quarkus.arc.impl.InjectionPointProvider;
import io.quarkus.arc.impl.Instances;
import io.quarkus.arc.impl.LazyInstanceHandle;
import io.quarkus.arc.impl.LazyValue;
import io.quarkus.arc.impl.SingletonContext;
import io.quarkus.arc.impl.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.AmbiguousResolutionException;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.util.TypeLiteral;
import javax.inject.Provider;
import javax.inject.Singleton;

public class InstanceImpl<T>
implements InjectableInstance<T> {
    private final CreationalContextImpl<?> creationalContext;
    private final List<InjectableBean<?>> resolvedBeans;
    private final Type requiredType;
    private final Set<Annotation> requiredQualifiers;
    private final Type injectionPointType;
    private final InjectableBean<?> targetBean;
    private final Set<Annotation> annotations;
    private final Member javaMember;
    private final int position;
    private final LazyValue<T> cachedGetResult;

    static <T> InstanceImpl<T> of(Type requiredType, Set<Annotation> requiredQualifiers) {
        return new InstanceImpl<T>(null, null, requiredType, requiredQualifiers, new CreationalContextImpl(null), Collections.emptySet(), null, -1);
    }

    InstanceImpl(InjectableBean<?> targetBean, Type type, Set<Annotation> qualifiers, CreationalContextImpl<?> creationalContext, Set<Annotation> annotations, Member javaMember, int position) {
        this(targetBean, type, InstanceImpl.getRequiredType(type), qualifiers, creationalContext, annotations, javaMember, position);
    }

    private InstanceImpl(InstanceImpl<?> parent, Type requiredType, Set<Annotation> requiredQualifiers) {
        this(parent.targetBean, parent.injectionPointType, requiredType, requiredQualifiers, parent.creationalContext, parent.annotations, parent.javaMember, parent.position);
    }

    InstanceImpl(InjectableBean<?> targetBean, Type injectionPointType, Type requiredType, Set<Annotation> requiredQualifiers, CreationalContextImpl<?> creationalContext, Set<Annotation> annotations, Member javaMember, int position) {
        this.injectionPointType = injectionPointType;
        this.requiredType = requiredType;
        this.requiredQualifiers = requiredQualifiers != null ? requiredQualifiers : Collections.emptySet();
        this.creationalContext = creationalContext;
        this.resolvedBeans = this.requiredQualifiers.isEmpty() && Object.class.equals((Object)requiredType) ? null : this.resolve();
        this.targetBean = targetBean;
        this.annotations = annotations;
        this.javaMember = javaMember;
        this.position = position;
        this.cachedGetResult = this.isGetCached(annotations) ? new LazyValue<Object>(this::getInternal) : null;
    }

    @Override
    public Iterator<T> iterator() {
        return new InstanceIterator(this.beans());
    }

    public T get() {
        return this.cachedGetResult != null ? this.cachedGetResult.get() : this.getInternal();
    }

    @Override
    public InjectableInstance<T> select(Annotation ... qualifiers) {
        HashSet<Annotation> newQualifiers = new HashSet<Annotation>(this.requiredQualifiers);
        Collections.addAll(newQualifiers, qualifiers);
        return new InstanceImpl<T>(this, this.requiredType, newQualifiers);
    }

    @Override
    public <U extends T> InjectableInstance<U> select(Class<U> subtype, Annotation ... qualifiers) {
        HashSet<Annotation> newQualifiers = new HashSet<Annotation>(this.requiredQualifiers);
        Collections.addAll(newQualifiers, qualifiers);
        return new InstanceImpl<T>(this, subtype, newQualifiers);
    }

    @Override
    public <U extends T> InjectableInstance<U> select(TypeLiteral<U> subtype, Annotation ... qualifiers) {
        HashSet<Annotation> newQualifiers = new HashSet<Annotation>(this.requiredQualifiers);
        Collections.addAll(newQualifiers, qualifiers);
        return new InstanceImpl<T>(this, subtype.getType(), newQualifiers);
    }

    public boolean isUnsatisfied() {
        return this.beans().isEmpty();
    }

    public boolean isAmbiguous() {
        return this.beans().size() > 1;
    }

    public void destroy(Object instance) {
        Objects.requireNonNull(instance);
        if (instance instanceof ClientProxy) {
            ClientProxy proxy = (ClientProxy)instance;
            InjectableContext context = Arc.container().getActiveContext(proxy.arc_bean().getScope());
            if (context == null) {
                throw new ContextNotActiveException("No active context found for: " + proxy.arc_bean().getScope());
            }
            context.destroy((Contextual)proxy.arc_bean());
        } else if (!this.creationalContext.removeDependentInstance(instance, true)) {
            SingletonContext singletonContext = (SingletonContext)Arc.container().getActiveContext(Singleton.class);
            singletonContext.destroyInstance(instance);
        }
    }

    @Override
    public InstanceHandle<T> getHandle() {
        return this.getHandle(this.bean());
    }

    @Override
    public Iterable<InstanceHandle<T>> handles() {
        return new Iterable<InstanceHandle<T>>(){

            @Override
            public Iterator<InstanceHandle<T>> iterator() {
                return new InstanceHandlesIterator(InstanceImpl.this.beans());
            }
        };
    }

    private <H> InstanceHandle<H> getHandle(final InjectableBean<H> bean) {
        final CreationalContextImpl<H> context = this.creationalContext.child(bean);
        return new LazyInstanceHandle<Object>(bean, context, this.creationalContext, new Supplier<H>(){

            @Override
            public H get() {
                InjectionPoint prev = InjectionPointProvider.set(new CurrentInjectionPointProvider.InjectionPointImpl(InstanceImpl.this.injectionPointType, InstanceImpl.this.requiredType, InstanceImpl.this.requiredQualifiers, InstanceImpl.this.targetBean, InstanceImpl.this.annotations, InstanceImpl.this.javaMember, InstanceImpl.this.position));
                try {
                    Object object = bean.get(context);
                    return object;
                }
                finally {
                    InjectionPointProvider.set(prev);
                }
            }
        }, Dependent.class.equals(bean.getScope()) ? this::destroy : null);
    }

    private InjectableBean<T> bean() {
        List<InjectableBean<?>> beans = this.beans();
        if (beans.isEmpty()) {
            ArcContainerImpl.instance().scanRemovedBeans(this.requiredType, this.requiredQualifiers.toArray(new Annotation[0]));
            throw new UnsatisfiedResolutionException("No bean found for required type [" + this.requiredType + "] and qualifiers [" + this.requiredQualifiers + "]");
        }
        if (beans.size() > 1) {
            throw new AmbiguousResolutionException("Beans: " + beans.toString());
        }
        return beans.iterator().next();
    }

    public boolean hasDependentInstances() {
        return this.creationalContext.hasDependentInstances();
    }

    @Override
    public void clearCache() {
        if (this.cachedGetResult.isSet()) {
            this.creationalContext.release();
            this.cachedGetResult.clear();
        }
    }

    private T getInternal() {
        return this.getBeanInstance(this.bean());
    }

    void destroy() {
        this.creationalContext.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T getBeanInstance(InjectableBean<T> bean) {
        Object instance;
        CreationalContextImpl<T> ctx = this.creationalContext.child(bean);
        InjectionPoint prev = InjectionPointProvider.set(new CurrentInjectionPointProvider.InjectionPointImpl(this.injectionPointType, this.requiredType, this.requiredQualifiers, this.targetBean, this.annotations, this.javaMember, this.position));
        try {
            instance = bean.get(ctx);
        }
        finally {
            InjectionPointProvider.set(prev);
        }
        return (T)instance;
    }

    private List<InjectableBean<?>> beans() {
        return this.resolvedBeans != null ? this.resolvedBeans : this.resolve();
    }

    private List<InjectableBean<?>> resolve() {
        return Instances.resolveBeans(this.requiredType, this.requiredQualifiers);
    }

    private static Type getRequiredType(Type type) {
        ParameterizedType parameterizedType;
        if (type instanceof ParameterizedType && Provider.class.isAssignableFrom(Types.getRawType((parameterizedType = (ParameterizedType)type).getRawType()))) {
            return parameterizedType.getActualTypeArguments()[0];
        }
        throw new IllegalArgumentException("Not a valid type: " + type);
    }

    private boolean isGetCached(Set<Annotation> annotations) {
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().equals(WithCaching.class)) continue;
            return true;
        }
        return false;
    }

    private class InstanceHandlesIterator<H>
    implements Iterator<InstanceHandle<H>> {
        final Iterator<InjectableBean<?>> delegate;

        InstanceHandlesIterator(Collection<InjectableBean<?>> beans) {
            this.delegate = beans.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public InstanceHandle<H> next() {
            return InstanceImpl.this.getHandle(this.delegate.next());
        }
    }

    class InstanceIterator
    implements Iterator<T> {
        protected final Iterator<InjectableBean<?>> delegate;

        private InstanceIterator(Collection<InjectableBean<?>> beans) {
            this.delegate = beans.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public T next() {
            return InstanceImpl.this.getBeanInstance(this.delegate.next());
        }
    }
}

