/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.NetworkNode;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.common.UpdateContext;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.Sink;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.kie.api.definition.rule.Rule;

public abstract class BaseNode
implements NetworkNode {
    protected int id;
    protected int posInSegment;
    protected int memoryId = -1;
    protected RuleBasePartitionId partitionId;
    protected boolean partitionsEnabled;
    protected Set<Rule> associations;
    protected Map<Integer, TerminalNode> associatedTerminals;
    private boolean streamMode;
    protected int hashcode;

    public BaseNode() {
    }

    public BaseNode(int id, RuleBasePartitionId partitionId, boolean partitionsEnabled) {
        this.id = id;
        this.partitionId = partitionId;
        this.partitionsEnabled = partitionsEnabled;
        this.associations = new HashSet<Rule>();
        this.associatedTerminals = new HashMap<Integer, TerminalNode>();
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    public int getPosInSegment() {
        return this.posInSegment;
    }

    public void setPosInSegment(int posInSegment) {
        this.posInSegment = posInSegment;
    }

    public int getMemoryId() {
        if (this.memoryId < 0) {
            throw new UnsupportedOperationException();
        }
        return this.memoryId;
    }

    protected void initMemoryId(BuildContext context) {
        if (context != null && this instanceof MemoryFactory) {
            this.memoryId = context.getNextMemoryId();
        }
    }

    public boolean isStreamMode() {
        return this.streamMode;
    }

    protected void setStreamMode(boolean streamMode) {
        this.streamMode = streamMode;
    }

    public void attach(BuildContext context) {
        this.doAttach(context);
    }

    public void doAttach(BuildContext context) {
    }

    public abstract void networkUpdated(UpdateContext var1);

    public boolean remove(RuleRemovalContext context, ReteooBuilder builder) {
        boolean removed = this.doRemove(context, builder);
        if (!this.isInUse() && !(this instanceof EntryPointNode)) {
            builder.releaseId(this);
        }
        return removed;
    }

    protected abstract boolean doRemove(RuleRemovalContext var1, ReteooBuilder var2);

    public abstract boolean isInUse();

    public abstract ObjectTypeNode getObjectTypeNode();

    public String toString() {
        return "[" + this.getClass().getSimpleName() + "(" + this.id + ")]";
    }

    @Override
    public RuleBasePartitionId getPartitionId() {
        return this.partitionId;
    }

    public void setPartitionId(BuildContext context, RuleBasePartitionId partitionId) {
        this.partitionId = partitionId;
    }

    public void setPartitionsEnabled(boolean partitionsEnabled) {
        this.partitionsEnabled = partitionsEnabled;
    }

    public void addAssociation(Rule rule) {
        this.associations.add(rule);
    }

    public void addAssociation(BuildContext context, Rule rule) {
        this.addAssociation(rule);
    }

    public boolean removeAssociation(Rule rule, RuleRemovalContext context) {
        return this.associations.remove(rule);
    }

    public int getAssociationsSize() {
        return this.associations.size();
    }

    @Override
    public Rule[] getAssociatedRules() {
        return this.associations.toArray(new Rule[this.associations.size()]);
    }

    @Override
    public boolean isAssociatedWith(Rule rule) {
        return this.associations.contains(rule);
    }

    @Override
    public Map<Integer, TerminalNode> getAssociatedTerminals() {
        return this.associatedTerminals;
    }

    public final int hashCode() {
        return this.hashcode;
    }

    @Override
    public NetworkNode[] getSinks() {
        Sink[] sinks = null;
        if (this instanceof EntryPointNode) {
            EntryPointNode source = (EntryPointNode)this;
            Collection<ObjectTypeNode> otns = source.getObjectTypeNodes().values();
            sinks = otns.toArray(new Sink[otns.size()]);
        } else if (this instanceof ObjectSource) {
            ObjectSource source = (ObjectSource)this;
            sinks = source.getObjectSinkPropagator().getSinks();
        } else if (this instanceof LeftTupleSource) {
            LeftTupleSource source = (LeftTupleSource)this;
            sinks = source.getSinkPropagator().getSinks();
        }
        return sinks;
    }
}

