/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import org.drools.core.common.TupleSets;
import org.drools.core.reteoo.Tuple;

public class TupleSetsImpl<T extends Tuple>
implements TupleSets<T> {
    private T insertFirst;
    private T deleteFirst;
    private T updateFirst;
    private T normalizedDeleteFirst;
    private int insertSize;

    public TupleSetsImpl() {
    }

    TupleSetsImpl(T insertFirst, T updateFirst, T deleteFirst, T normalizedDeleteFirst, int insertSize) {
        this.insertFirst = insertFirst;
        this.updateFirst = updateFirst;
        this.deleteFirst = deleteFirst;
        this.normalizedDeleteFirst = normalizedDeleteFirst;
        this.insertSize = insertSize;
    }

    @Override
    public int getInsertSize() {
        return this.insertSize;
    }

    @Override
    public T getInsertFirst() {
        return this.insertFirst;
    }

    protected void setInsertFirst(T insertFirst) {
        this.insertFirst = insertFirst;
    }

    @Override
    public T getDeleteFirst() {
        return this.deleteFirst;
    }

    protected void setDeleteFirst(T deleteFirst) {
        this.deleteFirst = deleteFirst;
    }

    @Override
    public T getUpdateFirst() {
        return this.updateFirst;
    }

    protected void setUpdateFirst(T updateFirst) {
        this.updateFirst = updateFirst;
    }

    @Override
    public T getNormalizedDeleteFirst() {
        return this.normalizedDeleteFirst;
    }

    protected void setNormalizedDeleteFirst(T normalizedDeleteFirst) {
        this.normalizedDeleteFirst = normalizedDeleteFirst;
    }

    @Override
    public void resetAll() {
        this.setInsertFirst(null);
        this.setDeleteFirst(null);
        this.setUpdateFirst(null);
        this.setNormalizedDeleteFirst(null);
        this.insertSize = 0;
    }

    @Override
    public boolean addInsert(T tuple) {
        if (this.getStagedType(tuple) == 2) {
            return false;
        }
        this.setStagedType(tuple, (short)1);
        if (this.insertFirst == null) {
            this.insertFirst = tuple;
            this.insertSize = 1;
            return true;
        }
        this.setNextTuple(tuple, this.insertFirst);
        this.setPreviousTuple(this.insertFirst, tuple);
        this.insertFirst = tuple;
        ++this.insertSize;
        return false;
    }

    @Override
    public boolean addDelete(T tuple) {
        switch (this.getStagedType(tuple)) {
            case 1: {
                this.removeInsert(tuple);
                return this.deleteFirst == null;
            }
            case 2: {
                this.removeUpdate((Tuple)tuple);
            }
        }
        this.setStagedType(tuple, (short)3);
        if (this.deleteFirst == null) {
            this.deleteFirst = tuple;
            return true;
        }
        this.setNextTuple(tuple, this.deleteFirst);
        this.setPreviousTuple(this.deleteFirst, tuple);
        this.deleteFirst = tuple;
        return false;
    }

    @Override
    public boolean addNormalizedDelete(T tuple) {
        this.setStagedType(tuple, (short)4);
        if (this.normalizedDeleteFirst == null) {
            this.normalizedDeleteFirst = tuple;
            return true;
        }
        this.setNextTuple(tuple, this.normalizedDeleteFirst);
        this.setPreviousTuple(this.normalizedDeleteFirst, tuple);
        this.normalizedDeleteFirst = tuple;
        return false;
    }

    @Override
    public boolean addUpdate(T tuple) {
        if (this.getStagedType(tuple) != 0) {
            return false;
        }
        this.setStagedType(tuple, (short)2);
        if (this.updateFirst == null) {
            this.updateFirst = tuple;
            return true;
        }
        this.setNextTuple(tuple, this.updateFirst);
        this.setPreviousTuple(this.updateFirst, tuple);
        this.updateFirst = tuple;
        return false;
    }

    @Override
    public void removeInsert(T tuple) {
        if (tuple == this.insertFirst) {
            T next = this.getNextTuple(tuple);
            if (next != null) {
                this.setPreviousTuple(next, null);
            }
            this.setInsertFirst(next);
        } else {
            T next = this.getNextTuple(tuple);
            T previous = this.getPreviousTuple(tuple);
            if (next != null) {
                this.setPreviousTuple(next, previous);
            }
            this.setNextTuple(previous, next);
        }
        tuple.clearStaged();
        --this.insertSize;
    }

    @Override
    public void removeDelete(T tuple) {
        if (tuple == this.deleteFirst) {
            T next = this.getNextTuple(tuple);
            if (next != null) {
                this.setPreviousTuple(next, null);
            }
            this.deleteFirst = next;
        } else {
            T next = this.getNextTuple(tuple);
            T previous = this.getPreviousTuple(tuple);
            if (next != null) {
                this.setPreviousTuple(next, previous);
            }
            this.setNextTuple(previous, next);
        }
        tuple.clearStaged();
    }

    @Override
    public void removeUpdate(Tuple tuple) {
        if (tuple == this.updateFirst) {
            Tuple next = this.getNextTuple(tuple);
            if (next != null) {
                this.setPreviousTuple(next, null);
            }
            this.updateFirst = next;
        } else {
            Tuple next = this.getNextTuple(tuple);
            Tuple previous = this.getPreviousTuple(tuple);
            if (next != null) {
                this.setPreviousTuple(next, previous);
            }
            this.setNextTuple(previous, next);
        }
        tuple.clearStaged();
    }

    private void addAllInserts(TupleSets<T> tupleSets) {
        if (tupleSets.getInsertFirst() != null) {
            if (this.insertFirst == null) {
                this.setInsertFirst(tupleSets.getInsertFirst());
                this.insertSize = tupleSets.getInsertSize();
            } else {
                T current = this.insertFirst;
                T last = null;
                while (current != null) {
                    last = current;
                    current = this.getNextTuple(current);
                }
                T tuple = tupleSets.getInsertFirst();
                this.setNextTuple(last, tuple);
                this.setPreviousTuple(tuple, last);
                this.insertSize += tupleSets.getInsertSize();
            }
            ((TupleSetsImpl)tupleSets).setInsertFirst(null);
        }
    }

    private void addAllDeletes(TupleSets<T> tupleSets) {
        if (tupleSets.getDeleteFirst() != null) {
            if (this.deleteFirst == null) {
                this.setDeleteFirst(tupleSets.getDeleteFirst());
            } else {
                T current = this.deleteFirst;
                T last = null;
                while (current != null) {
                    last = current;
                    current = this.getNextTuple(current);
                }
                T tuple = tupleSets.getDeleteFirst();
                this.setNextTuple(last, tuple);
                this.setPreviousTuple(tuple, last);
            }
            ((TupleSetsImpl)tupleSets).setDeleteFirst(null);
        }
    }

    private void addAllUpdates(TupleSets<T> tupleSets) {
        if (tupleSets.getUpdateFirst() != null) {
            if (this.updateFirst == null) {
                this.setUpdateFirst(tupleSets.getUpdateFirst());
            } else {
                T current = this.updateFirst;
                T last = null;
                while (current != null) {
                    last = current;
                    current = this.getNextTuple(current);
                }
                T tuple = tupleSets.getUpdateFirst();
                this.setNextTuple(last, tuple);
                this.setPreviousTuple(tuple, last);
            }
            ((TupleSetsImpl)tupleSets).setUpdateFirst(null);
        }
    }

    @Override
    public void addAll(TupleSets<T> source) {
        this.addAllInserts(source);
        this.addAllDeletes(source);
        this.addAllUpdates(source);
    }

    @Override
    public void addTo(TupleSets<T> target) {
        target.addAll(this);
    }

    @Override
    public TupleSets<T> takeAll() {
        TupleSetsImpl<T> clone = new TupleSetsImpl<T>(this.insertFirst, this.updateFirst, this.deleteFirst, this.normalizedDeleteFirst, this.insertSize);
        this.resetAll();
        return clone;
    }

    @Override
    public void clear() {
        this.clear(this.getInsertFirst());
        this.clear(this.getDeleteFirst());
        this.clear(this.getUpdateFirst());
        this.clear(this.getNormalizedDeleteFirst());
        this.resetAll();
    }

    private void clear(T tuple) {
        while (tuple != null) {
            T next = this.getNextTuple(tuple);
            tuple.clearStaged();
            tuple = next;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.insertFirst == null && this.deleteFirst == null && this.updateFirst == null && this.normalizedDeleteFirst == null;
    }

    @Override
    public String toStringSizes() {
        return "TupleSets[hasInsert=" + (this.insertFirst != null) + ", hasDelete=" + (this.deleteFirst != null) + ", hasUpdate=" + (this.updateFirst != null) + "]";
    }

    public String toString() {
        StringBuilder sbuilder = new StringBuilder();
        sbuilder.append("Inserted:\n");
        this.appendSet(sbuilder, (Tuple)this.getInsertFirst());
        sbuilder.append("Deleted:\n");
        this.appendSet(sbuilder, (Tuple)this.getDeleteFirst());
        sbuilder.append("Updated:\n");
        this.appendSet(sbuilder, (Tuple)this.getUpdateFirst());
        sbuilder.append("Normalized Deleted:\n");
        this.appendSet(sbuilder, (Tuple)this.getNormalizedDeleteFirst());
        return sbuilder.toString();
    }

    private void appendSet(StringBuilder sbuilder, Tuple tuple) {
        while (tuple != null) {
            sbuilder.append(" ").append(tuple).append("\n");
            tuple = this.getNextTuple(tuple);
        }
    }

    protected T getPreviousTuple(T tuple) {
        return (T)tuple.getStagedPrevious();
    }

    protected void setPreviousTuple(T tuple, T stagedPrevious) {
        tuple.setStagedPrevious((Tuple)stagedPrevious);
    }

    protected T getNextTuple(T tuple) {
        return tuple.getStagedNext();
    }

    protected void setNextTuple(T tuple, T stagedNext) {
        tuple.setStagedNext((Tuple)stagedNext);
    }

    protected void setStagedType(T tuple, short type) {
        tuple.setStagedType(type);
    }

    protected short getStagedType(T tuple) {
        return tuple.getStagedType();
    }
}

