/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import java.util.function.Function;
import org.drools.model.AlphaIndex;
import org.drools.model.ConstraintOperator;
import org.drools.model.Index;
import org.drools.model.PatternDSL;
import org.drools.model.Prototype;
import org.drools.model.PrototypeExpression;
import org.drools.model.PrototypeFact;
import org.drools.model.PrototypeVariable;
import org.drools.model.functions.Function1;
import org.drools.model.functions.Predicate1;
import org.drools.model.functions.Predicate2;
import org.drools.model.functions.Predicate3;
import org.drools.model.functions.temporal.TemporalPredicate;
import org.drools.model.impl.PrototypeImpl;
import org.drools.model.impl.PrototypeVariableImpl;

public class PrototypeDSL {
    public static final Prototype DEFAULT_PROTOTYPE = PrototypeDSL.prototype("$DEFAULT_PROTOTYPE$");

    public static Prototype prototype(String name) {
        return new PrototypeImpl(name);
    }

    public static Prototype prototype(String name, String ... fields) {
        return new PrototypeImpl(name, fields);
    }

    public static Prototype prototype(String name, Prototype.Field ... fields) {
        return new PrototypeImpl(name, fields);
    }

    public static Prototype.Field field(String name) {
        return new PrototypeImpl.FieldImpl(name);
    }

    public static Prototype.Field field(String name, Function<PrototypeFact, Object> extractor) {
        return new PrototypeImpl.FieldImpl(name, extractor);
    }

    public static Prototype.Field field(String name, Class<?> type) {
        return new PrototypeImpl.FieldImpl(name, type);
    }

    public static Prototype.Field field(String name, Class<?> type, Function<PrototypeFact, Object> extractor) {
        return new PrototypeImpl.FieldImpl(name, type, extractor);
    }

    public static PrototypeVariable variable(Prototype prototype) {
        return new PrototypeVariableImpl(prototype);
    }

    public static PrototypeVariable variable(Prototype prototype, String name) {
        return new PrototypeVariableImpl(prototype, name);
    }

    public static PrototypePatternDef protoPattern(PrototypeVariable protoVar) {
        return new PrototypePatternDefImpl(protoVar);
    }

    public static PrototypeExpression fieldName2PrototypeExpression(String fieldName) {
        int arrayStart = fieldName.indexOf(91);
        if (arrayStart >= 0) {
            int arrayEnd = fieldName.indexOf(93);
            int pos = Integer.parseInt(fieldName.substring(arrayStart + 1, arrayEnd));
            PrototypeExpression arrayExpr = PrototypeExpression.prototypeArrayItem(fieldName.substring(0, arrayStart), pos);
            if (arrayEnd + 1 < fieldName.length()) {
                if (fieldName.charAt(arrayEnd + 1) != '.') {
                    throw new UnsupportedOperationException("Invalid expression: " + fieldName);
                }
                arrayExpr = arrayExpr.andThen(PrototypeDSL.fieldName2PrototypeExpression(fieldName.substring(arrayEnd + 2)));
            }
            return arrayExpr;
        }
        return PrototypeExpression.prototypeField(fieldName);
    }

    public static class PrototypeSubPatternDefImpl<T>
    extends PrototypePatternDefImpl {
        private final PrototypePatternDefImpl parent;
        private final PatternDSL.LogicalCombiner combiner;

        public PrototypeSubPatternDefImpl(PrototypePatternDefImpl parent, PatternDSL.LogicalCombiner combiner) {
            super((PrototypeVariable)parent.variable);
            this.parent = parent;
            this.combiner = combiner;
        }

        public PrototypePatternDefImpl endAnd() {
            if (this.combiner == PatternDSL.LogicalCombiner.OR) {
                throw new UnsupportedOperationException();
            }
            this.parent.items.add(new PatternDSL.CombinedPatternExprItem(this.combiner, this.getItems()));
            return this.parent;
        }

        public PrototypePatternDefImpl endOr() {
            if (this.combiner == PatternDSL.LogicalCombiner.AND) {
                throw new UnsupportedOperationException();
            }
            this.parent.items.add(new PatternDSL.CombinedPatternExprItem(this.combiner, this.getItems()));
            return this.parent;
        }
    }

    public static class PrototypePatternDefImpl
    extends PatternDSL.PatternDefImpl<PrototypeFact>
    implements PrototypePatternDef {
        public PrototypePatternDefImpl(PrototypeVariable variable) {
            super(variable);
        }

        public PrototypeVariable getPrototypeVariable() {
            return (PrototypeVariable)this.getFirstVariable();
        }

        public Prototype getPrototype() {
            return this.getPrototypeVariable().getPrototype();
        }

        @Override
        public PrototypePatternDef and() {
            return new PrototypeSubPatternDefImpl(this, PatternDSL.LogicalCombiner.AND);
        }

        @Override
        public PrototypePatternDef or() {
            return new PrototypeSubPatternDefImpl(this, PatternDSL.LogicalCombiner.OR);
        }

        @Override
        public PrototypePatternDef expr(String fieldName, ConstraintOperator operator, Object value) {
            return this.expr(PrototypeDSL.fieldName2PrototypeExpression(fieldName), operator, PrototypeExpression.fixedValue(value));
        }

        @Override
        public PrototypePatternDef expr(PrototypeExpression left, ConstraintOperator operator, PrototypeExpression right) {
            Function1<PrototypeFact, Object> leftExtractor;
            if (right.hasPrototypeVariable()) {
                return this.exprWithProtoDef(left, operator, right);
            }
            Prototype prototype = this.getPrototype();
            AlphaIndex<PrototypeFact, Object> alphaIndex = null;
            if (left instanceof PrototypeExpression.PrototypeFieldValue && right instanceof PrototypeExpression.FixedValue && operator instanceof Index.ConstraintType) {
                Class<?> fieldClass;
                int fieldIndex;
                String fieldName = ((PrototypeExpression.PrototypeFieldValue)left).getFieldName();
                Index.ConstraintType constraintType = (Index.ConstraintType)operator;
                Prototype.Field field = prototype.getField(fieldName);
                Object value = ((PrototypeExpression.FixedValue)right).getValue();
                leftExtractor = this.getFieldValueExtractor(prototype, fieldName);
                int n = fieldIndex = field != null ? prototype.getFieldIndex(fieldName) : Math.abs(fieldName.hashCode());
                Class<?> clazz = field != null && field.isTyped() ? field.getType() : (fieldClass = value != null ? value.getClass() : null);
                if (fieldClass != null) {
                    alphaIndex = PatternDSL.alphaIndexedBy(fieldClass, constraintType, fieldIndex, leftExtractor, value);
                }
            } else {
                leftExtractor = left.asFunction(prototype);
            }
            HashSet<String> reactOnFields = new HashSet<String>();
            reactOnFields.addAll(left.getImpactedFields());
            reactOnFields.addAll(right.getImpactedFields());
            this.expr("expr:" + left + ":" + operator + ":" + right, this.asPredicate1(leftExtractor, operator, right.asFunction(prototype)), alphaIndex, PatternDSL.reactOn(reactOnFields.toArray(new String[reactOnFields.size()])));
            return this;
        }

        @Override
        public PrototypePatternDef expr(String fieldName, ConstraintOperator operator, PrototypeVariable other, String otherFieldName) {
            return this.expr(PrototypeDSL.fieldName2PrototypeExpression(fieldName), operator, other, PrototypeDSL.fieldName2PrototypeExpression(otherFieldName));
        }

        @Override
        public PrototypePatternDef expr(PrototypeExpression left, ConstraintOperator operator, PrototypeVariable other, PrototypeExpression right) {
            Prototype prototype = this.getPrototype();
            Prototype otherPrototype = other.getPrototype();
            HashSet<String> reactOnFields = new HashSet<String>();
            reactOnFields.addAll(left.getImpactedFields());
            reactOnFields.addAll(right.getImpactedFields());
            this.expr("expr:" + left + ":" + operator + ":" + right, other, this.asPredicate2(left.asFunction(prototype), operator, right.asFunction(otherPrototype)), PatternDSL.reactOn(reactOnFields.toArray(new String[reactOnFields.size()])));
            return this;
        }

        @Override
        public PrototypePatternDef expr(TemporalPredicate temporalPredicate, PrototypeVariable other) {
            this.expr(UUID.randomUUID().toString(), other, temporalPredicate);
            this.getPrototype().setAsEvent(true);
            other.getPrototype().setAsEvent(true);
            return this;
        }

        private Predicate1<PrototypeFact> asPredicate1(Function1<PrototypeFact, Object> left, ConstraintOperator operator, Function1<PrototypeFact, Object> right) {
            return p -> {
                Object leftValue = left.apply((PrototypeFact)p);
                Object rightValue = right.apply((PrototypeFact)p);
                return PrototypePatternDefImpl.evaluateConstraint(leftValue, operator, rightValue);
            };
        }

        private Predicate2<PrototypeFact, PrototypeFact> asPredicate2(Function1<PrototypeFact, Object> extractor, ConstraintOperator operator, Function1<PrototypeFact, Object> otherExtractor) {
            return (p1, p2) -> {
                Object leftValue = extractor.apply((PrototypeFact)p1);
                Object rightValue = otherExtractor.apply((PrototypeFact)p2);
                return PrototypePatternDefImpl.evaluateConstraint(leftValue, operator, rightValue);
            };
        }

        private PrototypePatternDef exprWithProtoDef(PrototypeExpression left, ConstraintOperator operator, PrototypeExpression right) {
            PrototypeVariable leftVar = this.getPrototypeVariable();
            PrototypeVariable[] protoVars = this.findRightPrototypeVariables(right, leftVar);
            switch (protoVars.length) {
                case 2: {
                    this.expr("expr:" + left + ":" + operator + ":" + right, protoVars[0], protoVars[1], this.asPredicate3(leftVar, left, operator, (PrototypeExpression.EvaluableExpression)((Object)right), protoVars));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            return this;
        }

        private Predicate3<PrototypeFact, PrototypeFact, PrototypeFact> asPredicate3(PrototypeVariable leftVar, PrototypeExpression left, ConstraintOperator operator, PrototypeExpression.EvaluableExpression right, PrototypeVariable[] protoVars) {
            return (l, r1, r2) -> {
                HashMap<PrototypeVariable, PrototypeFact> factsMap = new HashMap<PrototypeVariable, PrototypeFact>();
                factsMap.put(leftVar, (PrototypeFact)l);
                factsMap.put(protoVars[0], (PrototypeFact)r1);
                factsMap.put(protoVars[1], (PrototypeFact)r2);
                Object leftValue = left.asFunction(this.getPrototype()).apply((PrototypeFact)l);
                Object rightValue = right.evaluate(factsMap);
                return PrototypePatternDefImpl.evaluateConstraint(leftValue, operator, rightValue);
            };
        }

        private PrototypeVariable[] findRightPrototypeVariables(PrototypeExpression right, PrototypeVariable leftVar) {
            Collection<PrototypeVariable> rightVars = right.getPrototypeVariables();
            boolean rightVarsContainLeft = rightVars.contains(leftVar);
            PrototypeVariable[] protoVars = new PrototypeVariable[rightVarsContainLeft ? rightVars.size() - 1 : rightVars.size()];
            int i = 0;
            for (PrototypeVariable rightVar : rightVars) {
                if (rightVarsContainLeft && rightVar == leftVar) continue;
                protoVars[i++] = rightVar;
            }
            return protoVars;
        }

        private static boolean evaluateConstraint(Object leftValue, ConstraintOperator operator, Object rightValue) {
            return leftValue != Prototype.UNDEFINED_VALUE && rightValue != Prototype.UNDEFINED_VALUE && operator.asPredicate().test(leftValue, rightValue);
        }

        private Function1<PrototypeFact, Object> getFieldValueExtractor(Prototype prototype, String fieldName) {
            return prototype.getFieldValueExtractor(fieldName)::apply;
        }
    }

    public static interface PrototypePatternDef
    extends PatternDSL.PatternDef<PrototypeFact> {
        public PrototypePatternDef expr(String var1, ConstraintOperator var2, Object var3);

        public PrototypePatternDef expr(PrototypeExpression var1, ConstraintOperator var2, PrototypeExpression var3);

        public PrototypePatternDef expr(String var1, ConstraintOperator var2, PrototypeVariable var3, String var4);

        public PrototypePatternDef expr(PrototypeExpression var1, ConstraintOperator var2, PrototypeVariable var3, PrototypeExpression var4);

        public PrototypePatternDef expr(TemporalPredicate var1, PrototypeVariable var2);

        public PrototypePatternDef and();

        public PrototypePatternDef or();
    }
}

