/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.isochrone.algorithm;

import com.carrotsearch.hppc.IntObjectHashMap;
import com.graphhopper.isochrone.algorithm.QuadEdgeAsReadableQuadEdge;
import com.graphhopper.isochrone.algorithm.ReadableQuadEdge;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.locationtech.jts.triangulate.quadedge.QuadEdge;
import org.locationtech.jts.triangulate.quadedge.Vertex;
import org.locationtech.jts.util.Assert;

public class Triangulation {
    Map<String, QuadEdge> edges = new HashMap<String, QuadEdge>();
    IntObjectHashMap<Vertex> vertices = new IntObjectHashMap();
    IntObjectHashMap<QuadEdge> vertexQuadEdges = new IntObjectHashMap();

    public IntObjectHashMap<QuadEdge> getVertexQuadEdges() {
        return this.vertexQuadEdges;
    }

    public QuadEdge getEdge(int o, int d) {
        if (o < d) {
            return this.edges.get(o + "," + d);
        }
        QuadEdge quadEdge = this.edges.get(d + "," + o);
        return quadEdge != null ? quadEdge.sym() : null;
    }

    private void putEdge(int o, int d, QuadEdge quadEdge) {
        this.vertexQuadEdges.put(o, (Object)quadEdge);
        if (o < d) {
            this.edges.put(o + "," + d, quadEdge);
        } else {
            this.edges.put(d + "," + o, quadEdge.sym());
        }
    }

    public void makeTriangle(int v1, int v2, int v3) {
        QuadEdge e1 = this.getEdge(v1, v2);
        QuadEdge e2 = this.getEdge(v2, v3);
        QuadEdge e3 = this.getEdge(v3, v1);
        if (e1 == null && e2 != null) {
            this.makeTriangle(v2, v3, v1, e2, e3, e1);
        } else if (e2 == null && e3 != null) {
            this.makeTriangle(v3, v1, v2, e3, e1, e2);
        } else {
            this.makeTriangle(v1, v2, v3, e1, e2, e3);
        }
    }

    private void makeTriangle(int v1, int v2, int v3, QuadEdge e1, QuadEdge e2, QuadEdge e3) {
        if (e1 == null) {
            e1 = QuadEdge.makeEdge((Vertex)this.getVertex(v1), (Vertex)this.getVertex(v2));
            this.putEdge(v1, v2, e1);
            this.putEdge(v2, v1, e1.sym());
        }
        if (e2 == null) {
            e2 = QuadEdge.makeEdge((Vertex)this.getVertex(v2), (Vertex)this.getVertex(v3));
            QuadEdge.splice((QuadEdge)e1.lNext(), (QuadEdge)e2);
            this.putEdge(v2, v3, e2);
            this.putEdge(v3, v2, e2.sym());
        }
        if (e3 == null) {
            if (e1.lNext() == e2) {
                e3 = QuadEdge.connect((QuadEdge)e2, (QuadEdge)e1);
            } else {
                if (e2.lNext() == e1) {
                    throw new RuntimeException();
                }
                QuadEdge.splice((QuadEdge)e1.lNext(), (QuadEdge)e2);
                e3 = QuadEdge.connect((QuadEdge)e2, (QuadEdge)e1);
            }
            this.putEdge(v3, v1, e3);
            this.putEdge(v1, v3, e3.sym());
        } else {
            if (e1.lNext() != e2) {
                QuadEdge.splice((QuadEdge)e1.lNext(), (QuadEdge)e2);
            }
            if (e2.lNext() != e3) {
                QuadEdge.splice((QuadEdge)e2.lNext(), (QuadEdge)e3);
            }
            if (e3.lNext() != e1) {
                QuadEdge.splice((QuadEdge)e3.lNext(), (QuadEdge)e1);
            }
        }
        this.assertTriangle(e1, e2, e3);
    }

    private Vertex getVertex(int v3) {
        return (Vertex)this.vertices.get(v3);
    }

    public IntObjectHashMap<Vertex> getVertices() {
        return this.vertices;
    }

    public Collection<ReadableQuadEdge> getEdges() {
        return this.edges.values().stream().map(QuadEdgeAsReadableQuadEdge::new).collect(Collectors.toList());
    }

    public void assertTriangle(QuadEdge e1, QuadEdge e2, QuadEdge e3) {
        Assert.equals((Object)e2, (Object)e1.lNext());
        Assert.equals((Object)e3, (Object)e2.lNext());
        Assert.equals((Object)e1, (Object)e3.lNext());
    }

    public void assertTriangle(int v1, int v2, int v3) {
        this.assertTriangle(this.getEdge(v1, v2), this.getEdge(v2, v3), this.getEdge(v3, v1));
    }
}

