/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.dem;

import com.graphhopper.util.DistanceCalcEarth;
import com.graphhopper.util.DistancePlaneProjection;
import com.graphhopper.util.PointList;

public class EdgeElevationSmoothing {
    private static final int MAX_SEARCH_DISTANCE = 150;

    public static void smoothMovingAverage(PointList geometry) {
        for (int i = 1; i < geometry.size() - 1; ++i) {
            int start = i;
            int j = i - 1;
            while (j >= 0 && 150.0 > DistancePlaneProjection.DIST_PLANE.calcDist(geometry.getLat(i), geometry.getLon(i), geometry.getLat(j), geometry.getLon(j))) {
                start = j--;
            }
            int end = i;
            for (int j2 = i + 1; j2 < geometry.size() && 150.0 > DistancePlaneProjection.DIST_PLANE.calcDist(geometry.getLat(i), geometry.getLon(i), geometry.getLat(j2), geometry.getLon(j2)); ++j2) {
                end = j2 + 1;
            }
            if (start == end) continue;
            double sum = 0.0;
            for (int j3 = start; j3 < end; ++j3) {
                if (!(150.0 > DistancePlaneProjection.DIST_PLANE.calcDist(geometry.getLat(i), geometry.getLon(i), geometry.getLat(j3), geometry.getLon(j3)))) continue;
                sum += geometry.getEle(j3);
            }
            double smoothed = sum / (double)(end - start);
            geometry.setElevation(i, smoothed);
        }
    }

    public static void smoothRamer(PointList pointList, double maxElevationDelta) {
        EdgeElevationSmoothing.internSmoothRamer(pointList, 0, pointList.size() - 1, maxElevationDelta);
    }

    static void internSmoothRamer(PointList pointList, int fromIndex, int lastIndex, double maxElevationDelta) {
        double lon;
        double lat;
        int i;
        double prevLon;
        if (lastIndex - fromIndex < 2) {
            return;
        }
        double prevLat = pointList.getLat(fromIndex);
        double dist2D = DistanceCalcEarth.DIST_EARTH.calcDist(prevLat, prevLon = pointList.getLon(fromIndex), pointList.getLat(lastIndex), pointList.getLon(lastIndex));
        double averageSlope = dist2D == 0.0 ? 0.0 : (pointList.getEle(lastIndex) - pointList.getEle(fromIndex)) / dist2D;
        double prevAverageSlopeEle = pointList.getEle(fromIndex);
        double maxEleDelta = -1.0;
        int indexWithMaxDelta = -1;
        for (i = fromIndex + 1; i < lastIndex; ++i) {
            double tmpDist2D;
            double eleFromAverageSlope;
            lat = pointList.getLat(i);
            lon = pointList.getLon(i);
            double ele = pointList.getEle(i);
            double tmpEleDelta = Math.abs(ele - (eleFromAverageSlope = averageSlope * (tmpDist2D = DistanceCalcEarth.DIST_EARTH.calcDist(prevLat, prevLon, lat, lon)) + prevAverageSlopeEle));
            if (maxEleDelta < tmpEleDelta) {
                indexWithMaxDelta = i;
                maxEleDelta = tmpEleDelta;
            }
            prevAverageSlopeEle = eleFromAverageSlope;
            prevLat = lat;
            prevLon = lon;
        }
        if (indexWithMaxDelta < 0 || maxElevationDelta > maxEleDelta) {
            prevLat = pointList.getLat(fromIndex);
            prevLon = pointList.getLon(fromIndex);
            prevAverageSlopeEle = pointList.getEle(fromIndex);
            for (i = fromIndex + 1; i < lastIndex; ++i) {
                lat = pointList.getLat(i);
                lon = pointList.getLon(i);
                double tmpDist2D = DistanceCalcEarth.DIST_EARTH.calcDist(prevLat, prevLon, lat, lon);
                double eleFromAverageSlope = averageSlope * tmpDist2D + prevAverageSlopeEle;
                pointList.setElevation(i, eleFromAverageSlope);
                prevAverageSlopeEle = eleFromAverageSlope;
                prevLat = lat;
                prevLon = lon;
            }
        } else {
            EdgeElevationSmoothing.internSmoothRamer(pointList, fromIndex, indexWithMaxDelta, maxElevationDelta);
            EdgeElevationSmoothing.internSmoothRamer(pointList, indexWithMaxDelta, lastIndex, maxElevationDelta);
        }
    }
}

