/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.osm;

import java.util.Date;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;

public class OSMReaderUtility {
    private static final Date STATIC_DATE = new Date(16070400000L);

    public static long parseDuration(String str) throws IllegalArgumentException {
        if (str == null) {
            return 0L;
        }
        if (str.startsWith("P")) {
            try {
                Duration dur = DatatypeFactory.newInstance().newDuration(str);
                return dur.getTimeInMillis(STATIC_DATE) / 1000L;
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Cannot parse duration tag value: " + str, ex);
            }
        }
        try {
            int index = str.indexOf(":");
            if (index > 0) {
                String hourStr = str.substring(0, index);
                String minStr = str.substring(index + 1);
                String secondsStr = "0";
                index = minStr.indexOf(":");
                if (index > 0) {
                    secondsStr = minStr.substring(index + 1, index + 3);
                    minStr = minStr.substring(0, index);
                }
                long seconds = (long)Integer.parseInt(hourStr) * 60L * 60L;
                seconds += (long)Integer.parseInt(minStr) * 60L;
                return seconds += (long)Integer.parseInt(secondsStr);
            }
            return (long)Integer.parseInt(str) * 60L;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Cannot parse duration tag value: " + str, ex);
        }
    }
}

