/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.util.PMap;

public class AlgorithmOptions {
    private PMap hints = new PMap();
    private String algorithm = "dijkstrabi";
    private TraversalMode traversalMode = TraversalMode.NODE_BASED;
    private int maxVisitedNodes = Integer.MAX_VALUE;

    public AlgorithmOptions() {
    }

    public AlgorithmOptions(AlgorithmOptions b) {
        this.setAlgorithm(b.getAlgorithm());
        this.setTraversalMode(b.getTraversalMode());
        this.setMaxVisitedNodes(b.getMaxVisitedNodes());
        this.setHints(b.getHints());
    }

    public AlgorithmOptions setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public AlgorithmOptions setTraversalMode(TraversalMode traversalMode) {
        this.traversalMode = traversalMode;
        return this;
    }

    public AlgorithmOptions setMaxVisitedNodes(int maxVisitedNodes) {
        this.maxVisitedNodes = maxVisitedNodes;
        return this;
    }

    public AlgorithmOptions setHints(PMap pMap) {
        this.hints = new PMap(pMap);
        return this;
    }

    public TraversalMode getTraversalMode() {
        return this.traversalMode;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public int getMaxVisitedNodes() {
        return this.maxVisitedNodes;
    }

    public PMap getHints() {
        return this.hints;
    }

    public String toString() {
        return this.algorithm + ", " + (Object)((Object)this.traversalMode);
    }
}

