/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.config.Profile;
import com.graphhopper.routing.WeightingFactory;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.RoadAccess;
import com.graphhopper.routing.ev.TurnCost;
import com.graphhopper.routing.ev.VehicleAccess;
import com.graphhopper.routing.ev.VehiclePriority;
import com.graphhopper.routing.ev.VehicleSpeed;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.VehicleEncodedValues;
import com.graphhopper.routing.weighting.AbstractWeighting;
import com.graphhopper.routing.weighting.CurvatureWeighting;
import com.graphhopper.routing.weighting.DefaultTurnCostProvider;
import com.graphhopper.routing.weighting.FastestWeighting;
import com.graphhopper.routing.weighting.PriorityWeighting;
import com.graphhopper.routing.weighting.ShortFastestWeighting;
import com.graphhopper.routing.weighting.ShortestWeighting;
import com.graphhopper.routing.weighting.TurnCostProvider;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.routing.weighting.custom.CustomModelParser;
import com.graphhopper.routing.weighting.custom.CustomProfile;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.util.CustomModel;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;

public class DefaultWeightingFactory
implements WeightingFactory {
    private final BaseGraph graph;
    private final EncodingManager encodingManager;

    public DefaultWeightingFactory(BaseGraph graph, EncodingManager encodingManager) {
        this.graph = graph;
        this.encodingManager = encodingManager;
    }

    @Override
    public Weighting createWeighting(Profile profile, PMap requestHints, boolean disableTurnCosts) {
        DecimalEncodedValue priorityEnc;
        TurnCostProvider turnCostProvider;
        PMap hints = new PMap();
        hints.putAll(profile.getHints());
        hints.putAll(requestHints);
        String vehicle = profile.getVehicle();
        if (this.isOutdoorVehicle(vehicle)) {
            hints.putObject(FastestWeighting.PRIVATE_FACTOR, (Object)hints.getDouble(FastestWeighting.PRIVATE_FACTOR, 1.2));
        } else {
            hints.putObject(FastestWeighting.DESTINATION_FACTOR, (Object)hints.getDouble(FastestWeighting.DESTINATION_FACTOR, 10.0));
            hints.putObject(FastestWeighting.PRIVATE_FACTOR, (Object)hints.getDouble(FastestWeighting.PRIVATE_FACTOR, 10.0));
        }
        if (profile.isTurnCosts() && !disableTurnCosts) {
            DecimalEncodedValue turnCostEnc = this.encodingManager.getDecimalEncodedValue(TurnCost.key(vehicle));
            if (turnCostEnc == null) {
                throw new IllegalArgumentException("Vehicle " + vehicle + " does not support turn costs");
            }
            int uTurnCosts = hints.getInt("u_turn_costs", -1);
            turnCostProvider = new DefaultTurnCostProvider(turnCostEnc, this.graph.getTurnCostStorage(), uTurnCosts);
        } else {
            turnCostProvider = TurnCostProvider.NO_TURN_COST_PROVIDER;
        }
        String weightingStr = Helper.toLowerCase((String)profile.getWeighting());
        if (weightingStr.isEmpty()) {
            throw new IllegalArgumentException("You have to specify a weighting");
        }
        AbstractWeighting weighting = null;
        BooleanEncodedValue accessEnc = this.encodingManager.getBooleanEncodedValue(VehicleAccess.key(vehicle));
        DecimalEncodedValue speedEnc = this.encodingManager.getDecimalEncodedValue(VehicleSpeed.key(vehicle));
        DecimalEncodedValue decimalEncodedValue = priorityEnc = this.encodingManager.hasEncodedValue(VehiclePriority.key(vehicle)) ? this.encodingManager.getDecimalEncodedValue(VehiclePriority.key(vehicle)) : null;
        if ("custom".equalsIgnoreCase(weightingStr)) {
            if (!(profile instanceof CustomProfile)) {
                throw new IllegalArgumentException("custom weighting requires a CustomProfile but was profile=" + profile.getName());
            }
            CustomModel queryCustomModel = (CustomModel)requestHints.getObject("custom_model", null);
            CustomProfile customProfile = (CustomProfile)profile;
            queryCustomModel = CustomModel.merge((CustomModel)customProfile.getCustomModel(), (CustomModel)queryCustomModel);
            weighting = CustomModelParser.createWeighting(accessEnc, speedEnc, priorityEnc, this.encodingManager, turnCostProvider, queryCustomModel);
        } else if ("shortest".equalsIgnoreCase(weightingStr)) {
            weighting = new ShortestWeighting(accessEnc, speedEnc, turnCostProvider);
        } else if ("fastest".equalsIgnoreCase(weightingStr)) {
            if (!this.encodingManager.hasEncodedValue("road_access")) {
                throw new IllegalArgumentException("fastest weighting requires road_access");
            }
            EnumEncodedValue<RoadAccess> roadAccessEnc = this.encodingManager.getEnumEncodedValue("road_access", RoadAccess.class);
            weighting = priorityEnc != null ? new PriorityWeighting(accessEnc, speedEnc, priorityEnc, roadAccessEnc, hints, turnCostProvider) : new FastestWeighting(accessEnc, speedEnc, roadAccessEnc, hints, turnCostProvider);
        } else if ("curvature".equalsIgnoreCase(weightingStr)) {
            DecimalEncodedValue curvatureEnc;
            DecimalEncodedValue decimalEncodedValue2 = curvatureEnc = this.encodingManager.hasEncodedValue(EncodingManager.getKey(vehicle, "curvature")) ? this.encodingManager.getDecimalEncodedValue(EncodingManager.getKey(vehicle, "curvature")) : null;
            if (curvatureEnc == null || priorityEnc == null) {
                throw new IllegalArgumentException("curvature weighting requires curvature and priority, but not found for " + vehicle);
            }
            if (!this.encodingManager.hasEncodedValue("road_access")) {
                throw new IllegalArgumentException("curvature weighting requires road_access");
            }
            EnumEncodedValue<RoadAccess> roadAccessEnc = this.encodingManager.getEnumEncodedValue("road_access", RoadAccess.class);
            weighting = new CurvatureWeighting(accessEnc, speedEnc, priorityEnc, curvatureEnc, roadAccessEnc, hints, turnCostProvider);
        } else if ("short_fastest".equalsIgnoreCase(weightingStr)) {
            if (!this.encodingManager.hasEncodedValue("road_access")) {
                throw new IllegalArgumentException("curvature weighting requires road_access");
            }
            EnumEncodedValue<RoadAccess> roadAccessEnc = this.encodingManager.getEnumEncodedValue("road_access", RoadAccess.class);
            weighting = new ShortFastestWeighting(accessEnc, speedEnc, roadAccessEnc, hints, turnCostProvider);
        }
        if (weighting == null) {
            throw new IllegalArgumentException("Weighting '" + weightingStr + "' not supported");
        }
        return weighting;
    }

    public boolean isOutdoorVehicle(String name) {
        return VehicleEncodedValues.OUTDOOR_VEHICLES.contains(name);
    }
}

