/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.routing.DirectionResolverResult;
import com.graphhopper.routing.util.DirectedEdgeFilter;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.util.AngleCalc;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.NumHelper;
import com.graphhopper.util.PointList;
import com.graphhopper.util.shapes.GHPoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DirectionResolver {
    private final EdgeExplorer edgeExplorer;
    private final NodeAccess nodeAccess;
    private final DirectedEdgeFilter isAccessible;

    public DirectionResolver(Graph graph, DirectedEdgeFilter isAccessible) {
        this.edgeExplorer = graph.createEdgeExplorer();
        this.nodeAccess = graph.getNodeAccess();
        this.isAccessible = isAccessible;
    }

    public DirectionResolverResult resolveDirections(int node, GHPoint location) {
        AdjacentEdges adjacentEdges = this.calcAdjEdges(node);
        if (adjacentEdges.numStandardEdges == 0) {
            return DirectionResolverResult.impossible();
        }
        if (!adjacentEdges.hasInEdges() || !adjacentEdges.hasOutEdges()) {
            return DirectionResolverResult.impossible();
        }
        if (adjacentEdges.nextPoints.isEmpty()) {
            return DirectionResolverResult.impossible();
        }
        if (adjacentEdges.numLoops > 0) {
            return DirectionResolverResult.unrestricted();
        }
        if (adjacentEdges.numZeroDistanceEdges > 0) {
            return DirectionResolverResult.unrestricted();
        }
        Point snappedPoint = new Point(this.nodeAccess.getLat(node), this.nodeAccess.getLon(node));
        if (adjacentEdges.nextPoints.contains(snappedPoint)) {
            throw new IllegalStateException("Pillar node of adjacent edge matches snapped point, this should not happen");
        }
        if (adjacentEdges.nextPoints.size() == 1) {
            Point neighbor = adjacentEdges.nextPoints.iterator().next();
            List<Edge> inEdges = adjacentEdges.getInEdges(neighbor);
            List<Edge> outEdges = adjacentEdges.getOutEdges(neighbor);
            assert (inEdges.size() > 0 && outEdges.size() > 0) : "if there is only one next point there has to be an in edge and an out edge connected with it";
            if (inEdges.size() > 1 || outEdges.size() > 1) {
                return DirectionResolverResult.unrestricted();
            }
            return DirectionResolverResult.restricted(inEdges.get((int)0).edgeId, outEdges.get((int)0).edgeId, inEdges.get((int)0).edgeId, outEdges.get((int)0).edgeId);
        }
        if (adjacentEdges.nextPoints.size() == 2) {
            Iterator<Point> iter = adjacentEdges.nextPoints.iterator();
            Point p1 = iter.next();
            Point p2 = iter.next();
            List<Edge> in1 = adjacentEdges.getInEdges(p1);
            List<Edge> in2 = adjacentEdges.getInEdges(p2);
            List<Edge> out1 = adjacentEdges.getOutEdges(p1);
            List<Edge> out2 = adjacentEdges.getOutEdges(p2);
            if (in1.size() > 1 || in2.size() > 1 || out1.size() > 1 || out2.size() > 1) {
                return DirectionResolverResult.unrestricted();
            }
            if (in1.size() + in2.size() == 0 || out1.size() + out2.size() == 0) {
                throw new IllegalStateException("there has to be at least one in and one out edge when there are two next points");
            }
            if (in1.size() + out1.size() == 0 || in2.size() + out2.size() == 0) {
                throw new IllegalStateException("there has to be at least one in or one out edge for each of the two next points");
            }
            Point locationPoint = new Point(location.lat, location.lon);
            if (in1.isEmpty() || out2.isEmpty()) {
                return this.resolveDirections(snappedPoint, locationPoint, in2.get(0), out1.get(0));
            }
            if (in2.isEmpty() || out1.isEmpty()) {
                return this.resolveDirections(snappedPoint, locationPoint, in1.get(0), out2.get(0));
            }
            return this.resolveDirections(snappedPoint, locationPoint, in1.get(0), out2.get(0), in2.get((int)0).edgeId, out1.get((int)0).edgeId);
        }
        return DirectionResolverResult.unrestricted();
    }

    private DirectionResolverResult resolveDirections(Point snappedPoint, Point queryPoint, Edge inEdge, Edge outEdge) {
        boolean rightLane = this.isOnRightLane(queryPoint, snappedPoint, inEdge.nextPoint, outEdge.nextPoint);
        if (rightLane) {
            return DirectionResolverResult.onlyRight(inEdge.edgeId, outEdge.edgeId);
        }
        return DirectionResolverResult.onlyLeft(inEdge.edgeId, outEdge.edgeId);
    }

    private DirectionResolverResult resolveDirections(Point snappedPoint, Point queryPoint, Edge inEdge, Edge outEdge, int altInEdge, int altOutEdge) {
        Point inPoint = inEdge.nextPoint;
        Point outPoint = outEdge.nextPoint;
        boolean rightLane = this.isOnRightLane(queryPoint, snappedPoint, inPoint, outPoint);
        if (rightLane) {
            return DirectionResolverResult.restricted(inEdge.edgeId, outEdge.edgeId, altInEdge, altOutEdge);
        }
        return DirectionResolverResult.restricted(altInEdge, altOutEdge, inEdge.edgeId, outEdge.edgeId);
    }

    private boolean isOnRightLane(Point queryPoint, Point snappedPoint, Point inPoint, Point outPoint) {
        double oY;
        double oX;
        double iY;
        double qX = this.diffLon(snappedPoint, queryPoint);
        double qY = this.diffLat(snappedPoint, queryPoint);
        double iX = this.diffLon(snappedPoint, inPoint);
        return !AngleCalc.ANGLE_CALC.isClockwise(iX, iY = this.diffLat(snappedPoint, inPoint), oX = this.diffLon(snappedPoint, outPoint), oY = this.diffLat(snappedPoint, outPoint), qX, qY);
    }

    private double diffLon(Point p, Point q) {
        return q.lon - p.lon;
    }

    private double diffLat(Point p, Point q) {
        return q.lat - p.lat;
    }

    private AdjacentEdges calcAdjEdges(int node) {
        AdjacentEdges adjacentEdges = new AdjacentEdges();
        EdgeIterator iter = this.edgeExplorer.setBaseNode(node);
        while (iter.next()) {
            boolean isIn = this.isAccessible.accept(iter, true);
            boolean isOut = this.isAccessible.accept(iter, false);
            if (!isIn && !isOut) continue;
            PointList geometry = iter.fetchWayGeometry(FetchMode.ALL);
            double nextPointLat = geometry.getLat(1);
            double nextPointLon = geometry.getLon(1);
            boolean isZeroDistanceEdge = false;
            if (PointList.equalsEps((double)nextPointLat, (double)geometry.getLat(0)) && PointList.equalsEps((double)nextPointLon, (double)geometry.getLon(0))) {
                if (geometry.size() > 2) {
                    nextPointLat = geometry.getLat(2);
                    nextPointLon = geometry.getLon(2);
                } else if (geometry.size() == 2) {
                    isZeroDistanceEdge = true;
                } else {
                    throw new IllegalStateException("Geometry has less than two points");
                }
            }
            Point nextPoint = new Point(nextPointLat, nextPointLon);
            Edge edge = new Edge(iter.getEdge(), iter.getAdjNode(), nextPoint);
            adjacentEdges.addEdge(edge, isIn, isOut);
            if (iter.getBaseNode() == iter.getAdjNode()) {
                ++adjacentEdges.numLoops;
                continue;
            }
            if (isZeroDistanceEdge) {
                ++adjacentEdges.numZeroDistanceEdges;
                continue;
            }
            ++adjacentEdges.numStandardEdges;
        }
        return adjacentEdges;
    }

    private static class Edge {
        final int edgeId;
        final int adjNode;
        final Point nextPoint;

        Edge(int edgeId, int adjNode, Point nextPoint) {
            this.edgeId = edgeId;
            this.adjNode = adjNode;
            this.nextPoint = nextPoint;
        }
    }

    private static class Point {
        final double lat;
        final double lon;

        Point(double lat, double lon) {
            this.lat = lat;
            this.lon = lon;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Point other = (Point)o;
            return NumHelper.equalsEps((double)this.lat, (double)other.lat) && NumHelper.equalsEps((double)this.lon, (double)other.lon);
        }

        public int hashCode() {
            return 0;
        }

        public String toString() {
            return this.lat + ", " + this.lon;
        }
    }

    private static class AdjacentEdges {
        private final Map<Point, List<Edge>> inEdgesByNextPoint = new HashMap<Point, List<Edge>>(2);
        private final Map<Point, List<Edge>> outEdgesByNextPoint = new HashMap<Point, List<Edge>>(2);
        final Set<Point> nextPoints = new HashSet<Point>(2);
        int numLoops;
        int numStandardEdges;
        int numZeroDistanceEdges;

        private AdjacentEdges() {
        }

        void addEdge(Edge edge, boolean isIn, boolean isOut) {
            if (isIn) {
                this.addInEdge(edge);
            }
            if (isOut) {
                this.addOutEdge(edge);
            }
            this.addNextPoint(edge);
        }

        List<Edge> getInEdges(Point p) {
            List<Edge> result = this.inEdgesByNextPoint.get(p);
            return result == null ? Collections.emptyList() : result;
        }

        List<Edge> getOutEdges(Point p) {
            List<Edge> result = this.outEdgesByNextPoint.get(p);
            return result == null ? Collections.emptyList() : result;
        }

        boolean hasInEdges() {
            return !this.inEdgesByNextPoint.isEmpty();
        }

        boolean hasOutEdges() {
            return !this.outEdgesByNextPoint.isEmpty();
        }

        private void addOutEdge(Edge edge) {
            AdjacentEdges.addEdge(this.outEdgesByNextPoint, edge);
        }

        private void addInEdge(Edge edge) {
            AdjacentEdges.addEdge(this.inEdgesByNextPoint, edge);
        }

        private void addNextPoint(Edge edge) {
            this.nextPoints.add(edge.nextPoint);
        }

        private static void addEdge(Map<Point, List<Edge>> edgesByNextPoint, Edge edge) {
            List<Edge> edges = edgesByNextPoint.get(edge.nextPoint);
            if (edges == null) {
                edges = new ArrayList<Edge>(2);
                edges.add(edge);
                edgesByNextPoint.put(edge.nextPoint, edges);
            } else {
                edges.add(edge);
            }
        }
    }
}

