/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.routing.InstructionsHelper;
import com.graphhopper.routing.InstructionsOutgoingEdges;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.RoadClass;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.util.AngleCalc;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.FinishInstruction;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import com.graphhopper.util.Instruction;
import com.graphhopper.util.InstructionList;
import com.graphhopper.util.PointAccess;
import com.graphhopper.util.PointList;
import com.graphhopper.util.RoundaboutInstruction;
import com.graphhopper.util.Translation;
import com.graphhopper.util.shapes.GHPoint;

public class InstructionsFromEdges
implements Path.EdgeVisitor {
    private final Weighting weighting;
    private final NodeAccess nodeAccess;
    private final InstructionList ways;
    private final EdgeExplorer outEdgeExplorer;
    private final EdgeExplorer allExplorer;
    private final BooleanEncodedValue roundaboutEnc;
    private final BooleanEncodedValue roadClassLinkEnc;
    private final EnumEncodedValue<RoadClass> roadClassEnc;
    private final DecimalEncodedValue maxSpeedEnc;
    private EdgeIteratorState prevEdge;
    private double prevLat;
    private double prevLon;
    private double doublePrevLat;
    private double doublePrevLon;
    private int prevNode;
    private double prevOrientation;
    private double prevInstructionPrevOrientation = Double.NaN;
    private Instruction prevInstruction;
    private boolean prevInRoundabout;
    private String prevDestinationAndRef;
    private String prevName;
    private String prevInstructionName;
    private static final int MAX_U_TURN_DISTANCE = 35;

    public InstructionsFromEdges(Graph graph, Weighting weighting, EncodedValueLookup evLookup, InstructionList ways) {
        this.weighting = weighting;
        this.roundaboutEnc = evLookup.getBooleanEncodedValue("roundabout");
        this.roadClassEnc = evLookup.getEnumEncodedValue("road_class", RoadClass.class);
        this.roadClassLinkEnc = evLookup.getBooleanEncodedValue("road_class_link");
        this.maxSpeedEnc = evLookup.getDecimalEncodedValue("max_speed");
        this.nodeAccess = graph.getNodeAccess();
        this.ways = ways;
        this.prevNode = -1;
        this.prevInRoundabout = false;
        this.prevName = null;
        this.outEdgeExplorer = graph.createEdgeExplorer(edge -> Double.isFinite(weighting.calcEdgeWeightWithAccess(edge, false)));
        this.allExplorer = graph.createEdgeExplorer();
    }

    public static InstructionList calcInstructions(Path path, Graph graph, Weighting weighting, EncodedValueLookup evLookup, Translation tr) {
        InstructionList ways = new InstructionList(tr);
        if (path.isFound()) {
            if (path.getEdgeCount() == 0) {
                ways.add((Object)new FinishInstruction((PointAccess)graph.getNodeAccess(), path.getEndNode()));
            } else {
                path.forEveryEdge(new InstructionsFromEdges(graph, weighting, evLookup, ways));
            }
        }
        return ways;
    }

    @Override
    public void next(EdgeIteratorState edge, int index, int prevEdgeId) {
        int sign;
        double longitude;
        double latitude;
        int adjNode = edge.getAdjNode();
        int baseNode = edge.getBaseNode();
        if (this.prevNode == -1) {
            this.prevLat = this.nodeAccess.getLat(baseNode);
            this.prevLon = this.nodeAccess.getLon(baseNode);
        }
        double adjLat = this.nodeAccess.getLat(adjNode);
        double adjLon = this.nodeAccess.getLon(adjNode);
        PointList wayGeo = edge.fetchWayGeometry(FetchMode.ALL);
        boolean isRoundabout = edge.get(this.roundaboutEnc);
        if (wayGeo.size() <= 2) {
            latitude = adjLat;
            longitude = adjLon;
        } else {
            latitude = wayGeo.getLat(1);
            longitude = wayGeo.getLon(1);
            assert (Double.compare(this.prevLat, this.nodeAccess.getLat(baseNode)) == 0);
            assert (Double.compare(this.prevLon, this.nodeAccess.getLon(baseNode)) == 0);
        }
        String name = (String)edge.getValue("name");
        String ref = (String)edge.getValue("ref");
        String destination = (String)edge.getValue("destination");
        String destinationRef = (String)edge.getValue("destination_ref");
        if (this.prevInstruction == null && !isRoundabout) {
            sign = 0;
            this.prevInstruction = new Instruction(sign, name, new PointList(10, this.nodeAccess.is3D()));
            this.prevInstruction.setExtraInfo("ref", (Object)ref);
            this.prevInstruction.setExtraInfo("destination", (Object)destination);
            this.prevInstruction.setExtraInfo("destination_ref", (Object)destinationRef);
            double startLat = this.nodeAccess.getLat(baseNode);
            double startLon = this.nodeAccess.getLon(baseNode);
            double heading = AngleCalc.ANGLE_CALC.calcAzimuth(startLat, startLon, latitude, longitude);
            this.prevInstruction.setExtraInfo("heading", (Object)Helper.round((double)heading, (int)2));
            this.ways.add((Object)this.prevInstruction);
            this.prevName = name;
            this.prevDestinationAndRef = destination + destinationRef;
        } else if (isRoundabout) {
            if (!this.prevInRoundabout) {
                int sign2 = 6;
                RoundaboutInstruction roundaboutInstruction = new RoundaboutInstruction(sign2, name, new PointList(10, this.nodeAccess.is3D()));
                this.prevInstructionPrevOrientation = this.prevOrientation;
                if (this.prevInstruction != null) {
                    EdgeIterator edgeIter = this.outEdgeExplorer.setBaseNode(baseNode);
                    while (edgeIter.next()) {
                        if (edgeIter.getAdjNode() == this.prevNode || edgeIter.get(this.roundaboutEnc)) continue;
                        roundaboutInstruction.increaseExitNumber();
                        break;
                    }
                    this.prevOrientation = AngleCalc.ANGLE_CALC.calcOrientation(this.doublePrevLat, this.doublePrevLon, this.prevLat, this.prevLon);
                    double orientation = AngleCalc.ANGLE_CALC.calcOrientation(this.prevLat, this.prevLon, latitude, longitude);
                    orientation = AngleCalc.ANGLE_CALC.alignOrientation(this.prevOrientation, orientation);
                    double delta = orientation - this.prevOrientation;
                    roundaboutInstruction.setDirOfRotation(delta);
                } else {
                    this.prevOrientation = AngleCalc.ANGLE_CALC.calcOrientation(this.prevLat, this.prevLon, latitude, longitude);
                    this.prevName = name;
                    this.prevDestinationAndRef = destination + destinationRef;
                }
                this.prevInstruction = roundaboutInstruction;
                this.ways.add((Object)this.prevInstruction);
            }
            EdgeIterator edgeIter = this.outEdgeExplorer.setBaseNode(edge.getAdjNode());
            while (edgeIter.next()) {
                if (edgeIter.get(this.roundaboutEnc)) continue;
                ((RoundaboutInstruction)this.prevInstruction).increaseExitNumber();
                break;
            }
        } else if (this.prevInRoundabout) {
            this.prevInstruction.setName(name);
            this.prevInstruction.setExtraInfo("ref", (Object)ref);
            this.prevInstruction.setExtraInfo("destination", (Object)destination);
            this.prevInstruction.setExtraInfo("destination_ref", (Object)destinationRef);
            double orientation = AngleCalc.ANGLE_CALC.calcOrientation(this.prevLat, this.prevLon, latitude, longitude);
            orientation = AngleCalc.ANGLE_CALC.alignOrientation(this.prevOrientation, orientation);
            double deltaInOut = orientation - this.prevOrientation;
            double recentOrientation = AngleCalc.ANGLE_CALC.calcOrientation(this.doublePrevLat, this.doublePrevLon, this.prevLat, this.prevLon);
            orientation = AngleCalc.ANGLE_CALC.alignOrientation(recentOrientation, orientation);
            double deltaOut = orientation - recentOrientation;
            this.prevInstruction = ((RoundaboutInstruction)this.prevInstruction).setRadian(deltaInOut).setDirOfRotation(deltaOut).setExited();
            this.prevInstructionName = this.prevName;
            this.prevName = name;
            this.prevDestinationAndRef = destination + destinationRef;
        } else {
            sign = this.getTurn(edge, baseNode, this.prevNode, adjNode, name, destination + destinationRef);
            if (sign != Integer.MIN_VALUE) {
                double lon;
                GHPoint point;
                double lat;
                double currentOrientation;
                double diff;
                boolean isUTurn = false;
                int uTurnType = -98;
                if (!Double.isNaN(this.prevInstructionPrevOrientation) && this.prevInstruction.getDistance() < 35.0 && sign < 0 == this.prevInstruction.getSign() < 0 && (Math.abs(sign) == 1 || Math.abs(sign) == 2 || Math.abs(sign) == 3) && (Math.abs(this.prevInstruction.getSign()) == 1 || Math.abs(this.prevInstruction.getSign()) == 2 || Math.abs(this.prevInstruction.getSign()) == 3) && Double.isFinite(this.weighting.calcEdgeWeightWithAccess(edge, false)) != Double.isFinite(this.weighting.calcEdgeWeightWithAccess(edge, true)) && InstructionsHelper.isNameSimilar(this.prevInstructionName, name) && (diff = Math.abs(this.prevInstructionPrevOrientation - (currentOrientation = AngleCalc.ANGLE_CALC.calcOrientation(this.prevLat, this.prevLon, lat = (point = InstructionsHelper.getPointForOrientationCalculation(edge, this.nodeAccess)).getLat(), lon = point.getLon(), false)))) > 2.827433388230814 && diff < 3.455751918948773) {
                    isUTurn = true;
                    uTurnType = sign < 0 ? -8 : 8;
                }
                if (isUTurn) {
                    this.prevInstruction.setSign(uTurnType);
                    this.prevInstruction.setName(name);
                } else {
                    this.prevInstruction = new Instruction(sign, name, new PointList(10, this.nodeAccess.is3D()));
                    this.prevInstructionPrevOrientation = this.prevOrientation;
                    this.prevInstructionName = this.prevName;
                    this.ways.add((Object)this.prevInstruction);
                }
                this.prevInstruction.setExtraInfo("ref", (Object)ref);
                this.prevInstruction.setExtraInfo("destination", (Object)destination);
                this.prevInstruction.setExtraInfo("destination_ref", (Object)destinationRef);
            }
            this.prevName = name;
            this.prevDestinationAndRef = destination + destinationRef;
        }
        this.updatePointsAndInstruction(edge, wayGeo);
        if (wayGeo.size() <= 2) {
            this.doublePrevLat = this.prevLat;
            this.doublePrevLon = this.prevLon;
        } else {
            int beforeLast = wayGeo.size() - 2;
            this.doublePrevLat = wayGeo.getLat(beforeLast);
            this.doublePrevLon = wayGeo.getLon(beforeLast);
        }
        this.prevInRoundabout = isRoundabout;
        this.prevNode = baseNode;
        this.prevLat = adjLat;
        this.prevLon = adjLon;
        this.prevEdge = edge;
    }

    @Override
    public void finish() {
        if (this.prevInRoundabout) {
            double orientation = AngleCalc.ANGLE_CALC.calcOrientation(this.doublePrevLat, this.doublePrevLon, this.prevLat, this.prevLon);
            orientation = AngleCalc.ANGLE_CALC.alignOrientation(this.prevOrientation, orientation);
            double delta = orientation - this.prevOrientation;
            ((RoundaboutInstruction)this.prevInstruction).setRadian(delta);
        }
        FinishInstruction finishInstruction = new FinishInstruction((PointAccess)this.nodeAccess, this.prevEdge.getAdjNode());
        finishInstruction.setExtraInfo("last_heading", (Object)AngleCalc.ANGLE_CALC.calcAzimuth(this.doublePrevLat, this.doublePrevLon, this.prevLat, this.prevLon));
        this.ways.add((Object)finishInstruction);
    }

    private int getTurn(EdgeIteratorState edge, int baseNode, int prevNode, int adjNode, String name, String destinationAndRef) {
        GHPoint point = InstructionsHelper.getPointForOrientationCalculation(edge, this.nodeAccess);
        double lat = point.getLat();
        double lon = point.getLon();
        this.prevOrientation = AngleCalc.ANGLE_CALC.calcOrientation(this.doublePrevLat, this.doublePrevLon, this.prevLat, this.prevLon);
        int sign = InstructionsHelper.calculateSign(this.prevLat, this.prevLon, lat, lon, this.prevOrientation);
        InstructionsOutgoingEdges outgoingEdges = new InstructionsOutgoingEdges(this.prevEdge, edge, this.weighting, this.maxSpeedEnc, this.roadClassEnc, this.roadClassLinkEnc, this.allExplorer, this.nodeAccess, prevNode, baseNode, adjNode);
        int nrOfPossibleTurns = outgoingEdges.getAllowedTurns();
        if (nrOfPossibleTurns <= 1) {
            if (Math.abs(sign) > 1 && outgoingEdges.getVisibleTurns() > 1) {
                return sign;
            }
            return Integer.MIN_VALUE;
        }
        if (Math.abs(sign) > 1) {
            if (InstructionsHelper.isNameSimilar(name, this.prevName) && outgoingEdges.outgoingEdgesAreSlowerByFactor(2.0)) {
                return Integer.MIN_VALUE;
            }
            return sign;
        }
        if (this.prevEdge == null) {
            return sign;
        }
        boolean outgoingEdgesAreSlower = outgoingEdges.outgoingEdgesAreSlowerByFactor(1.0);
        EdgeIteratorState otherContinue = outgoingEdges.getOtherContinue(this.prevLat, this.prevLon, this.prevOrientation);
        double delta = InstructionsHelper.calculateOrientationDelta(this.prevLat, this.prevLon, lat, lon, this.prevOrientation);
        if (!(otherContinue == null || InstructionsHelper.isNameSimilar(name, this.prevName) && InstructionsHelper.isNameSimilar(destinationAndRef, this.prevDestinationAndRef) && !InstructionsHelper.isNameSimilar(otherContinue.getName(), this.prevName) && outgoingEdgesAreSlower)) {
            RoadClass roadClass = edge.get(this.roadClassEnc);
            RoadClass prevRoadClass = this.prevEdge.get(this.roadClassEnc);
            RoadClass otherRoadClass = otherContinue.get(this.roadClassEnc);
            boolean link = edge.get(this.roadClassLinkEnc);
            boolean prevLink = this.prevEdge.get(this.roadClassLinkEnc);
            boolean otherLink = otherContinue.get(this.roadClassLinkEnc);
            if (!(roadClass != RoadClass.MOTORWAY && roadClass != RoadClass.TRUNK && roadClass != RoadClass.PRIMARY && roadClass != RoadClass.SECONDARY && roadClass != RoadClass.TERTIARY || roadClass != prevRoadClass || link != prevLink || otherRoadClass == prevRoadClass && otherLink == prevLink)) {
                return Integer.MIN_VALUE;
            }
            GHPoint tmpPoint = InstructionsHelper.getPointForOrientationCalculation(otherContinue, this.nodeAccess);
            double otherDelta = InstructionsHelper.calculateOrientationDelta(this.prevLat, this.prevLon, tmpPoint.getLat(), tmpPoint.getLon(), this.prevOrientation);
            if (Math.abs(delta) < 0.1 && Math.abs(otherDelta) > 0.15 && InstructionsHelper.isNameSimilar(name, this.prevName)) {
                return 0;
            }
            if (otherDelta < delta) {
                return -7;
            }
            return 7;
        }
        if (!outgoingEdgesAreSlower && (Math.abs(delta) > 0.6 || outgoingEdges.isLeavingCurrentStreet(this.prevName, name))) {
            return sign;
        }
        return Integer.MIN_VALUE;
    }

    private void updatePointsAndInstruction(EdgeIteratorState edge, PointList pl) {
        int len = pl.size() - 1;
        for (int i = 0; i < len; ++i) {
            this.prevInstruction.getPoints().add((PointAccess)pl, i);
        }
        double newDist = edge.getDistance();
        this.prevInstruction.setDistance(newDist + this.prevInstruction.getDistance());
        if (this.prevEdge != null) {
            this.prevInstruction.setTime(GHUtility.calcMillisWithTurnMillis(this.weighting, edge, false, this.prevEdge.getEdge()) + this.prevInstruction.getTime());
        } else {
            this.prevInstruction.setTime(this.weighting.calcEdgeMillis(edge, false) + this.prevInstruction.getTime());
        }
    }
}

