/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.graphhopper.routing.DefaultBidirPathExtractor;
import com.graphhopper.routing.SPTEntry;
import com.graphhopper.routing.ch.CHEntry;
import com.graphhopper.routing.ch.ShortcutUnpacker;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.RoutingCHGraph;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.GHUtility;

public class EdgeBasedCHBidirPathExtractor
extends DefaultBidirPathExtractor {
    private final RoutingCHGraph routingGraph;
    private final ShortcutUnpacker shortcutUnpacker;
    private final Weighting weighting;

    public EdgeBasedCHBidirPathExtractor(RoutingCHGraph routingGraph) {
        super(routingGraph.getBaseGraph(), null);
        this.routingGraph = routingGraph;
        this.shortcutUnpacker = this.createShortcutUnpacker();
        this.weighting = routingGraph.getBaseGraph().wrapWeighting(routingGraph.getWeighting());
    }

    @Override
    public void onEdge(int edge, int adjNode, boolean reverse, int prevOrNextEdge) {
        if (reverse) {
            this.shortcutUnpacker.visitOriginalEdgesBwd(edge, adjNode, true, prevOrNextEdge);
        } else {
            this.shortcutUnpacker.visitOriginalEdgesFwd(edge, adjNode, true, prevOrNextEdge);
        }
    }

    @Override
    protected void onMeetingPoint(int inEdge, int viaNode, int outEdge) {
        if (!EdgeIterator.Edge.isValid(inEdge) || !EdgeIterator.Edge.isValid(outEdge)) {
            return;
        }
        this.path.addTime(this.weighting.calcTurnMillis(inEdge, viaNode, outEdge));
    }

    private ShortcutUnpacker createShortcutUnpacker() {
        return new ShortcutUnpacker(this.routingGraph, (edge, reverse, prevOrNextEdgeId) -> {
            this.path.addDistance(edge.getDistance());
            this.path.addTime(GHUtility.calcMillisWithTurnMillis(this.weighting, edge, reverse, prevOrNextEdgeId));
            this.path.addEdge(edge.getEdge());
        }, true);
    }

    @Override
    public int getIncEdge(SPTEntry sptEntry) {
        return ((CHEntry)sptEntry).incEdge;
    }
}

