/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.carrotsearch.hppc.IntArrayList;
import com.graphhopper.apache.commons.collections.IntFloatBinaryHeap;
import com.graphhopper.routing.ch.CHPreparationGraph;
import com.graphhopper.routing.ch.PrepareGraphEdgeExplorer;
import com.graphhopper.routing.ch.PrepareGraphEdgeIterator;
import com.graphhopper.routing.ch.PrepareGraphOrigEdgeExplorer;
import com.graphhopper.routing.ch.PrepareGraphOrigEdgeIterator;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import java.util.Arrays;
import java.util.Locale;

public class EdgeBasedWitnessPathSearcher {
    private static final int NO_NODE = -1;
    private static final double MAX_ZERO_WEIGHT_LOOP = 0.001;
    private final CHPreparationGraph prepareGraph;
    private PrepareGraphEdgeExplorer outEdgeExplorer;
    private PrepareGraphOrigEdgeExplorer origInEdgeExplorer;
    private int sourceNode;
    private int centerNode;
    private int numPolls;
    private int numUpdates;
    private double[] weights;
    private int[] parents;
    private int[] adjNodesAndIsPathToCenters;
    private IntArrayList changedEdgeKeys;
    private IntFloatBinaryHeap dijkstraHeap;
    private Stats stats;

    public EdgeBasedWitnessPathSearcher(CHPreparationGraph prepareGraph) {
        this.prepareGraph = prepareGraph;
        this.outEdgeExplorer = prepareGraph.createOutEdgeExplorer();
        this.origInEdgeExplorer = prepareGraph.createInOrigEdgeExplorer();
        this.initStorage(2 * prepareGraph.getOriginalEdges());
        this.initCollections();
    }

    public void initSearch(int sourceEdgeKey, int sourceNode, int centerNode, Stats stats) {
        this.stats = stats;
        ++stats.numTrees;
        this.sourceNode = sourceNode;
        this.centerNode = centerNode;
        this.weights[sourceEdgeKey] = 0.0;
        this.parents[sourceEdgeKey] = -1;
        this.setAdjNodeAndPathToCenter(sourceEdgeKey, sourceNode, true);
        this.changedEdgeKeys.add(sourceEdgeKey);
        this.dijkstraHeap.insert(0.0, sourceEdgeKey);
    }

    public double runSearch(int targetNode, int targetEdgeKey, double acceptedWeight, int maxPolls) {
        ++this.stats.numSearches;
        PrepareGraphOrigEdgeIterator inIter = this.origInEdgeExplorer.setBaseNode(targetNode);
        while (inIter.next()) {
            double weight;
            int edgeKey = GHUtility.reverseEdgeKey(inIter.getOrigEdgeKeyLast());
            if (this.weights[edgeKey] == Double.POSITIVE_INFINITY || !((weight = this.weights[edgeKey] + this.calcTurnWeight(edgeKey, targetNode, targetEdgeKey)) < acceptedWeight) && (weight != acceptedWeight || this.parents[edgeKey] >= 0 && this.isPathToCenter(this.parents[edgeKey]))) continue;
            return weight;
        }
        while (!this.dijkstraHeap.isEmpty() && this.numPolls < maxPolls && this.weights[this.dijkstraHeap.peekElement()] < acceptedWeight) {
            int currKey = this.dijkstraHeap.poll();
            ++this.numPolls;
            int currNode = this.getAdjNode(currKey);
            PrepareGraphEdgeIterator iter = this.outEdgeExplorer.setBaseNode(currNode);
            double foundWeight = Double.POSITIVE_INFINITY;
            while (iter.next()) {
                boolean isPathToCenter;
                double weight;
                if (currNode == this.sourceNode && iter.getAdjNode() == this.sourceNode && iter.getWeight() < 0.001 || Double.isInfinite(weight = this.weights[currKey] + this.calcTurnWeight(currKey, currNode, iter.getOrigEdgeKeyFirst()) + iter.getWeight())) continue;
                int key = iter.getOrigEdgeKeyLast();
                boolean bl = isPathToCenter = this.isPathToCenter(currKey) && iter.getAdjNode() == this.centerNode;
                if (this.weights[key] == Double.POSITIVE_INFINITY) {
                    this.weights[key] = weight;
                    this.parents[key] = currKey;
                    this.setAdjNodeAndPathToCenter(key, iter.getAdjNode(), isPathToCenter);
                    this.changedEdgeKeys.add(key);
                    this.dijkstraHeap.insert(weight, key);
                    if (iter.getAdjNode() != targetNode || this.isPathToCenter(currKey) && this.parents[currKey] >= 0) continue;
                    foundWeight = Math.min(foundWeight, weight + this.calcTurnWeight(key, targetNode, targetEdgeKey));
                    continue;
                }
                if (!(weight < this.weights[key]) && (weight != this.weights[key] || this.isPathToCenter(currKey))) continue;
                ++this.numUpdates;
                this.weights[key] = weight;
                this.parents[key] = currKey;
                this.setAdjNodeAndPathToCenter(key, iter.getAdjNode(), isPathToCenter);
                this.dijkstraHeap.update(weight, key);
                if (iter.getAdjNode() != targetNode || this.isPathToCenter(currKey) && this.parents[currKey] >= 0) continue;
                foundWeight = Math.min(foundWeight, weight + this.calcTurnWeight(key, targetNode, targetEdgeKey));
            }
            if (!(foundWeight <= acceptedWeight)) continue;
            return foundWeight;
        }
        if (this.numPolls == maxPolls) {
            ++this.stats.numCapped;
        }
        return Double.POSITIVE_INFINITY;
    }

    public void finishSearch() {
        this.stats.numPolls += (long)this.numPolls;
        this.stats.maxPolls = Math.max(this.stats.maxPolls, (long)this.numPolls);
        this.stats.numExplored += (long)this.changedEdgeKeys.size();
        this.stats.maxExplored = Math.max(this.stats.maxExplored, (long)this.changedEdgeKeys.size());
        this.stats.numUpdates += (long)this.numUpdates;
        this.stats.maxUpdates = Math.max(this.stats.maxUpdates, (long)this.numUpdates);
        this.reset();
    }

    private void setAdjNodeAndPathToCenter(int key, int adjNode, boolean isPathToCenter) {
        this.adjNodesAndIsPathToCenters[key] = (adjNode << 1) + (isPathToCenter ? 1 : 0);
    }

    private int getAdjNode(int key) {
        return this.adjNodesAndIsPathToCenters[key] >> 1;
    }

    private boolean isPathToCenter(int key) {
        return (this.adjNodesAndIsPathToCenters[key] & 1) == 1;
    }

    public void close() {
        this.prepareGraph.close();
        this.outEdgeExplorer = null;
        this.origInEdgeExplorer = null;
        this.weights = null;
        this.parents = null;
        this.adjNodesAndIsPathToCenters = null;
        this.changedEdgeKeys.release();
        this.dijkstraHeap = null;
    }

    private void initStorage(int numEntries) {
        this.weights = new double[numEntries];
        Arrays.fill(this.weights, Double.POSITIVE_INFINITY);
        this.parents = new int[numEntries];
        Arrays.fill(this.parents, -1);
        this.adjNodesAndIsPathToCenters = new int[numEntries];
        Arrays.fill(this.adjNodesAndIsPathToCenters, -2);
    }

    private void initCollections() {
        this.changedEdgeKeys = new IntArrayList(1000);
        this.dijkstraHeap = new IntFloatBinaryHeap(1000);
    }

    private void reset() {
        this.numPolls = 0;
        this.numUpdates = 0;
        this.resetShortestPathTree();
    }

    private void resetShortestPathTree() {
        for (int i = 0; i < this.changedEdgeKeys.size(); ++i) {
            this.resetEntry(this.changedEdgeKeys.get(i));
        }
        this.changedEdgeKeys.elementsCount = 0;
        this.dijkstraHeap.clear();
    }

    private void resetEntry(int key) {
        this.weights[key] = Double.POSITIVE_INFINITY;
        this.parents[key] = -1;
        this.setAdjNodeAndPathToCenter(key, -1, false);
    }

    private double calcTurnWeight(int inEdgeKey, int viaNode, int outEdgeKey) {
        return this.prepareGraph.getTurnWeight(inEdgeKey, viaNode, outEdgeKey);
    }

    static class Stats {
        long numTrees;
        long numSearches;
        long numPolls;
        long maxPolls;
        long numExplored;
        long maxExplored;
        long numUpdates;
        long maxUpdates;
        long numCapped;

        Stats() {
        }

        public String toString() {
            return String.format(Locale.ROOT, "trees: %12s, searches: %15s, capped: %12s (%5.2f%%), polled: avg %s max %6d, explored: avg %s max %6d, updated: avg %s max %6d", Helper.nf((long)this.numTrees), Helper.nf((long)this.numSearches), Helper.nf((long)this.numCapped), 100.0 * (double)this.numCapped / (double)this.numSearches, this.quotient(this.numPolls, this.numTrees), this.maxPolls, this.quotient(this.numExplored, this.numTrees), this.maxExplored, this.quotient(this.numUpdates, this.numTrees), this.maxUpdates);
        }

        private String quotient(long a, long b) {
            return b == 0L ? "NaN" : String.format(Locale.ROOT, "%5.1f", (double)a / (double)b);
        }
    }
}

