/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ev;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.graphhopper.routing.ev.IntEncodedValueImpl;
import com.graphhopper.storage.IntsRef;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class StringEncodedValue
extends IntEncodedValueImpl {
    private final int maxValues;
    private final List<String> values;
    private final Map<String, Integer> indexMap;

    public StringEncodedValue(String name, int expectedValueCount) {
        this(name, expectedValueCount, false);
    }

    public StringEncodedValue(String name, int expectedValueCount, boolean storeTwoDirections) {
        super(name, 32 - Integer.numberOfLeadingZeros(expectedValueCount), storeTwoDirections);
        this.maxValues = StringEncodedValue.roundUp(expectedValueCount);
        this.values = new ArrayList<String>(this.maxValues);
        this.indexMap = new HashMap<String, Integer>(this.maxValues);
    }

    public StringEncodedValue(String name, int bits, List<String> values, boolean storeTwoDirections) {
        super(name, bits, storeTwoDirections);
        this.maxValues = (1 << bits) - 1;
        if (values.size() > this.maxValues) {
            throw new IllegalArgumentException("Number of values is higher than the maximum value count: " + values.size() + " > " + this.maxValues);
        }
        this.values = new ArrayList<String>(values);
        this.indexMap = new HashMap<String, Integer>(values.size());
        int index = 1;
        for (String value : values) {
            this.indexMap.put(value, index++);
        }
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    StringEncodedValue(@JsonProperty(value="name") String name, @JsonProperty(value="bits") int bits, @JsonProperty(value="min_storable_value") int minStorableValue, @JsonProperty(value="max_storable_value") int maxStorableValue, @JsonProperty(value="max_value") int maxValue, @JsonProperty(value="negate_reverse_direction") boolean negateReverseDirection, @JsonProperty(value="store_two_directions") boolean storeTwoDirections, @JsonProperty(value="fwd_data_index") int fwdDataIndex, @JsonProperty(value="bwd_data_index") int bwdDataIndex, @JsonProperty(value="fwd_shift") int fwdShift, @JsonProperty(value="bwd_shift") int bwdShift, @JsonProperty(value="fwd_mask") int fwdMask, @JsonProperty(value="bwd_mask") int bwdMask, @JsonProperty(value="max_values") int maxValues, @JsonProperty(value="values") List<String> values, @JsonProperty(value="index_map") HashMap<String, Integer> indexMap) {
        super(name, bits, minStorableValue, maxStorableValue, maxValue, negateReverseDirection, storeTwoDirections, fwdDataIndex, bwdDataIndex, fwdShift, bwdShift, fwdMask, bwdMask);
        if (values.size() > maxValues) {
            throw new IllegalArgumentException("Number of values is higher than the maximum value count: " + values.size() + " > " + maxValues);
        }
        this.maxValues = maxValues;
        this.values = values;
        this.indexMap = indexMap;
    }

    public final void setString(boolean reverse, IntsRef ref, String value) {
        if (value == null) {
            super.setInt(reverse, ref, 0);
            return;
        }
        int index = this.indexMap.getOrDefault(value, 0);
        if (index == 0) {
            if (this.values.size() == this.maxValues) {
                throw new IllegalStateException("Maximum number of values reached for " + this.getName() + ": " + this.maxValues);
            }
            this.values.add(value);
            index = this.values.size();
            this.indexMap.put(value, index);
        }
        super.setInt(reverse, ref, index);
    }

    public final String getString(boolean reverse, IntsRef ref) {
        int value = super.getInt(reverse, ref);
        if (value == 0) {
            return null;
        }
        return this.values.get(value - 1);
    }

    private static int roundUp(int value) {
        return -1 >>> Integer.numberOfLeadingZeros(value);
    }

    public int indexOf(String value) {
        return this.indexMap.getOrDefault(value, 0);
    }

    public List<String> getValues() {
        return Collections.unmodifiableList(this.values);
    }
}

