/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.lm;

import com.graphhopper.routing.util.AreaIndex;
import com.graphhopper.util.JsonFeature;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.PolygonExtracter;

public class SplitArea
implements AreaIndex.Area {
    private final List<Polygon> borders;

    public static SplitArea fromJsonFeature(JsonFeature j) {
        ArrayList<Polygon> borders = new ArrayList<Polygon>();
        for (int i = 0; i < j.getGeometry().getNumGeometries(); ++i) {
            Geometry geometry = j.getGeometry().getGeometryN(i);
            if (!(geometry instanceof Polygon)) {
                throw new IllegalArgumentException("GeoJson features used to create split areas must be of type 'Polygon', but was: " + geometry.getClass().getSimpleName());
            }
            PolygonExtracter.getPolygons((Geometry)geometry, borders);
        }
        return new SplitArea(borders);
    }

    public SplitArea(List<Polygon> borders) {
        this.borders = borders;
    }

    @Override
    public List<Polygon> getBorders() {
        return this.borders;
    }
}

