/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.BikeNetwork;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.RouteNetwork;
import com.graphhopper.routing.ev.Smoothness;
import com.graphhopper.routing.ev.TurnCost;
import com.graphhopper.routing.ev.VehicleAccess;
import com.graphhopper.routing.ev.VehiclePriority;
import com.graphhopper.routing.ev.VehicleSpeed;
import com.graphhopper.routing.util.BikeTagParser;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import com.graphhopper.util.PointList;

public class Bike2WeightTagParser
extends BikeTagParser {
    public Bike2WeightTagParser(EncodedValueLookup lookup, PMap properties) {
        this(lookup.getBooleanEncodedValue(VehicleAccess.key(properties.getString("name", "bike2"))), lookup.getDecimalEncodedValue(VehicleSpeed.key(properties.getString("name", "bike2"))), lookup.getDecimalEncodedValue(VehiclePriority.key(properties.getString("name", "bike2"))), lookup.getEnumEncodedValue(BikeNetwork.KEY, RouteNetwork.class), lookup.getBooleanEncodedValue("roundabout"), lookup.getEnumEncodedValue("smoothness", Smoothness.class), lookup.hasEncodedValue(TurnCost.key(properties.getString("name", "bike2"))) ? lookup.getDecimalEncodedValue(TurnCost.key(properties.getString("name", "bike2"))) : null, properties);
    }

    public Bike2WeightTagParser(BooleanEncodedValue accessEnc, DecimalEncodedValue speedEnc, DecimalEncodedValue priorityEnc, EnumEncodedValue<RouteNetwork> bikeRouteEnc, BooleanEncodedValue roundaboutEnc, EnumEncodedValue<Smoothness> smoothnessEnc, DecimalEncodedValue turnCostEnc, PMap properties) {
        super(accessEnc, speedEnc, priorityEnc, bikeRouteEnc, smoothnessEnc, properties.getString("name", "bike2"), roundaboutEnc, turnCostEnc);
        this.blockPrivate(properties.getBool("block_private", true));
        this.blockFords(properties.getBool("block_fords", false));
    }

    @Override
    public void applyWayTags(ReaderWay way, EdgeIteratorState edge) {
        PointList pl = edge.fetchWayGeometry(FetchMode.ALL);
        if (!pl.is3D()) {
            throw new IllegalStateException(this.getName() + " requires elevation data to improve speed calculation based on it. Please enable it in config via e.g. graph.elevation.provider: srtm");
        }
        IntsRef intsRef = edge.getFlags();
        if (way.hasTag("tunnel", (Object)"yes") || way.hasTag("bridge", (Object)"yes") || way.hasTag("highway", (Object)"steps")) {
            return;
        }
        double incEleSum = 0.0;
        double incDist2DSum = 0.0;
        double decEleSum = 0.0;
        double decDist2DSum = 0.0;
        double prevEle = pl.getEle(0);
        double fullDist2D = edge.getDistance();
        if (fullDist2D < 2.0) {
            return;
        }
        double eleDelta = pl.getEle(pl.size() - 1) - prevEle;
        if (eleDelta > 0.1) {
            incEleSum = eleDelta;
            incDist2DSum = fullDist2D;
        } else if (eleDelta < -0.1) {
            decEleSum = -eleDelta;
            decDist2DSum = fullDist2D;
        }
        double fwdIncline = incDist2DSum > 1.0 ? incEleSum / incDist2DSum : 0.0;
        double fwdDecline = decDist2DSum > 1.0 ? decEleSum / decDist2DSum : 0.0;
        double restDist2D = fullDist2D - incDist2DSum - decDist2DSum;
        double maxSpeed = this.getHighwaySpeed("cycleway");
        if (this.accessEnc.getBool(false, intsRef)) {
            double speed = this.avgSpeedEnc.getDecimal(false, intsRef);
            double fwdFaster = 1.0 + 2.0 * Helper.keepIn((double)fwdDecline, (double)0.0, (double)0.2);
            fwdFaster *= fwdFaster;
            double fwdSlower = 1.0 - 5.0 * Helper.keepIn((double)fwdIncline, (double)0.0, (double)0.2);
            fwdSlower *= fwdSlower;
            speed = speed * (fwdSlower * incDist2DSum + fwdFaster * decDist2DSum + 1.0 * restDist2D) / fullDist2D;
            this.setSpeed(false, intsRef, Helper.keepIn((double)speed, (double)2.0, (double)maxSpeed));
        }
        if (this.accessEnc.getBool(true, intsRef)) {
            double speedReverse = this.avgSpeedEnc.getDecimal(true, intsRef);
            double bwFaster = 1.0 + 2.0 * Helper.keepIn((double)fwdIncline, (double)0.0, (double)0.2);
            bwFaster *= bwFaster;
            double bwSlower = 1.0 - 5.0 * Helper.keepIn((double)fwdDecline, (double)0.0, (double)0.2);
            bwSlower *= bwSlower;
            speedReverse = speedReverse * (bwFaster * incDist2DSum + bwSlower * decDist2DSum + 1.0 * restDist2D) / fullDist2D;
            this.setSpeed(true, intsRef, Helper.keepIn((double)speedReverse, (double)2.0, (double)maxSpeed));
        }
        edge.setFlags(intsRef);
    }
}

