/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.RouteNetwork;
import com.graphhopper.routing.ev.Smoothness;
import com.graphhopper.routing.util.PriorityCode;
import com.graphhopper.routing.util.TransportationMode;
import com.graphhopper.routing.util.VehicleTagParser;
import com.graphhopper.routing.util.WayAccess;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.Helper;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class BikeCommonTagParser
extends VehicleTagParser {
    public static double MAX_SPEED = 30.0;
    protected static final int PUSHING_SECTION_SPEED = 4;
    protected static final int MIN_SPEED = 2;
    protected final HashSet<String> pushingSectionsHighways = new HashSet();
    protected final HashSet<String> oppositeLanes = new HashSet();
    protected final Set<String> preferHighwayTags = new HashSet<String>();
    protected final Set<String> avoidHighwayTags = new HashSet<String>();
    protected final Set<String> unpavedSurfaceTags = new HashSet<String>();
    private final Map<String, Integer> trackTypeSpeeds = new HashMap<String, Integer>();
    private final Map<String, Integer> surfaceSpeeds = new HashMap<String, Integer>();
    private final Map<Smoothness, Double> smoothnessFactor = new HashMap<Smoothness, Double>();
    private final Map<String, Integer> highwaySpeeds = new HashMap<String, Integer>();
    protected final DecimalEncodedValue priorityEnc;
    private int avoidSpeedLimit;
    EnumEncodedValue<RouteNetwork> bikeRouteEnc;
    EnumEncodedValue<Smoothness> smoothnessEnc;
    Map<RouteNetwork, Integer> routeMap = new HashMap<RouteNetwork, Integer>();
    private String classBicycleKey;

    protected BikeCommonTagParser(BooleanEncodedValue accessEnc, DecimalEncodedValue speedEnc, DecimalEncodedValue priorityEnc, EnumEncodedValue<RouteNetwork> bikeRouteEnc, EnumEncodedValue<Smoothness> smoothnessEnc, String name, BooleanEncodedValue roundaboutEnc, DecimalEncodedValue turnCostEnc) {
        super(accessEnc, speedEnc, name, roundaboutEnc, turnCostEnc, TransportationMode.BIKE, speedEnc.getNextStorableValue(MAX_SPEED));
        this.bikeRouteEnc = bikeRouteEnc;
        this.smoothnessEnc = smoothnessEnc;
        this.priorityEnc = priorityEnc;
        this.restrictedValues.add("agricultural");
        this.restrictedValues.add("forestry");
        this.restrictedValues.add("no");
        this.restrictedValues.add("restricted");
        this.restrictedValues.add("delivery");
        this.restrictedValues.add("military");
        this.restrictedValues.add("emergency");
        this.restrictedValues.add("private");
        this.intendedValues.add("yes");
        this.intendedValues.add("designated");
        this.intendedValues.add("official");
        this.intendedValues.add("permissive");
        this.oppositeLanes.add("opposite");
        this.oppositeLanes.add("opposite_lane");
        this.oppositeLanes.add("opposite_track");
        this.barriers.add("fence");
        this.unpavedSurfaceTags.add("unpaved");
        this.unpavedSurfaceTags.add("gravel");
        this.unpavedSurfaceTags.add("ground");
        this.unpavedSurfaceTags.add("dirt");
        this.unpavedSurfaceTags.add("grass");
        this.unpavedSurfaceTags.add("compacted");
        this.unpavedSurfaceTags.add("earth");
        this.unpavedSurfaceTags.add("fine_gravel");
        this.unpavedSurfaceTags.add("grass_paver");
        this.unpavedSurfaceTags.add("ice");
        this.unpavedSurfaceTags.add("mud");
        this.unpavedSurfaceTags.add("salt");
        this.unpavedSurfaceTags.add("sand");
        this.unpavedSurfaceTags.add("wood");
        this.setTrackTypeSpeed("grade1", 18);
        this.setTrackTypeSpeed("grade2", 12);
        this.setTrackTypeSpeed("grade3", 8);
        this.setTrackTypeSpeed("grade4", 6);
        this.setTrackTypeSpeed("grade5", 4);
        this.setSurfaceSpeed("paved", 18);
        this.setSurfaceSpeed("asphalt", 18);
        this.setSurfaceSpeed("cobblestone", 8);
        this.setSurfaceSpeed("cobblestone:flattened", 10);
        this.setSurfaceSpeed("sett", 10);
        this.setSurfaceSpeed("concrete", 18);
        this.setSurfaceSpeed("concrete:lanes", 16);
        this.setSurfaceSpeed("concrete:plates", 16);
        this.setSurfaceSpeed("paving_stones", 14);
        this.setSurfaceSpeed("paving_stones:30", 14);
        this.setSurfaceSpeed("unpaved", 12);
        this.setSurfaceSpeed("compacted", 14);
        this.setSurfaceSpeed("dirt", 10);
        this.setSurfaceSpeed("earth", 12);
        this.setSurfaceSpeed("fine_gravel", 18);
        this.setSurfaceSpeed("grass", 8);
        this.setSurfaceSpeed("grass_paver", 8);
        this.setSurfaceSpeed("gravel", 12);
        this.setSurfaceSpeed("ground", 12);
        this.setSurfaceSpeed("ice", 2);
        this.setSurfaceSpeed("metal", 10);
        this.setSurfaceSpeed("mud", 10);
        this.setSurfaceSpeed("pebblestone", 14);
        this.setSurfaceSpeed("salt", 4);
        this.setSurfaceSpeed("sand", 4);
        this.setSurfaceSpeed("wood", 4);
        this.setHighwaySpeed("living_street", 4);
        this.setHighwaySpeed("steps", 2);
        this.avoidHighwayTags.add("steps");
        int CYCLEWAY_SPEED = 18;
        this.setHighwaySpeed("cycleway", 18);
        this.setHighwaySpeed("path", 10);
        this.setHighwaySpeed("footway", 6);
        this.setHighwaySpeed("platform", 4);
        this.setHighwaySpeed("pedestrian", 4);
        this.setHighwaySpeed("track", 12);
        this.setHighwaySpeed("service", 14);
        this.setHighwaySpeed("residential", 18);
        this.setHighwaySpeed("unclassified", 16);
        this.setHighwaySpeed("road", 12);
        this.setHighwaySpeed("trunk", 18);
        this.setHighwaySpeed("trunk_link", 18);
        this.setHighwaySpeed("primary", 18);
        this.setHighwaySpeed("primary_link", 18);
        this.setHighwaySpeed("secondary", 18);
        this.setHighwaySpeed("secondary_link", 18);
        this.setHighwaySpeed("tertiary", 18);
        this.setHighwaySpeed("tertiary_link", 18);
        this.setHighwaySpeed("motorway", 18);
        this.setHighwaySpeed("motorway_link", 18);
        this.avoidHighwayTags.add("motorway");
        this.avoidHighwayTags.add("motorway_link");
        this.setHighwaySpeed("bridleway", 4);
        this.avoidHighwayTags.add("bridleway");
        this.routeMap.put(RouteNetwork.INTERNATIONAL, PriorityCode.BEST.getValue());
        this.routeMap.put(RouteNetwork.NATIONAL, PriorityCode.BEST.getValue());
        this.routeMap.put(RouteNetwork.REGIONAL, PriorityCode.VERY_NICE.getValue());
        this.routeMap.put(RouteNetwork.LOCAL, PriorityCode.PREFER.getValue());
        this.setSmoothnessSpeedFactor(Smoothness.MISSING, 1.0);
        this.setSmoothnessSpeedFactor(Smoothness.OTHER, 0.7);
        this.setSmoothnessSpeedFactor(Smoothness.EXCELLENT, 1.1);
        this.setSmoothnessSpeedFactor(Smoothness.GOOD, 1.0);
        this.setSmoothnessSpeedFactor(Smoothness.INTERMEDIATE, 0.9);
        this.setSmoothnessSpeedFactor(Smoothness.BAD, 0.7);
        this.setSmoothnessSpeedFactor(Smoothness.VERY_BAD, 0.4);
        this.setSmoothnessSpeedFactor(Smoothness.HORRIBLE, 0.3);
        this.setSmoothnessSpeedFactor(Smoothness.VERY_HORRIBLE, 0.1);
        this.setSmoothnessSpeedFactor(Smoothness.IMPASSABLE, 0.0);
        this.setAvoidSpeedLimit(71);
    }

    @Override
    public WayAccess getAccess(ReaderWay way) {
        String highwayValue = way.getTag("highway");
        if (highwayValue == null) {
            String bikeTag;
            WayAccess access = WayAccess.CAN_SKIP;
            if (way.hasTag("route", (Collection<String>)this.ferries) && ((bikeTag = way.getTag("bicycle")) == null && !way.hasTag("foot", new String[0]) || this.intendedValues.contains(bikeTag))) {
                access = WayAccess.FERRY;
            }
            if (way.hasTag("railway", (Object)"platform")) {
                access = WayAccess.WAY;
            }
            if (way.hasTag("man_made", (Object)"pier")) {
                access = WayAccess.WAY;
            }
            if (!access.canSkip()) {
                if (way.hasTag(this.restrictions, (Collection<String>)this.restrictedValues) && !this.getConditionalTagInspector().isRestrictedWayConditionallyPermitted(way)) {
                    return WayAccess.CAN_SKIP;
                }
                return access;
            }
            return WayAccess.CAN_SKIP;
        }
        if (!this.highwaySpeeds.containsKey(highwayValue)) {
            return WayAccess.CAN_SKIP;
        }
        String sacScale = way.getTag("sac_scale");
        if (sacScale != null && !this.isSacScaleAllowed(sacScale)) {
            return WayAccess.CAN_SKIP;
        }
        if (way.hasTag("bicycle", (Collection<String>)this.intendedValues) || way.hasTag("bicycle", (Object)"dismount") || way.hasTag("highway", (Object)"cycleway")) {
            return WayAccess.WAY;
        }
        if ("motorway".equals(highwayValue) || "motorway_link".equals(highwayValue) || "bridleway".equals(highwayValue)) {
            return WayAccess.CAN_SKIP;
        }
        if (way.hasTag("motorroad", (Object)"yes")) {
            return WayAccess.CAN_SKIP;
        }
        if (this.isBlockFords() && (way.hasTag("highway", (Object)"ford") || way.hasTag("ford", new String[0]))) {
            return WayAccess.CAN_SKIP;
        }
        if (way.hasTag(this.restrictions, (Collection<String>)this.restrictedValues) && !this.getConditionalTagInspector().isRestrictedWayConditionallyPermitted(way)) {
            return WayAccess.CAN_SKIP;
        }
        if (this.getConditionalTagInspector().isPermittedWayConditionallyRestricted(way)) {
            return WayAccess.CAN_SKIP;
        }
        return WayAccess.WAY;
    }

    boolean isSacScaleAllowed(String sacScale) {
        return "hiking".equals(sacScale);
    }

    protected double applyMaxSpeed(ReaderWay way, double speed) {
        double maxSpeed = BikeCommonTagParser.getMaxSpeed(way);
        if (BikeCommonTagParser.isValidSpeed(maxSpeed) && speed > maxSpeed) {
            return maxSpeed;
        }
        if (BikeCommonTagParser.isValidSpeed(speed) && speed > this.maxPossibleSpeed) {
            return this.maxPossibleSpeed;
        }
        return speed;
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay way) {
        WayAccess access = this.getAccess(way);
        if (access.canSkip()) {
            return edgeFlags;
        }
        Integer priorityFromRelation = this.routeMap.get((Object)this.bikeRouteEnc.getEnum(false, edgeFlags));
        double wayTypeSpeed = this.getSpeed(way);
        if (!access.isFerry()) {
            wayTypeSpeed = this.applyMaxSpeed(way, wayTypeSpeed);
            Smoothness smoothness = this.smoothnessEnc.getEnum(false, edgeFlags);
            wayTypeSpeed = Math.max(2.0, this.smoothnessFactor.get((Object)smoothness) * wayTypeSpeed);
            this.avgSpeedEnc.setDecimal(false, edgeFlags, wayTypeSpeed);
            if (this.avgSpeedEnc.isStoreTwoDirections()) {
                this.avgSpeedEnc.setDecimal(true, edgeFlags, wayTypeSpeed);
            }
            this.handleAccess(edgeFlags, way);
        } else {
            double ferrySpeed = this.ferrySpeedCalc.getSpeed(way);
            this.avgSpeedEnc.setDecimal(false, edgeFlags, ferrySpeed);
            if (this.avgSpeedEnc.isStoreTwoDirections()) {
                this.avgSpeedEnc.setDecimal(true, edgeFlags, ferrySpeed);
            }
            this.accessEnc.setBool(false, edgeFlags, true);
            this.accessEnc.setBool(true, edgeFlags, true);
            priorityFromRelation = PriorityCode.SLIGHT_AVOID.getValue();
        }
        this.priorityEnc.setDecimal(false, edgeFlags, PriorityCode.getValue(this.handlePriority(way, wayTypeSpeed, priorityFromRelation)));
        return edgeFlags;
    }

    int getSpeed(ReaderWay way) {
        int speed = 4;
        String highwayTag = way.getTag("highway");
        Integer highwaySpeed = this.highwaySpeeds.get(highwayTag);
        if (way.hasTag("highway", this.pushingSectionsHighways) && (way.hasTag("foot", (Object)"yes") && way.hasTag("segregated", (Object)"yes") || way.hasTag("bicycle", (Collection<String>)this.intendedValues))) {
            highwaySpeed = this.getHighwaySpeed("cycleway");
        }
        String s = way.getTag("surface");
        Integer surfaceSpeed = 0;
        if (!Helper.isEmpty((String)s)) {
            surfaceSpeed = this.surfaceSpeeds.get(s);
            if (surfaceSpeed != null) {
                speed = surfaceSpeed;
                if (highwaySpeed != null && surfaceSpeed > highwaySpeed) {
                    speed = this.pushingSectionsHighways.contains(highwayTag) ? highwaySpeed.intValue() : surfaceSpeed.intValue();
                }
            }
        } else {
            String tt = way.getTag("tracktype");
            if (!Helper.isEmpty((String)tt)) {
                Integer tInt = this.trackTypeSpeeds.get(tt);
                if (tInt != null) {
                    speed = tInt;
                }
            } else if (highwaySpeed != null) {
                speed = !way.hasTag("service", new String[0]) ? highwaySpeed.intValue() : this.highwaySpeeds.get("living_street").intValue();
            }
        }
        if (speed > 4 && (way.hasTag("highway", this.pushingSectionsHighways) || way.hasTag("bicycle", (Object)"dismount"))) {
            if (!way.hasTag("bicycle", (Collection<String>)this.intendedValues)) {
                speed = way.hasTag("highway", (Object)"steps") ? 2 : 4;
            } else if (way.hasTag("bicycle", (Object)"designated") || way.hasTag("bicycle", (Object)"official") || way.hasTag("segregated", (Object)"yes") || way.hasTag("bicycle", (Object)"yes")) {
                if (way.hasTag("segregated", (Object)"yes")) {
                    speed = this.highwaySpeeds.get("cycleway");
                } else {
                    int n = speed = way.hasTag("bicycle", (Object)"yes") ? 10 : this.highwaySpeeds.get("cycleway");
                }
                if (surfaceSpeed > 0) {
                    speed = Math.min(speed, surfaceSpeed);
                }
            }
        }
        return speed;
    }

    int handlePriority(ReaderWay way, double wayTypeSpeed, Integer priorityFromRelation) {
        TreeMap<Double, Integer> weightToPrioMap = new TreeMap<Double, Integer>();
        if (priorityFromRelation == null) {
            weightToPrioMap.put(0.0, PriorityCode.UNCHANGED.getValue());
        } else {
            weightToPrioMap.put(110.0, priorityFromRelation);
        }
        this.collect(way, wayTypeSpeed, weightToPrioMap);
        return weightToPrioMap.lastEntry().getValue();
    }

    private PriorityCode convertClassValueToPriority(String tagvalue) {
        int classvalue;
        try {
            classvalue = Integer.parseInt(tagvalue);
        }
        catch (NumberFormatException e) {
            return PriorityCode.UNCHANGED;
        }
        switch (classvalue) {
            case 3: {
                return PriorityCode.BEST;
            }
            case 2: {
                return PriorityCode.VERY_NICE;
            }
            case 1: {
                return PriorityCode.PREFER;
            }
            case 0: {
                return PriorityCode.UNCHANGED;
            }
            case -1: {
                return PriorityCode.SLIGHT_AVOID;
            }
            case -2: {
                return PriorityCode.AVOID;
            }
            case -3: {
                return PriorityCode.AVOID_MORE;
            }
        }
        return PriorityCode.UNCHANGED;
    }

    void collect(ReaderWay way, double wayTypeSpeed, TreeMap<Double, Integer> weightToPrioMap) {
        String classBicycleValue;
        String service = way.getTag("service");
        String highway = way.getTag("highway");
        if (way.hasTag("bicycle", (Object)"designated") || way.hasTag("bicycle", (Object)"official")) {
            if ("path".equals(highway)) {
                weightToPrioMap.put(100.0, PriorityCode.VERY_NICE.getValue());
            } else {
                weightToPrioMap.put(100.0, PriorityCode.PREFER.getValue());
            }
        }
        if ("cycleway".equals(highway)) {
            if (way.hasTag("foot", (Collection<String>)this.intendedValues) && !way.hasTag("segregated", (Object)"yes")) {
                weightToPrioMap.put(100.0, PriorityCode.PREFER.getValue());
            } else {
                weightToPrioMap.put(100.0, PriorityCode.VERY_NICE.getValue());
            }
        }
        double maxSpeed = BikeCommonTagParser.getMaxSpeed(way);
        if (this.preferHighwayTags.contains(highway) || BikeCommonTagParser.isValidSpeed(maxSpeed) && maxSpeed <= 30.0) {
            if (!BikeCommonTagParser.isValidSpeed(maxSpeed) || maxSpeed < (double)this.avoidSpeedLimit) {
                weightToPrioMap.put(40.0, PriorityCode.PREFER.getValue());
                if (way.hasTag("tunnel", (Collection<String>)this.intendedValues)) {
                    weightToPrioMap.put(40.0, PriorityCode.UNCHANGED.getValue());
                }
            }
        } else if (this.avoidHighwayTags.contains(highway) || BikeCommonTagParser.isValidSpeed(maxSpeed) && maxSpeed >= (double)this.avoidSpeedLimit && !"track".equals(highway)) {
            weightToPrioMap.put(50.0, PriorityCode.AVOID.getValue());
            if (way.hasTag("tunnel", (Collection<String>)this.intendedValues) || way.hasTag("hazmat", (Collection<String>)this.intendedValues)) {
                weightToPrioMap.put(50.0, PriorityCode.BAD.getValue());
            }
        }
        String cycleway = way.getFirstPriorityTag(Arrays.asList("cycleway", "cycleway:left", "cycleway:right"));
        if (Arrays.asList("lane", "shared_lane", "share_busway", "shoulder").contains(cycleway)) {
            weightToPrioMap.put(100.0, PriorityCode.UNCHANGED.getValue());
        } else if ("track".equals(cycleway)) {
            weightToPrioMap.put(100.0, PriorityCode.PREFER.getValue());
        }
        if (way.hasTag("bicycle", (Object)"use_sidepath")) {
            weightToPrioMap.put(100.0, PriorityCode.REACH_DESTINATION.getValue());
        }
        if (this.pushingSectionsHighways.contains(highway) || "parking_aisle".equals(service)) {
            int pushingSectionPrio = PriorityCode.SLIGHT_AVOID.getValue();
            if (way.hasTag("bicycle", (Object)"yes") || way.hasTag("bicycle", (Object)"permissive")) {
                pushingSectionPrio = PriorityCode.PREFER.getValue();
            }
            if (way.hasTag("bicycle", (Object)"designated") || way.hasTag("bicycle", (Object)"official")) {
                pushingSectionPrio = PriorityCode.VERY_NICE.getValue();
            }
            if (way.hasTag("foot", (Object)"yes")) {
                pushingSectionPrio = Math.max(pushingSectionPrio - 1, PriorityCode.BAD.getValue());
                if (way.hasTag("segregated", (Object)"yes")) {
                    pushingSectionPrio = Math.min(pushingSectionPrio + 1, PriorityCode.BEST.getValue());
                }
            }
            weightToPrioMap.put(100.0, pushingSectionPrio);
        }
        if (way.hasTag("railway", (Object)"tram")) {
            weightToPrioMap.put(50.0, PriorityCode.AVOID_MORE.getValue());
        }
        if ((classBicycleValue = way.getTag(this.classBicycleKey)) != null) {
            weightToPrioMap.put(100.0, this.convertClassValueToPriority(classBicycleValue).getValue());
        } else {
            String classBicycle = way.getTag("class:bicycle");
            if (classBicycle != null) {
                weightToPrioMap.put(100.0, this.convertClassValueToPriority(classBicycle).getValue());
            }
        }
        if ((way.hasTag("scenic", (Object)"yes") || maxSpeed > 0.0 && maxSpeed < wayTypeSpeed) && weightToPrioMap.lastEntry().getValue() < PriorityCode.BEST.getValue()) {
            weightToPrioMap.put(110.0, weightToPrioMap.lastEntry().getValue() + 1);
        }
    }

    protected void handleAccess(IntsRef edgeFlags, ReaderWay way) {
        boolean isOneway;
        boolean bl = isOneway = way.hasTag("oneway", (Collection<String>)this.oneways) && !way.hasTag("oneway", (Object)"-1") && !way.hasTag("bicycle:backward", (Collection<String>)this.intendedValues) || way.hasTag("oneway", (Object)"-1") && !way.hasTag("bicycle:forward", (Collection<String>)this.intendedValues) || way.hasTag("oneway:bicycle", (Collection<String>)this.oneways) || way.hasTag("vehicle:backward", (Collection<String>)this.restrictedValues) && !way.hasTag("bicycle:forward", (Collection<String>)this.intendedValues) || way.hasTag("vehicle:forward", (Collection<String>)this.restrictedValues) && !way.hasTag("bicycle:backward", (Collection<String>)this.intendedValues) || way.hasTag("bicycle:forward", (Collection<String>)this.restrictedValues) || way.hasTag("bicycle:backward", (Collection<String>)this.restrictedValues);
        if (!(!isOneway && !this.roundaboutEnc.getBool(false, edgeFlags) || way.hasTag("oneway:bicycle", (Object)"no") || way.hasTag("cycleway", this.oppositeLanes) || way.hasTag("cycleway:left", this.oppositeLanes) || way.hasTag("cycleway:right", this.oppositeLanes) || way.hasTag("cycleway:left:oneway", (Object)"-1") || way.hasTag("cycleway:right:oneway", (Object)"-1"))) {
            boolean isBackward = way.hasTag("oneway", (Object)"-1") || way.hasTag("oneway:bicycle", (Object)"-1") || way.hasTag("vehicle:forward", (Collection<String>)this.restrictedValues) || way.hasTag("bicycle:forward", (Collection<String>)this.restrictedValues);
            this.accessEnc.setBool(isBackward, edgeFlags, true);
        } else {
            this.accessEnc.setBool(false, edgeFlags, true);
            this.accessEnc.setBool(true, edgeFlags, true);
        }
    }

    void setHighwaySpeed(String highway, int speed) {
        this.highwaySpeeds.put(highway, speed);
    }

    int getHighwaySpeed(String key) {
        return this.highwaySpeeds.get(key);
    }

    void setTrackTypeSpeed(String tracktype, int speed) {
        this.trackTypeSpeeds.put(tracktype, speed);
    }

    void setSurfaceSpeed(String surface, int speed) {
        this.surfaceSpeeds.put(surface, speed);
    }

    void setSmoothnessSpeedFactor(Smoothness smoothness, double speedfactor) {
        this.smoothnessFactor.put(smoothness, speedfactor);
    }

    void addPushingSection(String highway) {
        this.pushingSectionsHighways.add(highway);
    }

    void setAvoidSpeedLimit(int limit) {
        this.avoidSpeedLimit = limit;
    }

    void setSpecificClassBicycle(String subkey) {
        this.classBicycleKey = "class:bicycle:" + subkey;
    }
}

