/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.TurnCost;
import com.graphhopper.routing.ev.VehicleAccess;
import com.graphhopper.routing.ev.VehicleSpeed;
import com.graphhopper.routing.util.TransportationMode;
import com.graphhopper.routing.util.VehicleTagParser;
import com.graphhopper.routing.util.WayAccess;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CarTagParser
extends VehicleTagParser {
    public static final double CAR_MAX_SPEED = 140.0;
    protected final Map<String, Integer> trackTypeSpeedMap = new HashMap<String, Integer>();
    protected final Set<String> badSurfaceSpeedMap = new HashSet<String>();
    protected int badSurfaceSpeed;
    protected final Map<String, Integer> defaultSpeedMap = new HashMap<String, Integer>();

    public CarTagParser(EncodedValueLookup lookup, PMap properties) {
        this(lookup.getBooleanEncodedValue(VehicleAccess.key(properties.getString("name", "car"))), lookup.getDecimalEncodedValue(VehicleSpeed.key(properties.getString("name", "car"))), lookup.hasEncodedValue(TurnCost.key(properties.getString("name", "car"))) ? lookup.getDecimalEncodedValue(TurnCost.key(properties.getString("name", "car"))) : null, lookup.getBooleanEncodedValue("roundabout"), properties, TransportationMode.CAR, lookup.getDecimalEncodedValue(VehicleSpeed.key(properties.getString("name", "car"))).getNextStorableValue(140.0));
    }

    public CarTagParser(BooleanEncodedValue accessEnc, DecimalEncodedValue speedEnc, DecimalEncodedValue turnCostEnc, BooleanEncodedValue roundaboutEnc, PMap properties, TransportationMode transportationMode, double maxPossibleSpeed) {
        super(accessEnc, speedEnc, properties.getString("name", "car"), roundaboutEnc, turnCostEnc, transportationMode, maxPossibleSpeed);
        this.restrictedValues.add("agricultural");
        this.restrictedValues.add("forestry");
        this.restrictedValues.add("no");
        this.restrictedValues.add("restricted");
        this.restrictedValues.add("delivery");
        this.restrictedValues.add("military");
        this.restrictedValues.add("emergency");
        this.restrictedValues.add("private");
        this.blockPrivate(properties.getBool("block_private", true));
        this.blockFords(properties.getBool("block_fords", false));
        this.intendedValues.add("yes");
        this.intendedValues.add("designated");
        this.intendedValues.add("permissive");
        this.barriers.add("kissing_gate");
        this.barriers.add("fence");
        this.barriers.add("bollard");
        this.barriers.add("stile");
        this.barriers.add("turnstile");
        this.barriers.add("cycle_barrier");
        this.barriers.add("motorcycle_barrier");
        this.barriers.add("block");
        this.barriers.add("bus_trap");
        this.barriers.add("sump_buster");
        this.barriers.add("jersey_barrier");
        this.badSurfaceSpeedMap.add("cobblestone");
        this.badSurfaceSpeedMap.add("grass_paver");
        this.badSurfaceSpeedMap.add("gravel");
        this.badSurfaceSpeedMap.add("sand");
        this.badSurfaceSpeedMap.add("paving_stones");
        this.badSurfaceSpeedMap.add("dirt");
        this.badSurfaceSpeedMap.add("ground");
        this.badSurfaceSpeedMap.add("grass");
        this.badSurfaceSpeedMap.add("unpaved");
        this.badSurfaceSpeedMap.add("compacted");
        this.defaultSpeedMap.put("motorway", 100);
        this.defaultSpeedMap.put("motorway_link", 70);
        this.defaultSpeedMap.put("motorroad", 90);
        this.defaultSpeedMap.put("trunk", 70);
        this.defaultSpeedMap.put("trunk_link", 65);
        this.defaultSpeedMap.put("primary", 65);
        this.defaultSpeedMap.put("primary_link", 60);
        this.defaultSpeedMap.put("secondary", 60);
        this.defaultSpeedMap.put("secondary_link", 50);
        this.defaultSpeedMap.put("tertiary", 50);
        this.defaultSpeedMap.put("tertiary_link", 40);
        this.defaultSpeedMap.put("unclassified", 30);
        this.defaultSpeedMap.put("residential", 30);
        this.defaultSpeedMap.put("living_street", 5);
        this.defaultSpeedMap.put("service", 20);
        this.defaultSpeedMap.put("road", 20);
        this.defaultSpeedMap.put("track", 15);
        this.trackTypeSpeedMap.put("grade1", 20);
        this.trackTypeSpeedMap.put("grade2", 15);
        this.trackTypeSpeedMap.put("grade3", 10);
        this.trackTypeSpeedMap.put(null, this.defaultSpeedMap.get("track"));
        this.badSurfaceSpeed = 30;
    }

    protected double getSpeed(ReaderWay way) {
        Integer tInt;
        String tt;
        Integer speed;
        String highwayValue = way.getTag("highway");
        if (!Helper.isEmpty((String)highwayValue) && way.hasTag("motorroad", (Object)"yes") && !"motorway".equals(highwayValue) && !"motorway_link".equals(highwayValue)) {
            highwayValue = "motorroad";
        }
        if ((speed = this.defaultSpeedMap.get(highwayValue)) == null) {
            throw new IllegalStateException(this.getName() + ", no speed found for: " + highwayValue + ", tags: " + way);
        }
        if (highwayValue.equals("track") && !Helper.isEmpty((String)(tt = way.getTag("tracktype"))) && (tInt = this.trackTypeSpeedMap.get(tt)) != null) {
            speed = tInt;
        }
        return speed.intValue();
    }

    @Override
    public WayAccess getAccess(ReaderWay way) {
        String highwayValue = way.getTag("highway");
        String firstValue = way.getFirstPriorityTag(this.restrictions);
        if (highwayValue == null) {
            if (way.hasTag("route", (Collection<String>)this.ferries)) {
                if (this.restrictedValues.contains(firstValue)) {
                    return WayAccess.CAN_SKIP;
                }
                if (this.intendedValues.contains(firstValue) || firstValue.isEmpty() && !way.hasTag("foot", new String[0]) && !way.hasTag("bicycle", new String[0])) {
                    return WayAccess.FERRY;
                }
            }
            return WayAccess.CAN_SKIP;
        }
        if ("service".equals(highwayValue) && "emergency_access".equals(way.getTag("service"))) {
            return WayAccess.CAN_SKIP;
        }
        if ("track".equals(highwayValue) && this.trackTypeSpeedMap.get(way.getTag("tracktype")) == null) {
            return WayAccess.CAN_SKIP;
        }
        if (!this.defaultSpeedMap.containsKey(highwayValue)) {
            return WayAccess.CAN_SKIP;
        }
        if (way.hasTag("impassable", (Object)"yes") || way.hasTag("status", (Object)"impassable")) {
            return WayAccess.CAN_SKIP;
        }
        if (!firstValue.isEmpty()) {
            String[] restrict = firstValue.split(";");
            boolean notConditionalyPermitted = !this.getConditionalTagInspector().isRestrictedWayConditionallyPermitted(way);
            for (String value : restrict) {
                if (this.restrictedValues.contains(value) && notConditionalyPermitted) {
                    return WayAccess.CAN_SKIP;
                }
                if (!this.intendedValues.contains(value)) continue;
                return WayAccess.WAY;
            }
        }
        if (this.isBlockFords() && ("ford".equals(highwayValue) || way.hasTag("ford", new String[0]))) {
            return WayAccess.CAN_SKIP;
        }
        if (this.getConditionalTagInspector().isPermittedWayConditionallyRestricted(way)) {
            return WayAccess.CAN_SKIP;
        }
        return WayAccess.WAY;
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay way) {
        WayAccess access = this.getAccess(way);
        if (access.canSkip()) {
            return edgeFlags;
        }
        if (!access.isFerry()) {
            double speed = this.getSpeed(way);
            speed = this.applyMaxSpeed(way, speed);
            speed = this.applyBadSurfaceSpeed(way, speed);
            this.setSpeed(false, edgeFlags, speed);
            if (this.avgSpeedEnc.isStoreTwoDirections()) {
                this.setSpeed(true, edgeFlags, speed);
            }
            boolean isRoundabout = this.roundaboutEnc.getBool(false, edgeFlags);
            if (this.isOneway(way) || isRoundabout) {
                if (this.isForwardOneway(way)) {
                    this.accessEnc.setBool(false, edgeFlags, true);
                }
                if (this.isBackwardOneway(way)) {
                    this.accessEnc.setBool(true, edgeFlags, true);
                }
            } else {
                this.accessEnc.setBool(false, edgeFlags, true);
                this.accessEnc.setBool(true, edgeFlags, true);
            }
        } else {
            double ferrySpeed = this.ferrySpeedCalc.getSpeed(way);
            this.accessEnc.setBool(false, edgeFlags, true);
            this.accessEnc.setBool(true, edgeFlags, true);
            this.setSpeed(false, edgeFlags, ferrySpeed);
            if (this.avgSpeedEnc.isStoreTwoDirections()) {
                this.setSpeed(true, edgeFlags, ferrySpeed);
            }
        }
        return edgeFlags;
    }

    protected double applyMaxSpeed(ReaderWay way, double speed) {
        double maxSpeed = CarTagParser.getMaxSpeed(way);
        if (CarTagParser.isValidSpeed(maxSpeed)) {
            return maxSpeed * 0.9;
        }
        return speed;
    }

    protected boolean isBackwardOneway(ReaderWay way) {
        return way.hasTag("oneway", (Object)"-1") || way.hasTag("vehicle:forward", (Collection<String>)this.restrictedValues) || way.hasTag("motor_vehicle:forward", (Collection<String>)this.restrictedValues);
    }

    protected boolean isForwardOneway(ReaderWay way) {
        return !way.hasTag("oneway", (Object)"-1") && !way.hasTag("vehicle:forward", (Collection<String>)this.restrictedValues) && !way.hasTag("motor_vehicle:forward", (Collection<String>)this.restrictedValues);
    }

    protected boolean isOneway(ReaderWay way) {
        return way.hasTag("oneway", (Collection<String>)this.oneways) || way.hasTag("vehicle:backward", (Collection<String>)this.restrictedValues) || way.hasTag("vehicle:forward", (Collection<String>)this.restrictedValues) || way.hasTag("motor_vehicle:backward", (Collection<String>)this.restrictedValues) || way.hasTag("motor_vehicle:forward", (Collection<String>)this.restrictedValues);
    }

    protected double applyBadSurfaceSpeed(ReaderWay way, double speed) {
        if (this.badSurfaceSpeed > 0 && CarTagParser.isValidSpeed(speed) && speed > (double)this.badSurfaceSpeed && way.hasTag("surface", this.badSurfaceSpeedMap)) {
            speed = this.badSurfaceSpeed;
        }
        return speed;
    }
}

