/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.TurnCost;
import com.graphhopper.routing.ev.VehicleAccess;
import com.graphhopper.routing.ev.VehiclePriority;
import com.graphhopper.routing.ev.VehicleSpeed;
import com.graphhopper.routing.util.CarTagParser;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.PriorityCode;
import com.graphhopper.routing.util.TransportationMode;
import com.graphhopper.routing.util.WayAccess;
import com.graphhopper.routing.util.parsers.helpers.OSMValueExtractor;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.DistanceCalcEarth;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.PMap;
import com.graphhopper.util.PointList;
import java.util.Collection;
import java.util.HashSet;

public class MotorcycleTagParser
extends CarTagParser {
    public static final double MOTOR_CYCLE_MAX_SPEED = 120.0;
    private final HashSet<String> avoidSet = new HashSet();
    private final HashSet<String> preferSet = new HashSet();
    private final DecimalEncodedValue priorityWayEncoder;
    private final DecimalEncodedValue curvatureEncoder;

    public MotorcycleTagParser(EncodedValueLookup lookup, PMap properties) {
        this(lookup.getBooleanEncodedValue(VehicleAccess.key("motorcycle")), lookup.getDecimalEncodedValue(VehicleSpeed.key("motorcycle")), lookup.hasEncodedValue(TurnCost.key("motorcycle")) ? lookup.getDecimalEncodedValue(TurnCost.key("motorcycle")) : null, lookup.getBooleanEncodedValue("roundabout"), lookup.getDecimalEncodedValue(VehiclePriority.key("motorcycle")), lookup.getDecimalEncodedValue(EncodingManager.getKey("motorcycle", "curvature")), new PMap(properties).putObject("name", (Object)"motorcycle"), TransportationMode.MOTORCYCLE);
    }

    public MotorcycleTagParser(BooleanEncodedValue accessEnc, DecimalEncodedValue speedEnc, DecimalEncodedValue turnCostEnc, BooleanEncodedValue roundaboutEnc, DecimalEncodedValue priorityWayEncoder, DecimalEncodedValue curvatureEnc, PMap properties, TransportationMode transportationMode) {
        super(accessEnc, speedEnc, turnCostEnc, roundaboutEnc, new PMap(properties).putObject("name", (Object)"motorcycle"), transportationMode, speedEnc.getNextStorableValue(120.0));
        this.priorityWayEncoder = priorityWayEncoder;
        this.curvatureEncoder = curvatureEnc;
        this.barriers.remove("bus_trap");
        this.barriers.remove("sump_buster");
        this.trackTypeSpeedMap.clear();
        this.defaultSpeedMap.clear();
        this.trackTypeSpeedMap.put("grade1", 20);
        this.trackTypeSpeedMap.put("grade2", 15);
        this.trackTypeSpeedMap.put("grade3", 10);
        this.trackTypeSpeedMap.put("grade4", 5);
        this.trackTypeSpeedMap.put("grade5", 5);
        this.avoidSet.add("motorway");
        this.avoidSet.add("trunk");
        this.avoidSet.add("motorroad");
        this.avoidSet.add("residential");
        this.preferSet.add("primary");
        this.preferSet.add("secondary");
        this.preferSet.add("tertiary");
        this.defaultSpeedMap.put("motorway", 100);
        this.defaultSpeedMap.put("motorway_link", 70);
        this.defaultSpeedMap.put("motorroad", 90);
        this.defaultSpeedMap.put("trunk", 80);
        this.defaultSpeedMap.put("trunk_link", 75);
        this.defaultSpeedMap.put("primary", 65);
        this.defaultSpeedMap.put("primary_link", 60);
        this.defaultSpeedMap.put("secondary", 60);
        this.defaultSpeedMap.put("secondary_link", 50);
        this.defaultSpeedMap.put("tertiary", 50);
        this.defaultSpeedMap.put("tertiary_link", 40);
        this.defaultSpeedMap.put("unclassified", 30);
        this.defaultSpeedMap.put("residential", 30);
        this.defaultSpeedMap.put("living_street", 5);
        this.defaultSpeedMap.put("service", 20);
        this.defaultSpeedMap.put("road", 20);
        this.defaultSpeedMap.put("track", 15);
    }

    @Override
    public WayAccess getAccess(ReaderWay way) {
        String tt;
        String highwayValue = way.getTag("highway");
        String firstValue = way.getFirstPriorityTag(this.restrictions);
        if (highwayValue == null) {
            if (way.hasTag("route", (Collection<String>)this.ferries)) {
                if (this.restrictedValues.contains(firstValue)) {
                    return WayAccess.CAN_SKIP;
                }
                if (this.intendedValues.contains(firstValue) || firstValue.isEmpty() && !way.hasTag("foot", new String[0]) && !way.hasTag("bicycle", new String[0])) {
                    return WayAccess.FERRY;
                }
            }
            return WayAccess.CAN_SKIP;
        }
        if ("service".equals(highwayValue) && "emergency_access".equals(way.getTag("service"))) {
            return WayAccess.CAN_SKIP;
        }
        if ("track".equals(highwayValue) && (tt = way.getTag("tracktype")) != null && !tt.equals("grade1")) {
            return WayAccess.CAN_SKIP;
        }
        if (!this.defaultSpeedMap.containsKey(highwayValue)) {
            return WayAccess.CAN_SKIP;
        }
        if (way.hasTag("impassable", (Object)"yes") || way.hasTag("status", (Object)"impassable")) {
            return WayAccess.CAN_SKIP;
        }
        if (!firstValue.isEmpty()) {
            String[] restrict = firstValue.split(";");
            boolean notConditionalyPermitted = !this.getConditionalTagInspector().isRestrictedWayConditionallyPermitted(way);
            for (String value : restrict) {
                if (this.restrictedValues.contains(value) && notConditionalyPermitted) {
                    return WayAccess.CAN_SKIP;
                }
                if (!this.intendedValues.contains(value)) continue;
                return WayAccess.WAY;
            }
        }
        if (this.isBlockFords() && ("ford".equals(highwayValue) || way.hasTag("ford", new String[0]))) {
            return WayAccess.CAN_SKIP;
        }
        if (this.getConditionalTagInspector().isPermittedWayConditionallyRestricted(way)) {
            return WayAccess.CAN_SKIP;
        }
        return WayAccess.WAY;
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay way) {
        WayAccess access = this.getAccess(way);
        if (access.canSkip()) {
            return edgeFlags;
        }
        if (!access.isFerry()) {
            double speed = this.getSpeed(way);
            speed = this.applyMaxSpeed(way, speed);
            double maxMCSpeed = OSMValueExtractor.stringToKmh(way.getTag("maxspeed:motorcycle"));
            if (MotorcycleTagParser.isValidSpeed(maxMCSpeed) && maxMCSpeed < speed) {
                speed = maxMCSpeed * 0.9;
            }
            if (MotorcycleTagParser.isValidSpeed(speed) && speed > 30.0 && way.hasTag("surface", (Collection<String>)this.badSurfaceSpeedMap)) {
                speed = 30.0;
            }
            boolean isRoundabout = this.roundaboutEnc.getBool(false, edgeFlags);
            if (way.hasTag("oneway", (Collection<String>)this.oneways) || isRoundabout) {
                if (way.hasTag("oneway", (Object)"-1")) {
                    this.accessEnc.setBool(true, edgeFlags, true);
                    this.setSpeed(true, edgeFlags, speed);
                } else {
                    this.accessEnc.setBool(false, edgeFlags, true);
                    this.setSpeed(false, edgeFlags, speed);
                }
            } else {
                this.accessEnc.setBool(false, edgeFlags, true);
                this.accessEnc.setBool(true, edgeFlags, true);
                this.setSpeed(false, edgeFlags, speed);
                this.setSpeed(true, edgeFlags, speed);
            }
        } else {
            this.accessEnc.setBool(false, edgeFlags, true);
            this.accessEnc.setBool(true, edgeFlags, true);
            double ferrySpeed = this.ferrySpeedCalc.getSpeed(way);
            this.setSpeed(false, edgeFlags, ferrySpeed);
            this.setSpeed(true, edgeFlags, ferrySpeed);
        }
        this.priorityWayEncoder.setDecimal(false, edgeFlags, PriorityCode.getValue(this.handlePriority(way)));
        this.curvatureEncoder.setDecimal(false, edgeFlags, 1.4285714285714286);
        return edgeFlags;
    }

    private int handlePriority(ReaderWay way) {
        String highway = way.getTag("highway", "");
        if (this.avoidSet.contains(highway)) {
            return PriorityCode.BAD.getValue();
        }
        if (this.preferSet.contains(highway)) {
            return PriorityCode.BEST.getValue();
        }
        return PriorityCode.UNCHANGED.getValue();
    }

    @Override
    public void applyWayTags(ReaderWay way, EdgeIteratorState edge) {
        double speed = edge.get(this.avgSpeedEnc);
        double roadDistance = edge.getDistance();
        double beelineDistance = this.getBeelineDistance(way);
        double bendiness = beelineDistance / roadDistance;
        bendiness = this.discriminateSlowStreets(bendiness, speed);
        bendiness = this.increaseBendinessImpact(bendiness);
        bendiness = this.correctErrors(bendiness);
        edge.set(this.curvatureEncoder, bendiness);
    }

    private double getBeelineDistance(ReaderWay way) {
        PointList pointList = way.getTag("point_list", null);
        if (pointList == null) {
            throw new IllegalStateException("The artificial 'point_list' tag is missing for way: " + way.getId());
        }
        if (pointList.size() < 2) {
            throw new IllegalStateException("The artificial 'point_list' tag contained less than two points for way: " + way.getId());
        }
        return DistanceCalcEarth.DIST_EARTH.calcDist(pointList.getLat(0), pointList.getLon(0), pointList.getLat(pointList.size() - 1), pointList.getLon(pointList.size() - 1));
    }

    protected double discriminateSlowStreets(double bendiness, double speed) {
        if (speed < 51.0) {
            return 1.0;
        }
        return bendiness;
    }

    protected double correctErrors(double bendiness) {
        if (bendiness < 0.01 || bendiness > 1.0) {
            return 1.0;
        }
        return bendiness;
    }

    protected double increaseBendinessImpact(double bendiness) {
        return Math.pow(bendiness, 2.0);
    }
}

