/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.BikeNetwork;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.RouteNetwork;
import com.graphhopper.routing.ev.Smoothness;
import com.graphhopper.routing.ev.TurnCost;
import com.graphhopper.routing.ev.VehicleAccess;
import com.graphhopper.routing.ev.VehiclePriority;
import com.graphhopper.routing.ev.VehicleSpeed;
import com.graphhopper.routing.util.BikeCommonTagParser;
import com.graphhopper.routing.util.PriorityCode;
import com.graphhopper.util.PMap;
import java.util.TreeMap;

public class RacingBikeTagParser
extends BikeCommonTagParser {
    public RacingBikeTagParser(EncodedValueLookup lookup, PMap properties) {
        this(lookup.getBooleanEncodedValue(VehicleAccess.key("racingbike")), lookup.getDecimalEncodedValue(VehicleSpeed.key("racingbike")), lookup.getDecimalEncodedValue(VehiclePriority.key("racingbike")), lookup.getEnumEncodedValue(BikeNetwork.KEY, RouteNetwork.class), lookup.getEnumEncodedValue("smoothness", Smoothness.class), lookup.getBooleanEncodedValue("roundabout"), lookup.hasEncodedValue(TurnCost.key("racingbike")) ? lookup.getDecimalEncodedValue(TurnCost.key("racingbike")) : null);
        this.blockPrivate(properties.getBool("block_private", true));
        this.blockFords(properties.getBool("block_fords", false));
    }

    protected RacingBikeTagParser(BooleanEncodedValue accessEnc, DecimalEncodedValue speedEnc, DecimalEncodedValue priorityEnc, EnumEncodedValue<RouteNetwork> bikeRouteEnc, EnumEncodedValue<Smoothness> smoothnessEnc, BooleanEncodedValue roundaboutEnc, DecimalEncodedValue turnCostEnc) {
        super(accessEnc, speedEnc, priorityEnc, bikeRouteEnc, smoothnessEnc, "racingbike", roundaboutEnc, turnCostEnc);
        this.preferHighwayTags.add("road");
        this.preferHighwayTags.add("secondary");
        this.preferHighwayTags.add("secondary_link");
        this.preferHighwayTags.add("tertiary");
        this.preferHighwayTags.add("tertiary_link");
        this.preferHighwayTags.add("residential");
        this.setTrackTypeSpeed("grade1", 20);
        this.setTrackTypeSpeed("grade2", 10);
        this.setTrackTypeSpeed("grade3", 4);
        this.setTrackTypeSpeed("grade4", 4);
        this.setTrackTypeSpeed("grade5", 4);
        this.setSurfaceSpeed("paved", 20);
        this.setSurfaceSpeed("asphalt", 20);
        this.setSurfaceSpeed("concrete", 20);
        this.setSurfaceSpeed("concrete:lanes", 16);
        this.setSurfaceSpeed("concrete:plates", 16);
        this.setSurfaceSpeed("unpaved", 2);
        this.setSurfaceSpeed("compacted", 2);
        this.setSurfaceSpeed("dirt", 2);
        this.setSurfaceSpeed("earth", 2);
        this.setSurfaceSpeed("fine_gravel", 4);
        this.setSurfaceSpeed("grass", 2);
        this.setSurfaceSpeed("grass_paver", 2);
        this.setSurfaceSpeed("gravel", 2);
        this.setSurfaceSpeed("ground", 2);
        this.setSurfaceSpeed("ice", 2);
        this.setSurfaceSpeed("metal", 2);
        this.setSurfaceSpeed("mud", 2);
        this.setSurfaceSpeed("pebblestone", 4);
        this.setSurfaceSpeed("salt", 2);
        this.setSurfaceSpeed("sand", 2);
        this.setSurfaceSpeed("wood", 2);
        this.setHighwaySpeed("path", 8);
        this.setHighwaySpeed("footway", 4);
        this.setHighwaySpeed("pedestrian", 4);
        this.setHighwaySpeed("track", 2);
        this.setHighwaySpeed("service", 12);
        this.setHighwaySpeed("unclassified", 16);
        this.setHighwaySpeed("residential", 16);
        this.setHighwaySpeed("trunk", 20);
        this.setHighwaySpeed("trunk_link", 20);
        this.setHighwaySpeed("primary", 20);
        this.setHighwaySpeed("primary_link", 20);
        this.setHighwaySpeed("secondary", 20);
        this.setHighwaySpeed("secondary_link", 20);
        this.setHighwaySpeed("tertiary", 20);
        this.setHighwaySpeed("tertiary_link", 20);
        this.addPushingSection("path");
        this.addPushingSection("footway");
        this.addPushingSection("platform");
        this.addPushingSection("pedestrian");
        this.addPushingSection("steps");
        this.setSmoothnessSpeedFactor(Smoothness.EXCELLENT, 1.2);
        this.setSmoothnessSpeedFactor(Smoothness.VERY_BAD, 0.1);
        this.setSmoothnessSpeedFactor(Smoothness.HORRIBLE, 0.1);
        this.setSmoothnessSpeedFactor(Smoothness.VERY_HORRIBLE, 0.1);
        this.routeMap.put(RouteNetwork.INTERNATIONAL, PriorityCode.BEST.getValue());
        this.routeMap.put(RouteNetwork.NATIONAL, PriorityCode.BEST.getValue());
        this.routeMap.put(RouteNetwork.REGIONAL, PriorityCode.VERY_NICE.getValue());
        this.routeMap.put(RouteNetwork.LOCAL, PriorityCode.UNCHANGED.getValue());
        this.barriers.add("kissing_gate");
        this.barriers.add("stile");
        this.barriers.add("turnstile");
        this.setAvoidSpeedLimit(81);
        this.setSpecificClassBicycle("roadcycling");
    }

    @Override
    void collect(ReaderWay way, double wayTypeSpeed, TreeMap<Double, Integer> weightToPrioMap) {
        super.collect(way, wayTypeSpeed, weightToPrioMap);
        String highway = way.getTag("highway");
        if ("service".equals(highway)) {
            weightToPrioMap.put(40.0, PriorityCode.UNCHANGED.getValue());
        } else if ("track".equals(highway)) {
            String trackType = way.getTag("tracktype");
            if ("grade1".equals(trackType)) {
                weightToPrioMap.put(110.0, PriorityCode.PREFER.getValue());
            } else if (trackType == null || trackType.startsWith("grade")) {
                weightToPrioMap.put(110.0, PriorityCode.AVOID_MORE.getValue());
            }
        }
    }
}

