/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.TurnCost;
import com.graphhopper.routing.ev.VehicleAccess;
import com.graphhopper.routing.ev.VehiclePriority;
import com.graphhopper.routing.ev.VehicleSpeed;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.PriorityCode;
import com.graphhopper.util.PMap;
import java.util.Arrays;
import java.util.List;

public class VehicleEncodedValues {
    public static final List<String> OUTDOOR_VEHICLES = Arrays.asList("bike", "bike2", "racingbike", "mtb", "foot", "hike", "wheelchair");
    private final String name;
    private final BooleanEncodedValue accessEnc;
    private final DecimalEncodedValue avgSpeedEnc;
    private final DecimalEncodedValue priorityEnc;
    private final DecimalEncodedValue curvatureEnc;
    private final DecimalEncodedValue turnCostEnc;

    public static VehicleEncodedValues foot(PMap properties) {
        String name = properties.getString("name", "foot");
        int speedBits = properties.getInt("speed_bits", 4);
        double speedFactor = properties.getDouble("speed_factor", 1.0);
        boolean speedTwoDirections = properties.getBool("speed_two_directions", false);
        int maxTurnCosts = properties.getInt("max_turn_costs", properties.getBool("turn_costs", false) ? 1 : 0);
        BooleanEncodedValue accessEnc = VehicleAccess.create(name);
        DecimalEncodedValue speedEnc = VehicleSpeed.create(name, speedBits, speedFactor, speedTwoDirections);
        DecimalEncodedValue priorityEnc = VehiclePriority.create(name, 4, PriorityCode.getFactor(1), false);
        DecimalEncodedValue turnCostEnc = maxTurnCosts > 0 ? TurnCost.create(name, maxTurnCosts) : null;
        return new VehicleEncodedValues(name, accessEnc, speedEnc, priorityEnc, null, turnCostEnc);
    }

    public static VehicleEncodedValues hike(PMap properties) {
        return VehicleEncodedValues.foot(new PMap(properties).putObject("name", (Object)properties.getString("name", "hike")));
    }

    public static VehicleEncodedValues wheelchair(PMap properties) {
        if (properties.has("speed_two_directions")) {
            throw new IllegalArgumentException("wheelchair always uses two directions");
        }
        return VehicleEncodedValues.foot(new PMap(properties).putObject("name", (Object)properties.getString("name", "wheelchair")).putObject("speed_two_directions", (Object)true));
    }

    public static VehicleEncodedValues bike(PMap properties) {
        String name = properties.getString("name", "bike");
        int speedBits = properties.getInt("speed_bits", 4);
        double speedFactor = properties.getDouble("speed_factor", 2.0);
        boolean speedTwoDirections = properties.getBool("speed_two_directions", false);
        int maxTurnCosts = properties.getInt("max_turn_costs", properties.getBool("turn_costs", false) ? 1 : 0);
        BooleanEncodedValue accessEnc = VehicleAccess.create(name);
        DecimalEncodedValue speedEnc = VehicleSpeed.create(name, speedBits, speedFactor, speedTwoDirections);
        DecimalEncodedValue priorityEnc = VehiclePriority.create(name, 4, PriorityCode.getFactor(1), false);
        DecimalEncodedValue turnCostEnc = maxTurnCosts > 0 ? TurnCost.create(name, maxTurnCosts) : null;
        return new VehicleEncodedValues(name, accessEnc, speedEnc, priorityEnc, null, turnCostEnc);
    }

    public static VehicleEncodedValues bike2(PMap properties) {
        if (properties.has("speed_two_directions")) {
            throw new IllegalArgumentException("bike2 always uses two directions");
        }
        return VehicleEncodedValues.bike(new PMap(properties).putObject("name", (Object)properties.getString("name", "bike2")).putObject("speed_two_directions", (Object)true));
    }

    public static VehicleEncodedValues racingbike(PMap properties) {
        return VehicleEncodedValues.bike(new PMap(properties).putObject("name", (Object)properties.getString("name", "racingbike")));
    }

    public static VehicleEncodedValues mountainbike(PMap properties) {
        return VehicleEncodedValues.bike(new PMap(properties).putObject("name", (Object)properties.getString("name", "mtb")));
    }

    public static VehicleEncodedValues car(PMap properties) {
        String name = properties.getString("name", "car");
        int speedBits = properties.getInt("speed_bits", 5);
        double speedFactor = properties.getDouble("speed_factor", 5.0);
        boolean speedTwoDirections = properties.getBool("speed_two_directions", false);
        int maxTurnCosts = properties.getInt("max_turn_costs", properties.getBool("turn_costs", false) ? 1 : 0);
        BooleanEncodedValue accessEnc = VehicleAccess.create(name);
        DecimalEncodedValue speedEnc = VehicleSpeed.create(name, speedBits, speedFactor, speedTwoDirections);
        DecimalEncodedValue turnCostEnc = maxTurnCosts > 0 ? TurnCost.create(name, maxTurnCosts) : null;
        return new VehicleEncodedValues(name, accessEnc, speedEnc, null, null, turnCostEnc);
    }

    public static VehicleEncodedValues motorcycle(PMap properties) {
        String name = properties.getString("name", "motorcycle");
        int speedBits = properties.getInt("speed_bits", 5);
        double speedFactor = properties.getDouble("speed_factor", 5.0);
        boolean speedTwoDirections = properties.getBool("speed_two_directions", true);
        int maxTurnCosts = properties.getInt("max_turn_costs", properties.getBool("turn_costs", false) ? 1 : 0);
        BooleanEncodedValue accessEnc = VehicleAccess.create(name);
        DecimalEncodedValue speedEnc = VehicleSpeed.create(name, speedBits, speedFactor, speedTwoDirections);
        DecimalEncodedValue priorityEnc = VehiclePriority.create(name, 4, PriorityCode.getFactor(1), false);
        DecimalEncodedValueImpl curvatureEnc = new DecimalEncodedValueImpl(EncodingManager.getKey(name, "curvature"), 4, 0.1, false);
        DecimalEncodedValue turnCostEnc = maxTurnCosts > 0 ? TurnCost.create(name, maxTurnCosts) : null;
        return new VehicleEncodedValues(name, accessEnc, speedEnc, priorityEnc, curvatureEnc, turnCostEnc);
    }

    public static VehicleEncodedValues roads() {
        String name = "roads";
        int speedBits = 7;
        double speedFactor = 2.0;
        boolean speedTwoDirections = true;
        int maxTurnCosts = 3;
        BooleanEncodedValue accessEnc = VehicleAccess.create(name);
        DecimalEncodedValue speedEnc = VehicleSpeed.create(name, speedBits, speedFactor, speedTwoDirections);
        DecimalEncodedValue turnCostEnc = maxTurnCosts > 0 ? TurnCost.create(name, maxTurnCosts) : null;
        return new VehicleEncodedValues(name, accessEnc, speedEnc, null, null, turnCostEnc);
    }

    public VehicleEncodedValues(String name, BooleanEncodedValue accessEnc, DecimalEncodedValue avgSpeedEnc, DecimalEncodedValue priorityEnc, DecimalEncodedValue curvatureEnc, DecimalEncodedValue turnCostEnc) {
        this.name = name;
        this.accessEnc = accessEnc;
        this.avgSpeedEnc = avgSpeedEnc;
        this.priorityEnc = priorityEnc;
        this.curvatureEnc = curvatureEnc;
        this.turnCostEnc = turnCostEnc;
    }

    public void createEncodedValues(List<EncodedValue> registerNewEncodedValue) {
        if (this.accessEnc != null) {
            registerNewEncodedValue.add(this.accessEnc);
        }
        if (this.avgSpeedEnc != null) {
            registerNewEncodedValue.add(this.avgSpeedEnc);
        }
        if (this.priorityEnc != null) {
            registerNewEncodedValue.add(this.priorityEnc);
        }
        if (this.curvatureEnc != null) {
            registerNewEncodedValue.add(this.curvatureEnc);
        }
    }

    public void createTurnCostEncodedValues(List<EncodedValue> registerNewTurnCostEncodedValues) {
        if (this.turnCostEnc != null) {
            registerNewTurnCostEncodedValues.add(this.turnCostEnc);
        }
    }

    public BooleanEncodedValue getAccessEnc() {
        return this.accessEnc;
    }

    public DecimalEncodedValue getAverageSpeedEnc() {
        return this.avgSpeedEnc;
    }

    public DecimalEncodedValue getPriorityEnc() {
        return this.priorityEnc;
    }

    public DecimalEncodedValue getCurvatureEnc() {
        return this.curvatureEnc;
    }

    public DecimalEncodedValue getTurnCostEnc() {
        return this.turnCostEnc;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }
}

