/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ConditionalTagInspector;
import com.graphhopper.reader.ReaderNode;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.reader.osm.conditional.ConditionalOSMTagInspector;
import com.graphhopper.reader.osm.conditional.DateRangeParser;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.util.FerrySpeedCalculator;
import com.graphhopper.routing.util.TransportationMode;
import com.graphhopper.routing.util.WayAccess;
import com.graphhopper.routing.util.parsers.OSMRoadAccessParser;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.routing.util.parsers.helpers.OSMValueExtractor;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.EdgeIteratorState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class VehicleTagParser
implements TagParser {
    private final String name;
    protected final Set<String> intendedValues = new HashSet<String>(5);
    protected final List<String> restrictions = new ArrayList<String>(5);
    protected final Set<String> restrictedValues = new HashSet<String>(5);
    protected final Set<String> ferries = new HashSet<String>(5);
    protected final Set<String> oneways = new HashSet<String>(5);
    protected final Set<String> barriers = new HashSet<String>(5);
    protected final BooleanEncodedValue accessEnc;
    protected final DecimalEncodedValue avgSpeedEnc;
    private final DecimalEncodedValue turnCostEnc;
    protected final BooleanEncodedValue roundaboutEnc;
    protected final double maxPossibleSpeed;
    private boolean blockFords = true;
    private ConditionalTagInspector conditionalTagInspector;
    protected final FerrySpeedCalculator ferrySpeedCalc;

    protected VehicleTagParser(BooleanEncodedValue accessEnc, DecimalEncodedValue speedEnc, String name, BooleanEncodedValue roundaboutEnc, DecimalEncodedValue turnCostEnc, TransportationMode transportationMode, double maxPossibleSpeed) {
        this.name = name;
        this.maxPossibleSpeed = maxPossibleSpeed;
        this.accessEnc = accessEnc;
        this.avgSpeedEnc = speedEnc;
        this.turnCostEnc = turnCostEnc;
        this.roundaboutEnc = roundaboutEnc;
        this.oneways.add("yes");
        this.oneways.add("true");
        this.oneways.add("1");
        this.oneways.add("-1");
        this.ferries.add("shuttle_train");
        this.ferries.add("ferry");
        this.ferrySpeedCalc = new FerrySpeedCalculator(speedEnc.getSmallestNonZeroValue(), maxPossibleSpeed, 5.0);
        this.restrictions.addAll(OSMRoadAccessParser.toOSMRestrictions(transportationMode));
    }

    public void init(DateRangeParser dateRangeParser) {
        this.setConditionalTagInspector(new ConditionalOSMTagInspector(Collections.singletonList(dateRangeParser), this.restrictions, this.restrictedValues, this.intendedValues, false));
    }

    protected void setConditionalTagInspector(ConditionalTagInspector inspector) {
        this.conditionalTagInspector = inspector;
    }

    public boolean isBlockFords() {
        return this.blockFords;
    }

    protected void blockFords(boolean blockFords) {
        this.blockFords = blockFords;
    }

    protected void blockPrivate(boolean blockPrivate) {
        if (!blockPrivate) {
            if (!this.restrictedValues.remove("private")) {
                throw new IllegalStateException("no 'private' found in restrictedValues");
            }
            this.intendedValues.add("private");
        }
    }

    public ConditionalTagInspector getConditionalTagInspector() {
        return this.conditionalTagInspector;
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay way, IntsRef relationFlags) {
        if (!(edgeFlags = this.handleWayTags(edgeFlags, way)).isEmpty()) {
            Map<String, Object> nodeTags = way.getTag("node_tags", Collections.emptyMap());
            this.handleNodeTags(edgeFlags, nodeTags);
        }
        return edgeFlags;
    }

    protected abstract IntsRef handleWayTags(IntsRef var1, ReaderWay var2);

    public IntsRef handleNodeTags(IntsRef edgeFlags, Map<String, Object> nodeTags) {
        ReaderNode readerNode;
        if (!nodeTags.isEmpty() && this.isBarrier(readerNode = new ReaderNode(0L, 0.0, 0.0, nodeTags))) {
            BooleanEncodedValue accessEnc = this.getAccessEnc();
            accessEnc.setBool(false, edgeFlags, false);
            accessEnc.setBool(true, edgeFlags, false);
        }
        return edgeFlags;
    }

    public abstract WayAccess getAccess(ReaderWay var1);

    public boolean isBarrier(ReaderNode node) {
        String firstValue = node.getFirstPriorityTag(this.restrictions);
        if (this.restrictedValues.contains(firstValue) || node.hasTag("locked", (Object)"yes")) {
            return true;
        }
        if (this.intendedValues.contains(firstValue)) {
            return false;
        }
        if (node.hasTag("barrier", this.barriers)) {
            return true;
        }
        return this.blockFords && node.hasTag("ford", (Object)"yes");
    }

    public double getMaxSpeed() {
        return this.maxPossibleSpeed;
    }

    protected static double getMaxSpeed(ReaderWay way) {
        double backSpeed;
        double maxSpeed = OSMValueExtractor.stringToKmh(way.getTag("maxspeed"));
        double fwdSpeed = OSMValueExtractor.stringToKmh(way.getTag("maxspeed:forward"));
        if (VehicleTagParser.isValidSpeed(fwdSpeed) && (!VehicleTagParser.isValidSpeed(maxSpeed) || fwdSpeed < maxSpeed)) {
            maxSpeed = fwdSpeed;
        }
        if (VehicleTagParser.isValidSpeed(backSpeed = OSMValueExtractor.stringToKmh(way.getTag("maxspeed:backward"))) && (!VehicleTagParser.isValidSpeed(maxSpeed) || backSpeed < maxSpeed)) {
            maxSpeed = backSpeed;
        }
        return maxSpeed;
    }

    protected static boolean isValidSpeed(double speed) {
        return !Double.isNaN(speed);
    }

    public void applyWayTags(ReaderWay way, EdgeIteratorState edge) {
    }

    public final DecimalEncodedValue getAverageSpeedEnc() {
        return this.avgSpeedEnc;
    }

    public final BooleanEncodedValue getAccessEnc() {
        return this.accessEnc;
    }

    protected void setSpeed(boolean reverse, IntsRef edgeFlags, double speed) {
        if (speed < this.avgSpeedEnc.getSmallestNonZeroValue()) {
            this.avgSpeedEnc.setDecimal(reverse, edgeFlags, 0.0);
            this.accessEnc.setBool(reverse, edgeFlags, false);
        } else {
            this.avgSpeedEnc.setDecimal(reverse, edgeFlags, Math.min(speed, this.getMaxSpeed()));
        }
    }

    public boolean supportsTurnCosts() {
        return this.turnCostEnc != null;
    }

    public DecimalEncodedValue getTurnCostEnc() {
        return this.turnCostEnc;
    }

    public final List<String> getRestrictions() {
        return this.restrictions;
    }

    public final String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }
}

