/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class OSMGetOffBikeParser
implements TagParser {
    private final HashSet<String> pushBikeHighwayTags = new HashSet();
    private final List<String> accepted = Arrays.asList("designated", "yes", "official", "permissive");
    private final BooleanEncodedValue offBikeEnc;

    public OSMGetOffBikeParser(BooleanEncodedValue getOffBikeEnc) {
        this(getOffBikeEnc, Arrays.asList("path", "footway", "pedestrian", "platform"));
    }

    public OSMGetOffBikeParser(BooleanEncodedValue getOffBikeEnc, List<String> pushBikeTags) {
        this.offBikeEnc = getOffBikeEnc;
        this.pushBikeHighwayTags.addAll(pushBikeTags);
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay way, IntsRef relationFlags) {
        String highway = way.getTag("highway");
        if (!way.hasTag("bicycle", this.accepted) && (this.pushBikeHighwayTags.contains(highway) || way.hasTag("railway", (Object)"platform")) || "steps".equals(highway) || way.hasTag("bicycle", (Object)"dismount")) {
            this.offBikeEnc.setBool(false, edgeFlags, true);
        }
        return edgeFlags;
    }
}

