/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;

public class OSMHorseRatingParser
implements TagParser {
    private final IntEncodedValue horseScale;

    public OSMHorseRatingParser(IntEncodedValue horseScale) {
        this.horseScale = horseScale;
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay readerWay, IntsRef relationFlags) {
        String scale = readerWay.getTag("horse_scale");
        int rating = 0;
        if (scale != null) {
            if (scale.equals("common")) {
                rating = 1;
            } else if (scale.equals("demanding")) {
                rating = 2;
            } else if (scale.equals("difficult")) {
                rating = 3;
            } else if (scale.equals("critical")) {
                rating = 4;
            } else if (scale.equals("dangerous")) {
                rating = 5;
            } else if (scale.equals("impossible")) {
                rating = 6;
            }
        }
        if (rating != 0) {
            this.horseScale.setInt(false, edgeFlags, rating);
        }
        return edgeFlags;
    }
}

