/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.OSMTurnRelation;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.util.AccessFilter;
import com.graphhopper.routing.util.parsers.TurnCostParser;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.TurnCostStorage;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import java.util.List;

public class OSMTurnRelationParser
implements TurnCostParser {
    private final BooleanEncodedValue accessEnc;
    private final DecimalEncodedValue turnCostEnc;
    private final List<String> restrictions;
    private EdgeExplorer cachedOutExplorer;
    private EdgeExplorer cachedInExplorer;

    public OSMTurnRelationParser(BooleanEncodedValue accessEnc, DecimalEncodedValue turnCostEnc, List<String> restrictions) {
        if (restrictions.isEmpty()) {
            throw new IllegalArgumentException("restrictions cannot be empty");
        }
        this.accessEnc = accessEnc;
        this.turnCostEnc = turnCostEnc;
        this.restrictions = restrictions;
    }

    @Override
    public void handleTurnRelationTags(OSMTurnRelation turnRelation, TurnCostParser.ExternalInternalMap map, Graph graph) {
        if (!turnRelation.isVehicleTypeConcernedByTurnRestriction(this.restrictions)) {
            return;
        }
        this.addRelationToTCStorage(turnRelation, map, graph);
    }

    private EdgeExplorer getInExplorer(Graph graph) {
        return this.cachedInExplorer == null ? (this.cachedInExplorer = graph.createEdgeExplorer(AccessFilter.inEdges(this.accessEnc))) : this.cachedInExplorer;
    }

    private EdgeExplorer getOutExplorer(Graph graph) {
        return this.cachedOutExplorer == null ? (this.cachedOutExplorer = graph.createEdgeExplorer(AccessFilter.outEdges(this.accessEnc))) : this.cachedOutExplorer;
    }

    void addRelationToTCStorage(OSMTurnRelation osmTurnRelation, TurnCostParser.ExternalInternalMap map, Graph graph) {
        TurnCostStorage tcs = graph.getTurnCostStorage();
        int viaNode = map.getInternalNodeIdOfOsmNode(osmTurnRelation.getViaOsmNodeId());
        EdgeExplorer edgeOutExplorer = this.getOutExplorer(graph);
        EdgeExplorer edgeInExplorer = this.getInExplorer(graph);
        try {
            int edgeIdFrom = -1;
            EdgeIterator iter = edgeInExplorer.setBaseNode(viaNode);
            while (iter.next()) {
                if (map.getOsmIdOfInternalEdge(iter.getEdge()) != osmTurnRelation.getOsmIdFrom()) continue;
                edgeIdFrom = iter.getEdge();
                break;
            }
            if (!EdgeIterator.Edge.isValid(edgeIdFrom)) {
                return;
            }
            iter = edgeOutExplorer.setBaseNode(viaNode);
            while (iter.next()) {
                int edgeId = iter.getEdge();
                long wayId = map.getOsmIdOfInternalEdge(edgeId);
                if ((edgeId == edgeIdFrom || osmTurnRelation.getRestriction() != OSMTurnRelation.Type.ONLY || wayId == osmTurnRelation.getOsmIdTo()) && (osmTurnRelation.getRestriction() != OSMTurnRelation.Type.NOT || wayId != osmTurnRelation.getOsmIdTo() || wayId < 0L)) continue;
                tcs.set(this.turnCostEnc, edgeIdFrom, viaNode, iter.getEdge(), Double.POSITIVE_INFINITY);
                if (osmTurnRelation.getRestriction() != OSMTurnRelation.Type.NOT) continue;
                break;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not built turn table entry for relation of node with osmId:" + osmTurnRelation.getViaOsmNodeId(), e);
        }
    }

    @Override
    public String getName() {
        return this.turnCostEnc.getName();
    }

    public String toString() {
        return this.getName();
    }
}

