/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting;

import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.weighting.TurnCostProvider;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;

public abstract class AbstractWeighting
implements Weighting {
    protected final BooleanEncodedValue accessEnc;
    protected final DecimalEncodedValue speedEnc;
    private final TurnCostProvider turnCostProvider;

    protected AbstractWeighting(BooleanEncodedValue accessEnc, DecimalEncodedValue speedEnc, TurnCostProvider turnCostProvider) {
        if (!AbstractWeighting.isValidName(this.getName())) {
            throw new IllegalStateException("Not a valid name for a Weighting: " + this.getName());
        }
        this.accessEnc = accessEnc;
        this.speedEnc = speedEnc;
        this.turnCostProvider = turnCostProvider;
    }

    @Override
    public boolean edgeHasNoAccess(EdgeIteratorState edgeState, boolean reverse) {
        return reverse ? !edgeState.getReverse(this.accessEnc) : !edgeState.get(this.accessEnc);
    }

    @Override
    public abstract double calcEdgeWeight(EdgeIteratorState var1, boolean var2);

    @Override
    public long calcEdgeMillis(EdgeIteratorState edgeState, boolean reverse) {
        double speed;
        if (edgeState.getBaseNode() == edgeState.getAdjNode()) {
            reverse = false;
        }
        if (reverse && !edgeState.getReverse(this.accessEnc) || !reverse && !edgeState.get(this.accessEnc)) {
            throw new IllegalStateException("Calculating time should not require to read speed from edge in wrong direction. (" + edgeState.getBaseNode() + " - " + edgeState.getAdjNode() + ") " + edgeState.fetchWayGeometry(FetchMode.ALL) + ", dist: " + edgeState.getDistance() + " Reverse:" + reverse + ", fwd:" + edgeState.get(this.accessEnc) + ", bwd:" + edgeState.getReverse(this.accessEnc) + ", fwd-speed: " + edgeState.get(this.speedEnc) + ", bwd-speed: " + edgeState.getReverse(this.speedEnc));
        }
        double d = speed = reverse ? edgeState.getReverse(this.speedEnc) : edgeState.get(this.speedEnc);
        if (Double.isInfinite(speed) || Double.isNaN(speed) || speed < 0.0) {
            throw new IllegalStateException("Invalid speed stored in edge! " + speed);
        }
        if (speed == 0.0) {
            throw new IllegalStateException("Speed cannot be 0 for unblocked edge, use access properties to mark edge blocked! Should only occur for shortest path calculation. See #242.");
        }
        return Math.round(edgeState.getDistance() / speed * 3.6 * 1000.0);
    }

    @Override
    public double calcTurnWeight(int inEdge, int viaNode, int outEdge) {
        return this.turnCostProvider.calcTurnWeight(inEdge, viaNode, outEdge);
    }

    @Override
    public long calcTurnMillis(int inEdge, int viaNode, int outEdge) {
        return this.turnCostProvider.calcTurnMillis(inEdge, viaNode, outEdge);
    }

    @Override
    public boolean hasTurnCosts() {
        return this.turnCostProvider != TurnCostProvider.NO_TURN_COST_PROVIDER;
    }

    public TurnCostProvider getTurnCostProvider() {
        return this.turnCostProvider;
    }

    static boolean isValidName(String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        return name.matches("[\\|_a-z]+");
    }

    public String toString() {
        return this.getName() + "|" + this.speedEnc.getName().split("$")[0];
    }
}

