/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting;

import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.RoadAccess;
import com.graphhopper.routing.util.PriorityCode;
import com.graphhopper.routing.weighting.PriorityWeighting;
import com.graphhopper.routing.weighting.TurnCostProvider;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.PMap;

public class CurvatureWeighting
extends PriorityWeighting {
    private final double minFactor;
    private final DecimalEncodedValue curvatureEnc;

    public CurvatureWeighting(BooleanEncodedValue accessEnc, DecimalEncodedValue speedEnc, DecimalEncodedValue priorityEnc, DecimalEncodedValue curvatureEnc, EnumEncodedValue<RoadAccess> roadAccessEnc, PMap pMap, TurnCostProvider turnCostProvider) {
        super(accessEnc, speedEnc, priorityEnc, roadAccessEnc, pMap, turnCostProvider);
        this.curvatureEnc = curvatureEnc;
        double minBendiness = 1.0;
        double maxSpeed = speedEnc.getMaxOrMaxStorableDecimal();
        this.minFactor = minBendiness / Math.log(maxSpeed) / PriorityCode.getValue(PriorityCode.BEST.getValue());
    }

    @Override
    public double getMinWeight(double distance) {
        return this.minFactor * distance;
    }

    @Override
    public double calcEdgeWeight(EdgeIteratorState edgeState, boolean reverse) {
        double priority = edgeState.get(this.priorityEnc);
        double bendiness = edgeState.get(this.curvatureEnc);
        double speed = this.getRoadSpeed(edgeState, reverse);
        double roadDistance = edgeState.getDistance();
        double regularWeight = roadDistance / Math.log(speed);
        return bendiness * regularWeight / priority;
    }

    protected double getRoadSpeed(EdgeIteratorState edge, boolean reverse) {
        return reverse ? edge.getReverse(this.speedEnc) : edge.get(this.speedEnc);
    }

    @Override
    public String getName() {
        return "curvature";
    }
}

