/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting;

import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.RoadAccess;
import com.graphhopper.routing.weighting.FastestWeighting;
import com.graphhopper.routing.weighting.TurnCostProvider;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.PMap;

public class ShortFastestWeighting
extends FastestWeighting {
    private static final String NAME = "short_fastest";
    private static final String TIME_FACTOR = "short_fastest.time_factor";
    private static final String DISTANCE_FACTOR = "short_fastest.distance_factor";
    private final double distanceFactor;
    private final double timeFactor;

    public ShortFastestWeighting(BooleanEncodedValue accessEnc, DecimalEncodedValue speedEnc, EnumEncodedValue<RoadAccess> roadAccessEnc, PMap map, TurnCostProvider turnCostProvider) {
        super(accessEnc, speedEnc, roadAccessEnc, map, turnCostProvider);
        this.timeFactor = ShortFastestWeighting.checkBounds(TIME_FACTOR, map.getDouble(TIME_FACTOR, 1.0), 0.0, 10.0);
        this.distanceFactor = ShortFastestWeighting.checkBounds(DISTANCE_FACTOR, map.getDouble(DISTANCE_FACTOR, 0.07), 0.0, 10.0);
        if (this.timeFactor < 1.0E-5 && this.distanceFactor < 1.0E-5) {
            throw new IllegalArgumentException("[short_fastest] one of distance_factor or time_factor has to be non-zero");
        }
    }

    @Override
    public double getMinWeight(double distance) {
        return super.getMinWeight(distance) * this.timeFactor + distance * this.distanceFactor;
    }

    @Override
    public double calcEdgeWeight(EdgeIteratorState edgeState, boolean reverse) {
        double time = super.calcEdgeWeight(edgeState, reverse);
        return time * this.timeFactor + edgeState.getDistance() * this.distanceFactor;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

