/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.CHStorage;
import com.graphhopper.storage.RoutingCHEdgeExplorer;
import com.graphhopper.storage.RoutingCHEdgeIterator;
import com.graphhopper.storage.RoutingCHEdgeIteratorStateImpl;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;

public class RoutingCHEdgeIteratorImpl
extends RoutingCHEdgeIteratorStateImpl
implements RoutingCHEdgeExplorer,
RoutingCHEdgeIterator {
    private final BaseGraph.EdgeIteratorImpl baseIterator;
    private final boolean outgoing;
    private final boolean incoming;
    private int nextEdgeId;

    public static RoutingCHEdgeIteratorImpl outEdges(CHStorage chStore, BaseGraph baseGraph, Weighting weighting) {
        return new RoutingCHEdgeIteratorImpl(chStore, baseGraph, weighting, true, false);
    }

    public static RoutingCHEdgeIteratorImpl inEdges(CHStorage chStore, BaseGraph baseGraph, Weighting weighting) {
        return new RoutingCHEdgeIteratorImpl(chStore, baseGraph, weighting, false, true);
    }

    public RoutingCHEdgeIteratorImpl(CHStorage chStore, BaseGraph baseGraph, Weighting weighting, boolean outgoing, boolean incoming) {
        super(chStore, baseGraph, new BaseGraph.EdgeIteratorImpl(baseGraph, EdgeFilter.ALL_EDGES), weighting);
        this.baseIterator = (BaseGraph.EdgeIteratorImpl)this.baseEdgeState;
        this.outgoing = outgoing;
        this.incoming = incoming;
    }

    @Override
    EdgeIteratorState edgeState() {
        return this.baseIterator;
    }

    @Override
    public RoutingCHEdgeIterator setBaseNode(int baseNode) {
        assert (this.baseGraph.isFrozen());
        this.baseIterator.setBaseNode(baseNode);
        int lastShortcut = this.store.getLastShortcut(this.store.toNodePointer(baseNode));
        this.edgeId = lastShortcut < 0 ? this.baseIterator.edgeId : this.baseGraph.getEdges() + lastShortcut;
        this.nextEdgeId = this.edgeId;
        return this;
    }

    @Override
    public boolean next() {
        while (this.nextEdgeId >= this.baseGraph.getEdges()) {
            this.shortcutPointer = this.store.toShortcutPointer(this.nextEdgeId - this.baseGraph.getEdges());
            this.baseNode = this.store.getNodeA(this.shortcutPointer);
            this.adjNode = this.store.getNodeB(this.shortcutPointer);
            this.edgeId = this.nextEdgeId--;
            if (this.nextEdgeId < this.baseGraph.getEdges() || this.store.getNodeA(this.store.toShortcutPointer(this.nextEdgeId - this.baseGraph.getEdges())) != this.baseNode) {
                this.nextEdgeId = this.baseIterator.edgeId;
            }
            if ((this.baseNode != this.adjNode || !this.store.getFwdAccess(this.shortcutPointer) && !this.store.getBwdAccess(this.shortcutPointer)) && (!this.outgoing || !this.store.getFwdAccess(this.shortcutPointer)) && (!this.incoming || !this.store.getBwdAccess(this.shortcutPointer))) continue;
            return true;
        }
        while (EdgeIterator.Edge.isValid(this.baseIterator.nextEdgeId)) {
            this.baseIterator.goToNext();
            this.edgeId = this.baseIterator.edgeId;
            if ((this.baseIterator.getBaseNode() != this.baseIterator.getAdjNode() || !this.finiteWeight(false) && !this.finiteWeight(true)) && (!this.outgoing || !this.finiteWeight(false)) && (!this.incoming || !this.finiteWeight(true))) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getEdge() + " " + this.getBaseNode() + "-" + this.getAdjNode();
    }

    private boolean finiteWeight(boolean reverse) {
        return !Double.isInfinite(this.getOrigEdgeWeight(reverse, false));
    }
}

