/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.util.DistanceCalcEarth;
import com.graphhopper.util.shapes.BBox;
import com.graphhopper.util.shapes.GHPoint;

public class DistanceCalcEuclidean
extends DistanceCalcEarth {
    @Override
    public double calcDist(double fromY, double fromX, double toY, double toX) {
        return Math.sqrt(this.calcNormalizedDist(fromY, fromX, toY, toX));
    }

    @Override
    public double calcDist3D(double fromY, double fromX, double fromHeight, double toY, double toX, double toHeight) {
        return Math.sqrt(this.calcNormalizedDist(fromY, fromX, toY, toX) + this.calcNormalizedDist(toHeight - fromHeight));
    }

    @Override
    public double calcDenormalizedDist(double normedDist) {
        return Math.sqrt(normedDist);
    }

    @Override
    public double calcNormalizedDist(double dist) {
        return dist * dist;
    }

    @Override
    double calcShrinkFactor(double a_lat_deg, double b_lat_deg) {
        return 1.0;
    }

    @Override
    public double calcNormalizedDist(double fromY, double fromX, double toY, double toX) {
        double dX = fromX - toX;
        double dY = fromY - toY;
        return dX * dX + dY * dY;
    }

    @Override
    public String toString() {
        return "2D";
    }

    @Override
    public double calcCircumference(double lat) {
        throw new UnsupportedOperationException("Not supported for the 2D Euclidean space");
    }

    @Override
    public boolean isDateLineCrossOver(double lon1, double lon2) {
        throw new UnsupportedOperationException("Not supported for the 2D Euclidean space");
    }

    @Override
    public BBox createBBox(double lat, double lon, double radiusInMeter) {
        throw new UnsupportedOperationException("Not supported for the 2D Euclidean space");
    }

    @Override
    public GHPoint projectCoordinate(double latInDeg, double lonInDeg, double distanceInMeter, double headingClockwiseFromNorth) {
        throw new UnsupportedOperationException("Not supported for the 2D Euclidean space");
    }

    @Override
    public GHPoint intermediatePoint(double f, double lat1, double lon1, double lat2, double lon2) {
        double delatLat = lat2 - lat1;
        double deltaLon = lon2 - lon1;
        double midLat = lat1 + delatLat * f;
        double midLon = lon1 + deltaLon * f;
        return new GHPoint(midLat, midLon);
    }

    @Override
    public boolean isCrossBoundary(double lon1, double lon2) {
        throw new UnsupportedOperationException("Not supported for the 2D Euclidean space");
    }

    @Override
    public double calcNormalizedEdgeDistance(double ry, double rx, double ay, double ax, double by, double bx) {
        return this.calcNormalizedEdgeDistance3D(ry, rx, 0.0, ay, ax, 0.0, by, bx, 0.0);
    }

    @Override
    public double calcNormalizedEdgeDistance3D(double ry, double rx, double rz, double ay, double ax, double az, double by, double bx, double bz) {
        double dx = bx - ax;
        double dy = by - ay;
        double dz = bz - az;
        double norm = dx * dx + dy * dy + dz * dz;
        double factor = ((rx - ax) * dx + (ry - ay) * dy + (rz - az) * dz) / norm;
        if (Double.isNaN(factor)) {
            factor = 0.0;
        }
        double cx = ax + factor * dx;
        double cy = ay + factor * dy;
        double cz = az + factor * dz;
        double rdx = cx - rx;
        double rdy = cy - ry;
        double rdz = cz - rz;
        return rdx * rdx + rdy * rdy + rdz * rdz;
    }
}

