/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util.details;

import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.ev.StringEncodedValue;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.util.details.AverageSpeedDetails;
import com.graphhopper.util.details.BooleanDetails;
import com.graphhopper.util.details.DecimalDetails;
import com.graphhopper.util.details.DistanceDetails;
import com.graphhopper.util.details.EdgeIdDetails;
import com.graphhopper.util.details.EdgeKeyDetails;
import com.graphhopper.util.details.EnumDetails;
import com.graphhopper.util.details.IntDetails;
import com.graphhopper.util.details.KVStringDetails;
import com.graphhopper.util.details.PathDetailsBuilder;
import com.graphhopper.util.details.StringDetails;
import com.graphhopper.util.details.TimeDetails;
import com.graphhopper.util.details.WeightDetails;
import java.util.ArrayList;
import java.util.List;

public class PathDetailsBuilderFactory {
    public List<PathDetailsBuilder> createPathDetailsBuilders(List<String> requestedPathDetails, EncodedValueLookup evl, Weighting weighting) {
        ArrayList<PathDetailsBuilder> builders = new ArrayList<PathDetailsBuilder>();
        if (requestedPathDetails.contains("street_name")) {
            builders.add(new KVStringDetails("street_name", "name"));
        }
        if (requestedPathDetails.contains("street_ref")) {
            builders.add(new KVStringDetails("street_ref", "ref"));
        }
        if (requestedPathDetails.contains("street_destination")) {
            builders.add(new KVStringDetails("street_destination", "destination"));
        }
        if (requestedPathDetails.contains("average_speed")) {
            builders.add(new AverageSpeedDetails(weighting));
        }
        if (requestedPathDetails.contains("edge_id")) {
            builders.add(new EdgeIdDetails());
        }
        if (requestedPathDetails.contains("edge_key")) {
            builders.add(new EdgeKeyDetails());
        }
        if (requestedPathDetails.contains("time")) {
            builders.add(new TimeDetails(weighting));
        }
        if (requestedPathDetails.contains("weight")) {
            builders.add(new WeightDetails(weighting));
        }
        if (requestedPathDetails.contains("distance")) {
            builders.add(new DistanceDetails());
        }
        for (String pathDetail : requestedPathDetails) {
            if (!evl.hasEncodedValue(pathDetail)) continue;
            EncodedValue ev = evl.getEncodedValue(pathDetail, EncodedValue.class);
            if (ev instanceof DecimalEncodedValue) {
                builders.add(new DecimalDetails(pathDetail, (DecimalEncodedValue)ev));
                continue;
            }
            if (ev instanceof BooleanEncodedValue) {
                builders.add(new BooleanDetails(pathDetail, (BooleanEncodedValue)ev));
                continue;
            }
            if (ev instanceof EnumEncodedValue) {
                builders.add(new EnumDetails(pathDetail, (EnumEncodedValue)ev));
                continue;
            }
            if (ev instanceof StringEncodedValue) {
                builders.add(new StringDetails(pathDetail, (StringEncodedValue)ev));
                continue;
            }
            if (ev instanceof IntEncodedValue) {
                builders.add(new IntDetails(pathDetail, (IntEncodedValue)ev));
                continue;
            }
            throw new IllegalArgumentException("unknown EncodedValue class " + ev.getClass().getName());
        }
        if (requestedPathDetails.size() != builders.size()) {
            throw new IllegalArgumentException("You requested the details " + requestedPathDetails + " but we could only find " + builders);
        }
        return builders;
    }
}

