/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import org.drools.core.common.FactHandleClassStore;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ObjectStore;
import org.drools.core.factmodel.traits.CoreWrapper;
import org.kie.api.runtime.ClassObjectFilter;
import org.kie.api.runtime.ObjectFilter;

public class ClassAwareObjectStore
implements Externalizable,
ObjectStore {
    private Lock lock;
    private Map<String, SingleClassStore> storesMap = new HashMap<String, SingleClassStore>();
    private List<ConcreteClassStore> concreteStores = new CopyOnWriteArrayList<ConcreteClassStore>();
    private FactHandleMap equalityMap;
    private boolean isEqualityBehaviour;
    private int size;

    public ClassAwareObjectStore() {
    }

    public ClassAwareObjectStore(boolean isEqualityBehaviour, Lock lock) {
        this.lock = lock;
        this.isEqualityBehaviour = isEqualityBehaviour;
        if (isEqualityBehaviour) {
            this.equalityMap = new FactHandleMap(false);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.storesMap);
        out.writeObject(this.concreteStores);
        out.writeObject(this.equalityMap);
        out.writeInt(this.size);
        out.writeBoolean(this.isEqualityBehaviour);
        out.writeObject(this.lock);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.storesMap = (Map)in.readObject();
        this.concreteStores = (List)in.readObject();
        this.equalityMap = (FactHandleMap)in.readObject();
        this.size = in.readInt();
        this.isEqualityBehaviour = in.readBoolean();
        this.lock = (Lock)in.readObject();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        this.storesMap.clear();
        this.concreteStores = new CopyOnWriteArrayList<ConcreteClassStore>();
        if (this.isEqualityBehaviour) {
            this.equalityMap.clear();
        }
        this.size = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObjectForHandle(InternalFactHandle handle) {
        try {
            this.lock.lock();
            InternalFactHandle reconnectedHandle = this.reconnect(handle);
            Object object = reconnectedHandle != null ? reconnectedHandle.getObject() : null;
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public InternalFactHandle reconnect(InternalFactHandle handle) {
        if (handle == null) {
            return null;
        }
        String handleClass = handle.getObjectClassName();
        if (handleClass != null) {
            SingleClassStore store = this.getClassStore(handleClass);
            if (store == null || !store.isConcrete()) {
                return null;
            }
            return handle.isNegated() ? ((ConcreteClassStore)store).getNegMap().get(handle) : ((ConcreteClassStore)store).getIdentityMap().get(handle);
        }
        if (this.isEqualityBehaviour) {
            return this.equalityMap.get(handle);
        }
        for (ConcreteClassStore stores : this.concreteStores) {
            InternalFactHandle reconnectedHandle = stores.getAssertMap().get(handle);
            if (reconnectedHandle == null) continue;
            return reconnectedHandle;
        }
        return null;
    }

    @Override
    public InternalFactHandle getHandleForObject(Object object) {
        if (object == null) {
            return null;
        }
        return this.isEqualityBehaviour ? this.equalityMap.get(object) : this.getOrCreateConcreteClassStore(object).getAssertMap().get(object);
    }

    @Override
    public InternalFactHandle getHandleForObjectIdentity(Object object) {
        return this.getOrCreateConcreteClassStore(object).getIdentityMap().get(object);
    }

    @Override
    public void updateHandle(InternalFactHandle handle, Object object) {
        this.removeHandle(handle);
        handle.setObject(object);
        this.addHandle(handle, object);
    }

    @Override
    public void addHandle(InternalFactHandle handle, Object object) {
        if (this.getOrCreateConcreteClassStore(object).addHandle(handle, object)) {
            ++this.size;
        }
    }

    @Override
    public void removeHandle(InternalFactHandle handle) {
        if (this.getOrCreateConcreteClassStore(handle.getObject()).removeHandle(handle) != null) {
            --this.size;
        }
    }

    @Override
    public Iterator<Object> iterateObjects() {
        return new CompositeObjectIterator(this.concreteStores, true);
    }

    public Iterator<Object> iterateObjects(Class<?> clazz) {
        return this.getOrCreateClassStore(clazz).objectsIterator(true);
    }

    @Override
    public Iterator<Object> iterateObjects(ObjectFilter filter) {
        if (filter instanceof ClassObjectFilter) {
            return this.getOrCreateClassStore(((ClassObjectFilter)filter).getFilteredClass()).objectsIterator(true);
        }
        return new CompositeObjectIterator(this.concreteStores, true, filter);
    }

    @Override
    public Iterator<InternalFactHandle> iterateFactHandles() {
        return new CompositeFactHandleIterator(this.concreteStores, true);
    }

    @Override
    public Iterator<InternalFactHandle> iterateFactHandles(ObjectFilter filter) {
        if (filter instanceof ClassObjectFilter) {
            return this.getOrCreateClassStore(((ClassObjectFilter)filter).getFilteredClass()).factHandlesIterator(true);
        }
        return new CompositeFactHandleIterator(this.concreteStores, true, filter);
    }

    @Override
    public Iterator<Object> iterateNegObjects(ObjectFilter filter) {
        if (filter instanceof ClassObjectFilter) {
            return this.getOrCreateClassStore(((ClassObjectFilter)filter).getFilteredClass()).objectsIterator(false);
        }
        return new CompositeObjectIterator(this.concreteStores, false, filter);
    }

    @Override
    public Iterator<InternalFactHandle> iterateNegFactHandles(ObjectFilter filter) {
        if (filter instanceof ClassObjectFilter) {
            return this.getOrCreateClassStore(((ClassObjectFilter)filter).getFilteredClass()).factHandlesIterator(false);
        }
        return new CompositeFactHandleIterator(this.concreteStores, false, filter);
    }

    @Override
    public FactHandleClassStore getStoreForClass(Class<?> clazz) {
        return this.getOrCreateClassStore(clazz);
    }

    @Override
    public boolean clearClassStore(Class<?> clazz) {
        return this.storesMap.remove(clazz.getName()) != null;
    }

    private SingleClassStore getClassStore(String className) {
        return this.storesMap.get(className);
    }

    public static Class<?> getActualClass(Object object) {
        return object instanceof CoreWrapper ? ((CoreWrapper)object).getCore().getClass() : object.getClass();
    }

    public SingleClassStore getOrCreateClassStore(Class<?> clazz) {
        SingleClassStore store = this.storesMap.get(clazz.getName());
        if (store == null) {
            store = this.createClassStoreAndAddConcreteSubStores(clazz);
            this.storesMap.put(clazz.getName(), store);
        }
        return store;
    }

    private ConcreteClassStore getOrCreateConcreteClassStore(Object object) {
        return this.getOrCreateConcreteClassStore(ClassAwareObjectStore.getActualClass(object));
    }

    private ConcreteClassStore getOrCreateConcreteClassStore(Class<?> clazz) {
        SingleClassStore existingStore = this.getOrCreateClassStore(clazz);
        if (existingStore.isConcrete()) {
            return (ConcreteClassStore)existingStore;
        }
        return this.makeStoreConcrete(existingStore);
    }

    private ConcreteClassStore makeStoreConcrete(SingleClassStore storeToMakeConcrete) {
        ConcreteClassStore store = storeToMakeConcrete.makeConcrete();
        Class<?> storedClass = storeToMakeConcrete.getStoredClass();
        for (SingleClassStore classStore : this.storesMap.values()) {
            if (!classStore.getStoredClass().isAssignableFrom(storedClass)) continue;
            classStore.addConcreteStore(store);
        }
        this.concreteStores.add(store);
        return store;
    }

    private SingleClassStore createClassStoreAndAddConcreteSubStores(Class<?> clazz) {
        ConcreteIdentityClassStore newStore = this.isEqualityBehaviour ? new ConcreteEqualityClassStore(clazz, this.equalityMap) : new ConcreteIdentityClassStore(clazz);
        for (SingleClassStore classStore : this.storesMap.values()) {
            if (!classStore.isConcrete() || !clazz.isAssignableFrom(classStore.getStoredClass())) continue;
            newStore.addConcreteStore((ConcreteClassStore)classStore);
        }
        return newStore;
    }

    private static class FactHandleMap
    implements Externalizable {
        private Map<Object, InternalFactHandle> facts;
        private Map<Long, InternalFactHandle> factsById;

        public FactHandleMap() {
        }

        public FactHandleMap(boolean identity) {
            this.facts = identity ? new IdentityHashMap() : new HashMap();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.facts);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.facts = (Map)in.readObject();
        }

        public InternalFactHandle get(Object obj) {
            return this.facts.get(obj);
        }

        public InternalFactHandle put(Object obj, InternalFactHandle fh) {
            InternalFactHandle existing = this.facts.put(obj, fh);
            if (this.factsById != null) {
                this.factsById.put(fh.getId(), fh);
            }
            return existing;
        }

        public InternalFactHandle get(InternalFactHandle fh) {
            return fh.isDisconnected() ? this.factsIndexedById().get(fh.getId()) : this.facts.get(fh.getObject());
        }

        public InternalFactHandle remove(InternalFactHandle fh) {
            InternalFactHandle retrieved = this.facts.remove(fh.getObject());
            if (this.factsById != null) {
                this.factsById.remove(fh.getId());
            }
            return retrieved;
        }

        private Map<Long, InternalFactHandle> factsIndexedById() {
            if (this.factsById == null) {
                this.factsById = new HashMap<Long, InternalFactHandle>();
                for (InternalFactHandle fh : this.facts.values()) {
                    this.factsById.put(fh.getId(), fh);
                }
            }
            return this.factsById;
        }

        public Collection<Object> getObjects() {
            return this.facts.keySet();
        }

        public Collection<InternalFactHandle> getFacts() {
            return this.facts.values();
        }

        public void clear() {
            this.facts.clear();
            this.factsById = null;
        }
    }

    private static class CompositeFactHandleIterator
    extends AbstractCompositeIterator<InternalFactHandle> {
        private CompositeFactHandleIterator(Iterable<ConcreteClassStore> stores, boolean assrt) {
            super(stores, assrt);
        }

        private CompositeFactHandleIterator(Iterable<ConcreteClassStore> stores, boolean assrt, ObjectFilter filter) {
            super(stores, assrt, filter);
        }

        @Override
        protected void fetchNextIterator() {
            if (this.assrt) {
                this.currentIterator = ((ConcreteClassStore)this.stores.next()).getIdentityMap().getFacts().iterator();
            } else {
                FactHandleMap negMap = ((ConcreteClassStore)this.stores.next()).getNegMap();
                while (negMap == null && this.stores.hasNext()) {
                    negMap = ((ConcreteClassStore)this.stores.next()).getNegMap();
                }
                this.currentIterator = negMap != null ? negMap.getFacts().iterator() : null;
            }
        }

        @Override
        protected boolean accept() {
            return this.filter.accept(((InternalFactHandle)this.currentNext).getObject());
        }
    }

    private static class CompositeObjectIterator
    extends AbstractCompositeIterator<Object> {
        private CompositeObjectIterator(Iterable<ConcreteClassStore> stores, boolean assrt) {
            super(stores, assrt);
        }

        private CompositeObjectIterator(Iterable<ConcreteClassStore> stores, boolean assrt, ObjectFilter filter) {
            super(stores, assrt, filter);
        }

        @Override
        protected void fetchNextIterator() {
            if (this.assrt) {
                this.currentIterator = ((ConcreteClassStore)this.stores.next()).getIdentityMap().getObjects().iterator();
            } else {
                FactHandleMap negMap = ((ConcreteClassStore)this.stores.next()).getNegMap();
                while (negMap == null && this.stores.hasNext()) {
                    negMap = ((ConcreteClassStore)this.stores.next()).getNegMap();
                }
                this.currentIterator = negMap != null ? negMap.getObjects().iterator() : null;
            }
        }

        @Override
        protected boolean accept() {
            return this.filter.accept(this.currentNext);
        }
    }

    private static abstract class AbstractCompositeIterator<T>
    implements Iterator<T> {
        protected final Iterator<ConcreteClassStore> stores;
        protected final boolean assrt;
        protected final ObjectFilter filter;
        protected Iterator<T> currentIterator;
        protected T currentNext;

        private AbstractCompositeIterator(Iterable<ConcreteClassStore> stores, boolean assrt) {
            this(stores, assrt, null);
        }

        private AbstractCompositeIterator(Iterable<ConcreteClassStore> stores, boolean assrt, ObjectFilter filter) {
            this.stores = stores.iterator();
            this.assrt = assrt;
            this.filter = filter;
            this.fetchNext();
        }

        private void fetchNext() {
            while (this.currentNext == null) {
                this.nextIterator();
                if (this.currentIterator == null) break;
                this.currentNext = this.currentIterator.next();
                if (this.filter == null || this.accept()) continue;
                this.currentNext = null;
            }
        }

        private void nextIterator() {
            while (this.currentIterator == null || !this.currentIterator.hasNext()) {
                if (this.stores.hasNext()) {
                    this.fetchNextIterator();
                    continue;
                }
                this.currentIterator = null;
                break;
            }
        }

        protected abstract void fetchNextIterator();

        protected abstract boolean accept();

        @Override
        public boolean hasNext() {
            return this.currentNext != null;
        }

        @Override
        public T next() {
            T next = this.currentNext;
            this.currentNext = null;
            this.fetchNext();
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ConcreteEqualityClassStore
    extends ConcreteIdentityClassStore {
        private FactHandleMap equalityMap;

        public ConcreteEqualityClassStore() {
        }

        public ConcreteEqualityClassStore(Class<?> storedClass, FactHandleMap equalityMap) {
            super(storedClass);
            this.equalityMap = equalityMap;
        }

        @Override
        public boolean addHandle(InternalFactHandle handle, Object object) {
            boolean isNew = super.addHandle(handle, object);
            this.equalityMap.put(object, handle);
            return isNew;
        }

        @Override
        public InternalFactHandle removeHandle(InternalFactHandle handle) {
            InternalFactHandle removedHandle = super.removeHandle(handle);
            this.equalityMap.remove(handle);
            return removedHandle;
        }

        @Override
        public FactHandleMap getAssertMap() {
            return this.equalityMap;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeObject(this.equalityMap);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.equalityMap = (FactHandleMap)in.readObject();
        }
    }

    private static class ConcreteIdentityClassStore
    extends AbstractClassStore
    implements ConcreteClassStore {
        private FactHandleMap identityMap;
        private FactHandleMap negMap;

        public ConcreteIdentityClassStore() {
        }

        public ConcreteIdentityClassStore(Class<?> storedClass) {
            super(storedClass);
        }

        @Override
        public boolean addHandle(InternalFactHandle handle, Object object) {
            if (handle.isNegated()) {
                if (this.negMap == null) {
                    this.negMap = new FactHandleMap(true);
                }
                this.negMap.put(object, handle);
                return false;
            }
            return this.identityMap.put(object, handle) == null;
        }

        @Override
        public InternalFactHandle removeHandle(InternalFactHandle handle) {
            if (handle.isNegated()) {
                if (this.negMap == null) {
                    this.negMap = new FactHandleMap(true);
                }
                this.negMap.remove(handle);
                return null;
            }
            return this.identityMap.remove(handle);
        }

        @Override
        public FactHandleMap getAssertMap() {
            return this.identityMap;
        }

        @Override
        public FactHandleMap getNegMap() {
            return this.negMap;
        }

        @Override
        public FactHandleMap getIdentityMap() {
            return this.identityMap;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeObject(this.identityMap);
            out.writeObject(this.negMap);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.identityMap = (FactHandleMap)in.readObject();
            this.negMap = (FactHandleMap)in.readObject();
        }

        @Override
        public boolean isConcrete() {
            return this.identityMap != null;
        }

        @Override
        public ConcreteClassStore makeConcrete() {
            this.identityMap = new FactHandleMap(true);
            return this;
        }
    }

    private static interface ConcreteClassStore
    extends SingleClassStore {
        public boolean addHandle(InternalFactHandle var1, Object var2);

        public InternalFactHandle removeHandle(InternalFactHandle var1);

        public FactHandleMap getAssertMap();

        public FactHandleMap getIdentityMap();

        public FactHandleMap getNegMap();
    }

    private static abstract class AbstractClassStore
    implements SingleClassStore {
        private Class<?> storedClass;
        private List<ConcreteClassStore> concreteStores = new ArrayList<ConcreteClassStore>();

        public AbstractClassStore() {
        }

        private AbstractClassStore(Class<?> storedClass) {
            this.storedClass = storedClass;
        }

        @Override
        public void addConcreteStore(ConcreteClassStore store) {
            this.concreteStores.add(store);
        }

        @Override
        public Iterator<Object> objectsIterator(boolean assrt) {
            return new CompositeObjectIterator(this.concreteStores, assrt);
        }

        @Override
        public Iterator<InternalFactHandle> factHandlesIterator(boolean assrt) {
            return new CompositeFactHandleIterator(this.concreteStores, assrt);
        }

        @Override
        public Class<?> getStoredClass() {
            return this.storedClass;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.storedClass);
            out.writeObject(this.concreteStores);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.storedClass = (Class)in.readObject();
            this.concreteStores = (List)in.readObject();
        }

        public String toString() {
            return "Object store for class: " + this.storedClass;
        }
    }

    public static interface SingleClassStore
    extends Externalizable,
    FactHandleClassStore {
        public Class<?> getStoredClass();

        public void addConcreteStore(ConcreteClassStore var1);

        public Iterator<Object> objectsIterator(boolean var1);

        public Iterator<InternalFactHandle> factHandlesIterator(boolean var1);

        public boolean isConcrete();

        public ConcreteClassStore makeConcrete();

        @Override
        default public Iterator<InternalFactHandle> iterator() {
            return this.factHandlesIterator(true);
        }
    }
}

