/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.hardsoft;

import java.util.Objects;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.score.ScoreUtil;

public final class HardSoftScore
implements Score<HardSoftScore> {
    public static final HardSoftScore ZERO = new HardSoftScore(0, 0, 0);
    public static final HardSoftScore ONE_HARD = new HardSoftScore(0, 1, 0);
    public static final HardSoftScore ONE_SOFT = new HardSoftScore(0, 0, 1);
    private final int initScore;
    private final int hardScore;
    private final int softScore;

    public static HardSoftScore parseScore(String scoreString) {
        String[] scoreTokens = ScoreUtil.parseScoreTokens(HardSoftScore.class, scoreString, "hard", "soft");
        int initScore = ScoreUtil.parseInitScore(HardSoftScore.class, scoreString, scoreTokens[0]);
        int hardScore = ScoreUtil.parseLevelAsInt(HardSoftScore.class, scoreString, scoreTokens[1]);
        int softScore = ScoreUtil.parseLevelAsInt(HardSoftScore.class, scoreString, scoreTokens[2]);
        return HardSoftScore.ofUninitialized(initScore, hardScore, softScore);
    }

    public static HardSoftScore ofUninitialized(int initScore, int hardScore, int softScore) {
        return new HardSoftScore(initScore, hardScore, softScore);
    }

    public static HardSoftScore of(int hardScore, int softScore) {
        return new HardSoftScore(0, hardScore, softScore);
    }

    public static HardSoftScore ofHard(int hardScore) {
        return HardSoftScore.of(hardScore, 0);
    }

    public static HardSoftScore ofSoft(int softScore) {
        return HardSoftScore.of(0, softScore);
    }

    private HardSoftScore() {
        this(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    private HardSoftScore(int initScore, int hardScore, int softScore) {
        this.initScore = initScore;
        this.hardScore = hardScore;
        this.softScore = softScore;
    }

    @Override
    public int initScore() {
        return this.initScore;
    }

    public int hardScore() {
        return this.hardScore;
    }

    @Deprecated(forRemoval=true)
    public int getHardScore() {
        return this.hardScore;
    }

    public int softScore() {
        return this.softScore;
    }

    @Deprecated(forRemoval=true)
    public int getSoftScore() {
        return this.softScore;
    }

    @Override
    public HardSoftScore withInitScore(int newInitScore) {
        return new HardSoftScore(newInitScore, this.hardScore, this.softScore);
    }

    @Override
    public boolean isFeasible() {
        return this.initScore >= 0 && this.hardScore >= 0;
    }

    @Override
    public HardSoftScore add(HardSoftScore addend) {
        return new HardSoftScore(this.initScore + addend.initScore(), this.hardScore + addend.hardScore(), this.softScore + addend.getSoftScore());
    }

    @Override
    public HardSoftScore subtract(HardSoftScore subtrahend) {
        return new HardSoftScore(this.initScore - subtrahend.initScore(), this.hardScore - subtrahend.hardScore(), this.softScore - subtrahend.getSoftScore());
    }

    @Override
    public HardSoftScore multiply(double multiplicand) {
        return new HardSoftScore((int)Math.floor((double)this.initScore * multiplicand), (int)Math.floor((double)this.hardScore * multiplicand), (int)Math.floor((double)this.softScore * multiplicand));
    }

    @Override
    public HardSoftScore divide(double divisor) {
        return new HardSoftScore((int)Math.floor((double)this.initScore / divisor), (int)Math.floor((double)this.hardScore / divisor), (int)Math.floor((double)this.softScore / divisor));
    }

    @Override
    public HardSoftScore power(double exponent) {
        return new HardSoftScore((int)Math.floor(Math.pow(this.initScore, exponent)), (int)Math.floor(Math.pow(this.hardScore, exponent)), (int)Math.floor(Math.pow(this.softScore, exponent)));
    }

    @Override
    public HardSoftScore abs() {
        return new HardSoftScore(Math.abs(this.initScore), Math.abs(this.hardScore), Math.abs(this.softScore));
    }

    @Override
    public HardSoftScore zero() {
        return ZERO;
    }

    @Override
    public Number[] toLevelNumbers() {
        return new Number[]{this.hardScore, this.softScore};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof HardSoftScore) {
            HardSoftScore other = (HardSoftScore)o;
            return this.initScore == other.initScore() && this.hardScore == other.hardScore() && this.softScore == other.getSoftScore();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.initScore, this.hardScore, this.softScore);
    }

    @Override
    public int compareTo(HardSoftScore other) {
        if (this.initScore != other.initScore()) {
            return Integer.compare(this.initScore, other.initScore());
        }
        if (this.hardScore != other.hardScore()) {
            return Integer.compare(this.hardScore, other.hardScore());
        }
        return Integer.compare(this.softScore, other.getSoftScore());
    }

    @Override
    public String toShortString() {
        return ScoreUtil.buildShortString(this, n -> n.intValue() != 0, "hard", "soft");
    }

    public String toString() {
        return ScoreUtil.getInitPrefix(this.initScore) + this.hardScore + "hard/" + this.softScore + "soft";
    }
}

